/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiModifierListOwner;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.AddToIgnoreIfAnnotatedByListQuickFix;
import com.siyeh.ig.psiutils.UtilityClassUtil;
import com.siyeh.ig.ui.ExternalizableStringSet;
import org.jetbrains.annotations.NotNull;

public class UtilityClassInspectionBase
extends BaseInspection {
    public final ExternalizableStringSet ignorableAnnotations = new ExternalizableStringSet(new String[0]);

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("utility.class.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/classlayout/UtilityClassInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("utility.class.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/classlayout/UtilityClassInspectionBase", "buildErrorString"));
        }
        return string;
    }

    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos) {
        InspectionGadgetsFix[] inspectionGadgetsFixArray = AddToIgnoreIfAnnotatedByListQuickFix.build((PsiModifierListOwner)infos[0], this.ignorableAnnotations);
        if (inspectionGadgetsFixArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/classlayout/UtilityClassInspectionBase", "buildFixes"));
        }
        return inspectionGadgetsFixArray;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UtilityClassVisitor();
    }

    private class UtilityClassVisitor
    extends BaseInspectionVisitor {
        private UtilityClassVisitor() {
        }

        @Override
        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/classlayout/UtilityClassInspectionBase$UtilityClassVisitor", "visitClass"));
            }
            if (!UtilityClassUtil.isUtilityClass(aClass)) {
                return;
            }
            if (AnnotationUtil.isAnnotated(aClass, UtilityClassInspectionBase.this.ignorableAnnotations)) {
                return;
            }
            this.registerClassError(aClass, aClass);
        }
    }
}

