/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SimplifiableConditionalExpressionInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("simplifiable.conditional.expression.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/SimplifiableConditionalExpressionInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiConditionalExpression expression = (PsiConditionalExpression)infos[0];
        String string = InspectionGadgetsBundle.message("simplifiable.conditional.expression.problem.descriptor", SimplifiableConditionalExpressionInspection.calculateReplacementExpression(expression));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/SimplifiableConditionalExpressionInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new SimplifiableConditionalFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SimplifiableConditionalExpressionVisitor();
    }

    @NonNls
    static String calculateReplacementExpression(PsiConditionalExpression expression) {
        PsiExpression thenExpression = expression.getThenExpression();
        PsiExpression elseExpression = expression.getElseExpression();
        PsiExpression condition = expression.getCondition();
        assert (thenExpression != null);
        assert (elseExpression != null);
        if (EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(BoolUtils.getNegated(thenExpression), elseExpression)) {
            return ParenthesesUtils.getText(condition, 9) + " != " + BoolUtils.getNegatedExpressionText(thenExpression, 9);
        }
        if (EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(thenExpression, BoolUtils.getNegated(elseExpression))) {
            return ParenthesesUtils.getText(condition, 9) + " == " + ParenthesesUtils.getText(thenExpression, 9);
        }
        if (BoolUtils.isTrue(thenExpression)) {
            String elseExpressionText = ParenthesesUtils.getText(elseExpression, 14);
            return ParenthesesUtils.getText(condition, 14) + " || " + elseExpressionText;
        }
        if (BoolUtils.isFalse(thenExpression)) {
            String elseExpressionText = ParenthesesUtils.getText(elseExpression, 13);
            return BoolUtils.getNegatedExpressionText(condition, 13) + " && " + elseExpressionText;
        }
        if (BoolUtils.isFalse(elseExpression)) {
            String thenExpressionText = ParenthesesUtils.getText(thenExpression, 13);
            return ParenthesesUtils.getText(condition, 13) + " && " + thenExpressionText;
        }
        String thenExpressionText = ParenthesesUtils.getText(thenExpression, 14);
        return BoolUtils.getNegatedExpressionText(condition, 14) + " || " + thenExpressionText;
    }

    private static class SimplifiableConditionalExpressionVisitor
    extends BaseInspectionVisitor {
        private SimplifiableConditionalExpressionVisitor() {
        }

        @Override
        public void visitConditionalExpression(PsiConditionalExpression expression) {
            boolean elseConstant;
            super.visitConditionalExpression(expression);
            PsiExpression thenExpression = expression.getThenExpression();
            if (thenExpression == null) {
                return;
            }
            PsiExpression elseExpression = expression.getElseExpression();
            if (elseExpression == null) {
                return;
            }
            PsiType thenType = thenExpression.getType();
            if (!PsiType.BOOLEAN.equals(thenType)) {
                return;
            }
            PsiType elseType = elseExpression.getType();
            if (!PsiType.BOOLEAN.equals(elseType)) {
                return;
            }
            boolean thenConstant = BoolUtils.isFalse(thenExpression) || BoolUtils.isTrue(thenExpression);
            boolean bl = elseConstant = BoolUtils.isFalse(elseExpression) || BoolUtils.isTrue(elseExpression);
            if (thenConstant == elseConstant) {
                if (EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(BoolUtils.getNegated(thenExpression), elseExpression) || EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(thenExpression, BoolUtils.getNegated(elseExpression))) {
                    this.registerError((PsiElement)expression, expression);
                }
                return;
            }
            this.registerError((PsiElement)expression, expression);
        }
    }

    private static class SimplifiableConditionalFix
    extends InspectionGadgetsFix {
        private SimplifiableConditionalFix() {
        }

        @Override
        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("constant.conditional.expression.simplify.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/SimplifiableConditionalExpressionInspection$SimplifiableConditionalFix", "getName"));
            }
            return string;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/SimplifiableConditionalExpressionInspection$SimplifiableConditionalFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiConditionalExpression expression = (PsiConditionalExpression)descriptor.getPsiElement();
            String newExpression = SimplifiableConditionalExpressionInspection.calculateReplacementExpression(expression);
            PsiReplacementUtil.replaceExpression(expression, newExpression);
        }
    }
}

