/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import org.jetbrains.annotations.NotNull;

class CatchParameterUsedVisitor
extends JavaRecursiveElementWalkingVisitor {
    private final PsiParameter parameter;
    private boolean used;

    CatchParameterUsedVisitor(PsiParameter variable) {
        this.parameter = variable;
    }

    @Override
    public void visitElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/errorhandling/CatchParameterUsedVisitor", "visitElement"));
        }
        if (!this.used) {
            super.visitElement(element);
        }
    }

    @Override
    public void visitReferenceExpression(@NotNull PsiReferenceExpression reference) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/siyeh/ig/errorhandling/CatchParameterUsedVisitor", "visitReferenceExpression"));
        }
        if (this.used) {
            return;
        }
        super.visitReferenceExpression(reference);
        PsiElement element = reference.resolve();
        if (this.parameter.equals(element)) {
            this.used = true;
        }
    }

    public boolean isUsed() {
        return this.used;
    }
}

