/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.DefUseUtil;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.psiutils.VariableSearchUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnnecessaryInitCauseInspectionBase
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unnecessary.initcause.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/errorhandling/UnnecessaryInitCauseInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("unnecessary.initcause.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/errorhandling/UnnecessaryInitCauseInspectionBase", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryInitCauseVisitor();
    }

    @Nullable
    static PsiNewExpression findNewExpression(PsiExpression expression) {
        if (expression instanceof PsiNewExpression) {
            return (PsiNewExpression)expression;
        }
        if (expression instanceof PsiReferenceExpression) {
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression;
            PsiExpression definition = VariableSearchUtils.findDefinition(referenceExpression, null);
            if (!(definition instanceof PsiNewExpression)) {
                return null;
            }
            return (PsiNewExpression)definition;
        }
        return null;
    }

    private static class UnnecessaryInitCauseVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryInitCauseVisitor() {
        }

        @Override
        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String name = methodExpression.getReferenceName();
            if (!"initCause".equals(name)) {
                return;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            PsiExpression argument = ExpressionUtils.getOnlyExpressionInList(argumentList);
            if (!TypeUtils.expressionHasTypeOrSubtype(argument, "java.lang.Throwable")) {
                return;
            }
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null || !"java.lang.Throwable".equals(aClass.getQualifiedName())) {
                return;
            }
            PsiExpression qualifier = ParenthesesUtils.stripParentheses(methodExpression.getQualifierExpression());
            PsiNewExpression newExpression = UnnecessaryInitCauseInspectionBase.findNewExpression(qualifier);
            if (!UnnecessaryInitCauseVisitor.isCauseConstructorAvailable(newExpression) || !UnnecessaryInitCauseVisitor.canExpressionBeMovedBackwards(argument, newExpression)) {
                return;
            }
            this.registerMethodCallError(expression, new Object[0]);
        }

        private static boolean canExpressionBeMovedBackwards(final PsiExpression cause, PsiExpression newLocation) {
            if (cause == null || newLocation == null) {
                return false;
            }
            assert (cause.getTextOffset() > newLocation.getTextOffset());
            final PsiCodeBlock block = PsiTreeUtil.getParentOfType((PsiElement)cause, PsiCodeBlock.class);
            PsiCodeBlock newBlock = PsiTreeUtil.getParentOfType((PsiElement)newLocation, PsiCodeBlock.class);
            if (block == null || newBlock == null || !PsiTreeUtil.isAncestor(block, newBlock, false)) {
                return false;
            }
            final int offset = newLocation.getTextOffset();
            final Ref<Boolean> result = new Ref<Boolean>(Boolean.TRUE);
            cause.accept(new JavaRecursiveElementWalkingVisitor(){

                @Override
                public void visitReferenceExpression(PsiReferenceExpression expression) {
                    PsiElement[] defs;
                    if (!((Boolean)result.get()).booleanValue()) {
                        return;
                    }
                    super.visitReferenceExpression(expression);
                    PsiElement target = expression.resolve();
                    if (!(target instanceof PsiVariable)) {
                        return;
                    }
                    for (PsiElement def : defs = DefUseUtil.getDefs(block, (PsiVariable)target, cause)) {
                        if (def.getTextOffset() <= offset) continue;
                        result.set(Boolean.FALSE);
                    }
                }
            });
            return result.get();
        }

        public static boolean isCauseConstructorAvailable(PsiNewExpression newExpression) {
            if (newExpression == null) {
                return false;
            }
            PsiMethod constructor = newExpression.resolveConstructor();
            if (constructor == null) {
                return false;
            }
            PsiClass aClass = constructor.getContainingClass();
            if (aClass == null) {
                return false;
            }
            PsiExpressionList argumentList = newExpression.getArgumentList();
            if (argumentList == null) {
                return false;
            }
            PsiExpression[] arguments = argumentList.getExpressions();
            block0: for (PsiMethod constructor1 : aClass.getConstructors()) {
                PsiParameterList parameterList = constructor1.getParameterList();
                if (parameterList.getParametersCount() != arguments.length + 1) continue;
                PsiParameter[] parameters = parameterList.getParameters();
                for (int i = 0; i < arguments.length; ++i) {
                    PsiExpression argument = arguments[i];
                    PsiParameter parameter = parameters[i];
                    PsiType type = argument.getType();
                    if (type == null || !parameter.getType().isAssignableFrom(type)) continue block0;
                }
                PsiParameter lastParameter = parameters[parameters.length - 1];
                PsiType type = lastParameter.getType();
                if (!InheritanceUtil.isInheritor(type, "java.lang.Throwable")) continue;
                return true;
            }
            return false;
        }
    }
}

