/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.j2me;

import com.intellij.psi.PsiClass;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.InheritanceUtil;
import org.jetbrains.annotations.NotNull;

public class InterfaceWithOnlyOneDirectInheritorInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("interface.one.inheritor.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/j2me/InterfaceWithOnlyOneDirectInheritorInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("interface.one.inheritor.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/j2me/InterfaceWithOnlyOneDirectInheritorInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new InterfaceWithOnlyOneDirectInheritorVisitor();
    }

    private static class InterfaceWithOnlyOneDirectInheritorVisitor
    extends BaseInspectionVisitor {
        private InterfaceWithOnlyOneDirectInheritorVisitor() {
        }

        @Override
        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/j2me/InterfaceWithOnlyOneDirectInheritorInspection$InterfaceWithOnlyOneDirectInheritorVisitor", "visitClass"));
            }
            if (!aClass.isInterface() || aClass.isAnnotationType()) {
                return;
            }
            if (!InheritanceUtil.hasOneInheritor(aClass)) {
                return;
            }
            this.registerClassError(aClass, new Object[0]);
        }
    }
}

