/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ConstantJUnitAssertArgumentInspection
extends BaseInspection {
    @NonNls
    private static final Set<String> ASSERT_METHODS = new HashSet<String>();

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("constant.junit.assert.argument.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/ConstantJUnitAssertArgumentInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("constant.junit.assert.argument.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/ConstantJUnitAssertArgumentInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ConstantJUnitAssertArgumentVisitor();
    }

    static {
        ASSERT_METHODS.add("assertTrue");
        ASSERT_METHODS.add("assertFalse");
        ASSERT_METHODS.add("assertNull");
        ASSERT_METHODS.add("assertNotNull");
    }

    private static class ConstantJUnitAssertArgumentVisitor
    extends BaseInspectionVisitor {
        private ConstantJUnitAssertArgumentVisitor() {
        }

        @Override
        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!ASSERT_METHODS.contains(methodName)) {
                return;
            }
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (!InheritanceUtil.isInheritor(containingClass, "junit.framework.Assert") && !InheritanceUtil.isInheritor(containingClass, "org.junit.Assert")) {
                return;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length == 0) {
                return;
            }
            PsiExpression lastArgument = arguments[arguments.length - 1];
            if (!PsiUtil.isConstantExpression(lastArgument)) {
                return;
            }
            this.registerError((PsiElement)lastArgument, new Object[0]);
        }
    }
}

