/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.maturity;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiReferenceExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class SystemOutErrInspectionBase
extends BaseInspection {
    @Override
    @NotNull
    public String getID() {
        if ("UseOfSystemOutOrSystemErr" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/maturity/SystemOutErrInspectionBase", "getID"));
        }
        return "UseOfSystemOutOrSystemErr";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("use.system.out.err.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/maturity/SystemOutErrInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("use.system.out.err.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/maturity/SystemOutErrInspectionBase", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SystemOutErrVisitor();
    }

    private static class SystemOutErrVisitor
    extends BaseInspectionVisitor {
        private SystemOutErrVisitor() {
        }

        @Override
        public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/maturity/SystemOutErrInspectionBase$SystemOutErrVisitor", "visitReferenceExpression"));
            }
            super.visitReferenceExpression(expression);
            String name = expression.getReferenceName();
            if (!"out".equals(name) && !"err".equals(name)) {
                return;
            }
            PsiElement referent = expression.resolve();
            if (!(referent instanceof PsiField)) {
                return;
            }
            PsiField field = (PsiField)referent;
            PsiClass containingClass = field.getContainingClass();
            if (containingClass == null) {
                return;
            }
            String className = containingClass.getQualifiedName();
            if (!"java.lang.System".equals(className)) {
                return;
            }
            this.registerError((PsiElement)expression, expression);
        }
    }
}

