/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.codeInspection.ui.ConventionOptionsPanel;
import com.intellij.openapi.util.InvalidDataException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class ConventionInspection
extends BaseInspection {
    public static final JComponent[] EMPTY_JCOMPONENT_ARRAY = new JComponent[0];
    public String m_regex = this.getDefaultRegex();
    public int m_minLength = this.getDefaultMinLength();
    public int m_maxLength = this.getDefaultMaxLength();
    protected Pattern m_regexPattern = Pattern.compile(this.m_regex);

    @Override
    @NotNull
    protected final String buildErrorString(Object ... infos) {
        String name = (String)infos[0];
        int length = name.length();
        if (length < this.getMinLength()) {
            String string = InspectionGadgetsBundle.message("naming.convention.problem.descriptor.short", this.getElementDescription(), length, this.getMinLength());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/naming/ConventionInspection", "buildErrorString"));
            }
            return string;
        }
        if (this.getMaxLength() > 0 && length > this.getMaxLength()) {
            String string = InspectionGadgetsBundle.message("naming.convention.problem.descriptor.long", this.getElementDescription(), length, this.getMaxLength());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/naming/ConventionInspection", "buildErrorString"));
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("naming.convention.problem.descriptor.regex.mismatch", this.getElementDescription(), this.getRegex());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/naming/ConventionInspection", "buildErrorString"));
        }
        return string;
    }

    protected abstract String getElementDescription();

    @NonNls
    protected abstract String getDefaultRegex();

    protected abstract int getDefaultMinLength();

    protected abstract int getDefaultMaxLength();

    protected String getRegex() {
        return this.m_regex;
    }

    protected int getMinLength() {
        return this.m_minLength;
    }

    protected int getMaxLength() {
        return this.m_maxLength;
    }

    protected boolean isValid(String name) {
        int length = name.length();
        if (length < this.m_minLength) {
            return false;
        }
        if (this.m_maxLength > 0 && length > this.m_maxLength) {
            return false;
        }
        if ("serialVersionUID".equals(name)) {
            return true;
        }
        Matcher matcher = this.m_regexPattern.matcher(name);
        return matcher.matches();
    }

    @Override
    public void readSettings(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/naming/ConventionInspection", "readSettings"));
        }
        super.readSettings(element);
        this.m_regexPattern = Pattern.compile(this.m_regex);
    }

    public JComponent[] createExtraOptions() {
        return EMPTY_JCOMPONENT_ARRAY;
    }

    @Override
    public final JComponent createOptionsPanel() {
        return new ConventionOptionsPanel(this, "m_minLength", "m_maxLength", "m_regex", "m_regexPattern", this.createExtraOptions());
    }
}

