/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import org.jetbrains.annotations.NotNull;

class CanBeStaticVisitor
extends JavaRecursiveElementWalkingVisitor {
    private boolean canBeStatic = true;

    CanBeStaticVisitor() {
    }

    @Override
    public void visitElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/performance/CanBeStaticVisitor", "visitElement"));
        }
        if (this.canBeStatic) {
            super.visitElement(element);
        }
    }

    @Override
    public void visitReferenceExpression(@NotNull PsiReferenceExpression ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/siyeh/ig/performance/CanBeStaticVisitor", "visitReferenceExpression"));
        }
        if (!this.canBeStatic) {
            return;
        }
        super.visitReferenceExpression(ref);
        PsiElement element = ref.resolve();
        if (element instanceof PsiModifierListOwner && !((PsiModifierListOwner)element).hasModifierProperty("static")) {
            this.canBeStatic = false;
        }
    }

    public boolean canBeStatic() {
        return this.canBeStatic;
    }
}

