/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class MapReplaceableByEnumMapInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("map.replaceable.by.enum.map.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/MapReplaceableByEnumMapInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("map.replaceable.by.enum.map.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/MapReplaceableByEnumMapInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SetReplaceableByEnumSetVisitor();
    }

    private static class SetReplaceableByEnumSetVisitor
    extends BaseInspectionVisitor {
        private SetReplaceableByEnumSetVisitor() {
        }

        @Override
        public void visitNewExpression(@NotNull PsiNewExpression expression) {
            PsiExpression[] arguments;
            PsiMember member;
            PsiType[] typeArguments;
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/performance/MapReplaceableByEnumMapInspection$SetReplaceableByEnumSetVisitor", "visitNewExpression"));
            }
            super.visitNewExpression(expression);
            PsiType type = expression.getType();
            if (!(type instanceof PsiClassType)) {
                return;
            }
            PsiClassType classType = (PsiClassType)type;
            if (!classType.hasParameters()) {
                PsiType expectedType = ExpectedTypeUtils.findExpectedType(expression, false);
                if (!(expectedType instanceof PsiClassType)) {
                    return;
                }
                classType = (PsiClassType)expectedType;
            }
            if ((typeArguments = classType.getParameters()).length != 2) {
                return;
            }
            PsiType argumentType = typeArguments[0];
            if (!(argumentType instanceof PsiClassType)) {
                return;
            }
            if (!TypeUtils.expressionHasTypeOrSubtype((PsiExpression)expression, "java.util.Map")) {
                return;
            }
            if (null != TypeUtils.expressionHasTypeOrSubtype((PsiExpression)expression, "java.util.EnumMap", "java.util.concurrent.ConcurrentMap")) {
                return;
            }
            PsiClassType argumentClassType = (PsiClassType)argumentType;
            PsiClass argumentClass = argumentClassType.resolve();
            if (argumentClass == null || !argumentClass.isEnum()) {
                return;
            }
            PsiClass aClass = PsiTreeUtil.getParentOfType((PsiElement)expression, PsiClass.class);
            if (argumentClass.equals(aClass) && (member = PsiTreeUtil.getParentOfType((PsiElement)expression, PsiMember.class)) != null && !member.hasModifierProperty("static")) {
                return;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            if (argumentList != null && (arguments = argumentList.getExpressions()).length > 0 && TypeUtils.expressionHasTypeOrSubtype(arguments[0], "java.util.Comparator")) {
                return;
            }
            this.registerNewExpressionError(expression, new Object[0]);
        }
    }
}

