/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.performance.StringVariableIsAppendedToVisitor;
import com.siyeh.ig.psiutils.TypeUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class StringReplaceableByStringBufferInspection
extends BaseInspection {
    public boolean onlyWarnOnLoop = true;

    @Override
    @NotNull
    public String getID() {
        if ("NonConstantStringShouldBeStringBuffer" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/StringReplaceableByStringBufferInspection", "getID"));
        }
        return "NonConstantStringShouldBeStringBuffer";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("string.replaceable.by.string.buffer.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/StringReplaceableByStringBufferInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("string.replaceable.by.string.buffer.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/StringReplaceableByStringBufferInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("string.replaceable.by.string.buffer.in.loop.option", new Object[0]), this, "onlyWarnOnLoop");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StringReplaceableByStringBufferVisitor();
    }

    private class StringReplaceableByStringBufferVisitor
    extends BaseInspectionVisitor {
        private StringReplaceableByStringBufferVisitor() {
        }

        @Override
        public void visitLocalVariable(@NotNull PsiLocalVariable variable) {
            if (variable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/performance/StringReplaceableByStringBufferInspection$StringReplaceableByStringBufferVisitor", "visitLocalVariable"));
            }
            super.visitLocalVariable(variable);
            PsiCodeBlock codeBlock = PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class);
            if (codeBlock == null) {
                return;
            }
            PsiType type = variable.getType();
            if (!TypeUtils.typeEquals("java.lang.String", type)) {
                return;
            }
            if (!this.variableIsAppendedTo(variable, codeBlock)) {
                return;
            }
            this.registerVariableError(variable, new Object[0]);
        }

        public boolean variableIsAppendedTo(PsiVariable variable, PsiElement context) {
            StringVariableIsAppendedToVisitor visitor = new StringVariableIsAppendedToVisitor(variable, StringReplaceableByStringBufferInspection.this.onlyWarnOnLoop);
            context.accept(visitor);
            return visitor.isAppendedTo();
        }
    }
}

