/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class VariableAssignedVisitor
extends JavaRecursiveElementWalkingVisitor {
    @NotNull
    private final Collection<PsiVariable> variables;
    private final boolean recurseIntoClasses;
    private final boolean checkUnaryExpressions;
    private boolean assigned;
    private PsiElement excludedElement;

    public VariableAssignedVisitor(@NotNull Collection<PsiVariable> variables, boolean recurseIntoClasses) {
        if (variables == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variables", "com/siyeh/ig/psiutils/VariableAssignedVisitor", "<init>"));
        }
        this.assigned = false;
        this.excludedElement = null;
        this.variables = variables;
        this.checkUnaryExpressions = true;
        this.recurseIntoClasses = recurseIntoClasses;
    }

    public VariableAssignedVisitor(@NotNull PsiVariable variable, boolean recurseIntoClasses) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/psiutils/VariableAssignedVisitor", "<init>"));
        }
        this.assigned = false;
        this.excludedElement = null;
        this.variables = Collections.singleton(variable);
        PsiType type = variable.getType();
        this.checkUnaryExpressions = TypeConversionUtil.isNumericType(type);
        this.recurseIntoClasses = recurseIntoClasses;
    }

    public VariableAssignedVisitor(@NotNull PsiVariable variable) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/psiutils/VariableAssignedVisitor", "<init>"));
        }
        this(variable, true);
    }

    public void setExcludedElement(PsiElement excludedElement) {
        this.excludedElement = excludedElement;
    }

    @Override
    public void visitElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/psiutils/VariableAssignedVisitor", "visitElement"));
        }
        if (this.assigned || element == this.excludedElement) {
            return;
        }
        super.visitElement(element);
    }

    @Override
    public void visitAssignmentExpression(@NotNull PsiAssignmentExpression assignment) {
        if (assignment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "assignment", "com/siyeh/ig/psiutils/VariableAssignedVisitor", "visitAssignmentExpression"));
        }
        if (this.assigned) {
            return;
        }
        super.visitAssignmentExpression(assignment);
        PsiExpression lhs = assignment.getLExpression();
        for (PsiVariable variable : this.variables) {
            if (!VariableAccessUtils.evaluatesToVariable(lhs, variable)) continue;
            this.assigned = true;
            break;
        }
    }

    @Override
    public void visitClass(PsiClass aClass) {
        if (!this.recurseIntoClasses || this.assigned) {
            return;
        }
        super.visitClass(aClass);
    }

    @Override
    public void visitPrefixExpression(@NotNull PsiPrefixExpression prefixExpression) {
        if (prefixExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefixExpression", "com/siyeh/ig/psiutils/VariableAssignedVisitor", "visitPrefixExpression"));
        }
        if (this.assigned) {
            return;
        }
        super.visitPrefixExpression(prefixExpression);
        if (!this.checkUnaryExpressions) {
            return;
        }
        IElementType tokenType = prefixExpression.getOperationTokenType();
        if (!tokenType.equals(JavaTokenType.PLUSPLUS) && !tokenType.equals(JavaTokenType.MINUSMINUS)) {
            return;
        }
        PsiExpression operand = prefixExpression.getOperand();
        for (PsiVariable variable : this.variables) {
            if (!VariableAccessUtils.evaluatesToVariable(operand, variable)) continue;
            this.assigned = true;
            break;
        }
    }

    @Override
    public void visitPostfixExpression(@NotNull PsiPostfixExpression postfixExpression) {
        if (postfixExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "postfixExpression", "com/siyeh/ig/psiutils/VariableAssignedVisitor", "visitPostfixExpression"));
        }
        if (this.assigned) {
            return;
        }
        super.visitPostfixExpression(postfixExpression);
        if (!this.checkUnaryExpressions) {
            return;
        }
        IElementType tokenType = postfixExpression.getOperationTokenType();
        if (!tokenType.equals(JavaTokenType.PLUSPLUS) && !tokenType.equals(JavaTokenType.MINUSMINUS)) {
            return;
        }
        PsiExpression operand = postfixExpression.getOperand();
        for (PsiVariable variable : this.variables) {
            if (!VariableAccessUtils.evaluatesToVariable(operand, variable)) continue;
            this.assigned = true;
            break;
        }
    }

    public boolean isAssigned() {
        return this.assigned;
    }
}

