/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiVariable;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import org.jetbrains.annotations.NotNull;

class VariableReturnedVisitor
extends JavaRecursiveElementWalkingVisitor {
    @NotNull
    private final PsiVariable variable;
    private final boolean myBuilderPattern;
    private boolean returned;

    public VariableReturnedVisitor(@NotNull PsiVariable variable, boolean builderPattern) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/psiutils/VariableReturnedVisitor", "<init>"));
        }
        this.returned = false;
        this.variable = variable;
        this.myBuilderPattern = builderPattern;
    }

    @Override
    public void visitReturnStatement(@NotNull PsiReturnStatement returnStatement) {
        if (returnStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnStatement", "com/siyeh/ig/psiutils/VariableReturnedVisitor", "visitReturnStatement"));
        }
        PsiExpression returnValue = returnStatement.getReturnValue();
        if (VariableAccessUtils.mayEvaluateToVariable(returnValue, this.variable, this.myBuilderPattern)) {
            this.returned = true;
            this.stopWalking();
            return;
        }
        super.visitReturnStatement(returnStatement);
    }

    @Override
    public void visitLambdaExpression(PsiLambdaExpression expression) {
        PsiElement body = expression.getBody();
        if (body instanceof PsiExpression && VariableAccessUtils.mayEvaluateToVariable((PsiExpression)body, this.variable, this.myBuilderPattern)) {
            this.returned = true;
            this.stopWalking();
            return;
        }
        super.visitLambdaExpression(expression);
    }

    public boolean isReturned() {
        return this.returned;
    }
}

