/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.serialization;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.DelegatingFixFactory;
import com.siyeh.ig.psiutils.SerializationUtils;
import org.jetbrains.annotations.NotNull;

public class NonSerializableWithSerialVersionUIDFieldInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getID() {
        if ("NonSerializableClassWithSerialVersionUID" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/serialization/NonSerializableWithSerialVersionUIDFieldInspection", "getID"));
        }
        return "NonSerializableClassWithSerialVersionUID";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("non.serializable.with.serialversionuid.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/serialization/NonSerializableWithSerialVersionUIDFieldInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiClass aClass = (PsiClass)infos[0];
        if (aClass.isAnnotationType()) {
            String string = InspectionGadgetsBundle.message("non.serializable.@interface.with.serialversionuid.problem.descriptor", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/serialization/NonSerializableWithSerialVersionUIDFieldInspection", "buildErrorString"));
            }
            return string;
        }
        if (aClass.isInterface()) {
            String string = InspectionGadgetsBundle.message("non.serializable.interface.with.serialversionuid.problem.descriptor", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/serialization/NonSerializableWithSerialVersionUIDFieldInspection", "buildErrorString"));
            }
            return string;
        }
        if (aClass instanceof PsiAnonymousClass) {
            String string = InspectionGadgetsBundle.message("non.serializable.anonymous.with.serialversionuid.problem.descriptor", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/serialization/NonSerializableWithSerialVersionUIDFieldInspection", "buildErrorString"));
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("non.serializable.class.with.serialversionuid.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/serialization/NonSerializableWithSerialVersionUIDFieldInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos) {
        PsiClass aClass = (PsiClass)infos[0];
        if (aClass.isAnnotationType() || aClass.isInterface() || aClass instanceof PsiAnonymousClass) {
            InspectionGadgetsFix[] inspectionGadgetsFixArray = new InspectionGadgetsFix[]{new RemoveSerialVersionUIDFix()};
            if (inspectionGadgetsFixArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/serialization/NonSerializableWithSerialVersionUIDFieldInspection", "buildFixes"));
            }
            return inspectionGadgetsFixArray;
        }
        InspectionGadgetsFix[] inspectionGadgetsFixArray = new InspectionGadgetsFix[]{DelegatingFixFactory.createMakeSerializableFix(aClass), new RemoveSerialVersionUIDFix()};
        if (inspectionGadgetsFixArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/serialization/NonSerializableWithSerialVersionUIDFieldInspection", "buildFixes"));
        }
        return inspectionGadgetsFixArray;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NonSerializableWithSerialVersionUIDVisitor();
    }

    private static class NonSerializableWithSerialVersionUIDVisitor
    extends BaseInspectionVisitor {
        private NonSerializableWithSerialVersionUIDVisitor() {
        }

        @Override
        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/serialization/NonSerializableWithSerialVersionUIDFieldInspection$NonSerializableWithSerialVersionUIDVisitor", "visitClass"));
            }
            PsiField field = aClass.findFieldByName("serialVersionUID", false);
            if (field == null) {
                return;
            }
            if (SerializationUtils.isSerializable(aClass)) {
                return;
            }
            this.registerClassError(aClass, aClass);
        }
    }

    private static class RemoveSerialVersionUIDFix
    extends InspectionGadgetsFix {
        private RemoveSerialVersionUIDFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/serialization/NonSerializableWithSerialVersionUIDFieldInspection$RemoveSerialVersionUIDFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("non.serializable.with.serialversionuid.remove.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/serialization/NonSerializableWithSerialVersionUIDFieldInspection$RemoveSerialVersionUIDFix", "getName"));
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement nameElement = descriptor.getPsiElement();
            PsiClass aClass = (PsiClass)nameElement.getParent();
            PsiField field = aClass.findFieldByName("serialVersionUID", false);
            if (field == null) {
                return;
            }
            field.delete();
        }
    }
}

