/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.NormalizeDeclarationFix;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class MultipleDeclarationInspection
extends BaseInspection {
    public boolean ignoreForLoopDeclarations = true;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("multiple.declaration.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/MultipleDeclarationInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getID() {
        if ("MultipleVariablesInDeclaration" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/MultipleDeclarationInspection", "getID"));
        }
        return "MultipleVariablesInDeclaration";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("multiple.declaration.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/MultipleDeclarationInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("multiple.declaration.option", new Object[0]), this, "ignoreForLoopDeclarations");
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new NormalizeDeclarationFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MultipleDeclarationVisitor();
    }

    private class MultipleDeclarationVisitor
    extends BaseInspectionVisitor {
        private MultipleDeclarationVisitor() {
        }

        @Override
        public void visitDeclarationStatement(PsiDeclarationStatement statement) {
            super.visitDeclarationStatement(statement);
            if (statement.getDeclaredElements().length <= 1) {
                return;
            }
            PsiElement parent = statement.getParent();
            if (MultipleDeclarationInspection.this.ignoreForLoopDeclarations && parent instanceof PsiForStatement) {
                return;
            }
            PsiElement[] declaredElements = statement.getDeclaredElements();
            for (int i = 1; i < declaredElements.length; ++i) {
                PsiElement declaredElement = declaredElements[i];
                if (!(declaredElement instanceof PsiVariable)) continue;
                PsiVariable variable = (PsiVariable)declaredElement;
                this.registerVariableError(variable, new Object[0]);
            }
        }

        @Override
        public void visitField(@NotNull PsiField field) {
            if (field == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/siyeh/ig/style/MultipleDeclarationInspection$MultipleDeclarationVisitor", "visitField"));
            }
            super.visitField(field);
            if (this.childrenContainTypeElement(field)) {
                return;
            }
            if (field instanceof PsiEnumConstant) {
                return;
            }
            this.registerFieldError(field, new Object[0]);
        }

        public boolean childrenContainTypeElement(PsiElement field) {
            PsiElement[] children;
            for (PsiElement aChildren : children = field.getChildren()) {
                if (!(aChildren instanceof PsiTypeElement)) continue;
                return true;
            }
            return false;
        }
    }
}

