/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RedundantFieldInitializationInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    public boolean onlyWarnOnNull = false;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("redundant.field.initialization.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/RedundantFieldInitializationInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("redundant.field.initialization.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/RedundantFieldInitializationInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel("Only warn on initialization to null", this, "onlyWarnOnNull");
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new RedundantFieldInitializationFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new RedundantFieldInitializationVisitor();
    }

    private class RedundantFieldInitializationVisitor
    extends BaseInspectionVisitor {
        private RedundantFieldInitializationVisitor() {
        }

        @Override
        public void visitField(@NotNull PsiField field) {
            if (field == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/siyeh/ig/style/RedundantFieldInitializationInspection$RedundantFieldInitializationVisitor", "visitField"));
            }
            super.visitField(field);
            if (!field.hasInitializer() || field.hasModifierProperty("final")) {
                return;
            }
            PsiExpression initializer = field.getInitializer();
            if (initializer == null) {
                return;
            }
            String text = initializer.getText();
            PsiType type = field.getType();
            if (PsiType.BOOLEAN.equals(type) ? RedundantFieldInitializationInspection.this.onlyWarnOnNull || !"false".equals(text) : (type instanceof PsiPrimitiveType ? RedundantFieldInitializationInspection.this.onlyWarnOnNull || !ExpressionUtils.isZero(initializer) : !PsiType.NULL.equals(initializer.getType()))) {
                return;
            }
            if (initializer instanceof PsiReferenceExpression || !PsiTreeUtil.findChildrenOfType(initializer, PsiReferenceExpression.class).isEmpty()) {
                return;
            }
            if (this.isAssignmentInInitializerOverwritten(field)) {
                return;
            }
            this.registerError((PsiElement)initializer, ProblemHighlightType.LIKE_UNUSED_SYMBOL, new Object[0]);
        }

        private boolean isAssignmentInInitializerOverwritten(@NotNull PsiField field) {
            PsiClassInitializer[] initializers;
            if (field == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/siyeh/ig/style/RedundantFieldInitializationInspection$RedundantFieldInitializationVisitor", "isAssignmentInInitializerOverwritten"));
            }
            PsiClass aClass = field.getContainingClass();
            if (aClass == null) {
                return false;
            }
            boolean isStatic = field.hasModifierProperty("static");
            for (PsiClassInitializer classInitializer : initializers = aClass.getInitializers()) {
                if (classInitializer.hasModifierProperty("static") != isStatic || classInitializer.getTextOffset() >= field.getTextOffset() || !VariableAccessUtils.variableIsAssigned(field, classInitializer)) continue;
                return true;
            }
            return false;
        }
    }

    private static class RedundantFieldInitializationFix
    extends InspectionGadgetsFix {
        private RedundantFieldInitializationFix() {
        }

        @Override
        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("redundant.field.initialization.remove.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/RedundantFieldInitializationInspection$RedundantFieldInitializationFix", "getName"));
            }
            return string;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/RedundantFieldInitializationInspection$RedundantFieldInitializationFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            descriptor.getPsiElement().delete();
        }
    }
}

