/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.VariableSearchUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class SynchronizationOnLocalVariableOrMethodParameterInspection
extends BaseInspection {
    public boolean reportLocalVariables = true;
    public boolean reportMethodParameters = true;

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("synchronization.on.local.variable.or.method.parameter.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/SynchronizationOnLocalVariableOrMethodParameterInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        Boolean localVariable = (Boolean)infos[0];
        if (localVariable.booleanValue()) {
            String string = InspectionGadgetsBundle.message("synchronization.on.local.variable.problem.descriptor", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/SynchronizationOnLocalVariableOrMethodParameterInspection", "buildErrorString"));
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("synchronization.on.method.parameter.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/SynchronizationOnLocalVariableOrMethodParameterInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SynchronizationOnLocalVariableVisitor();
    }

    private static boolean isEscaping(PsiVariable variable) {
        PsiElement scope;
        if (variable instanceof PsiParameter) {
            PsiParameter parameter = (PsiParameter)variable;
            scope = parameter.getDeclarationScope();
        } else if (variable instanceof PsiLocalVariable) {
            scope = PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class);
        } else {
            throw new AssertionError();
        }
        if (scope == null) {
            return true;
        }
        EscapeVisitor visitor = new EscapeVisitor(variable, scope);
        scope.accept(visitor);
        return visitor.isEscaping();
    }

    private static class EscapeVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private final PsiVariable myVariable;
        private final PsiElement myContext;
        private boolean escaping;

        public EscapeVisitor(@NotNull PsiVariable variable, @NotNull PsiElement context) {
            if (variable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/threading/SynchronizationOnLocalVariableOrMethodParameterInspection$EscapeVisitor", "<init>"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/siyeh/ig/threading/SynchronizationOnLocalVariableOrMethodParameterInspection$EscapeVisitor", "<init>"));
            }
            this.escaping = false;
            this.myVariable = variable;
            this.myContext = context;
        }

        @Override
        public void visitReferenceExpression(PsiReferenceExpression expression) {
            if (this.escaping) {
                return;
            }
            super.visitReferenceExpression(expression);
            PsiElement target = expression.resolve();
            if (!this.myVariable.equals(target)) {
                return;
            }
            Object context = PsiTreeUtil.getParentOfType((PsiElement)expression, PsiMember.class, PsiLambdaExpression.class);
            if (context != null && PsiTreeUtil.isAncestor(this.myContext, context, true)) {
                this.escaping = true;
            }
        }

        public boolean isEscaping() {
            return this.escaping;
        }
    }

    private class SynchronizationOnLocalVariableVisitor
    extends BaseInspectionVisitor {
        private SynchronizationOnLocalVariableVisitor() {
        }

        @Override
        public void visitSynchronizedStatement(PsiSynchronizedStatement statement) {
            super.visitSynchronizedStatement(statement);
            if (!SynchronizationOnLocalVariableOrMethodParameterInspection.this.reportLocalVariables && !SynchronizationOnLocalVariableOrMethodParameterInspection.this.reportMethodParameters) {
                return;
            }
            PsiExpression lockExpression = ParenthesesUtils.stripParentheses(statement.getLockExpression());
            if (!(lockExpression instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)lockExpression;
            if (referenceExpression.isQualified()) {
                return;
            }
            boolean localVariable = false;
            PsiElement target = referenceExpression.resolve();
            if (target instanceof PsiLocalVariable) {
                PsiLocalVariable variable = (PsiLocalVariable)target;
                if (!SynchronizationOnLocalVariableOrMethodParameterInspection.this.reportLocalVariables || this.isSynchronizedCollection(variable, referenceExpression)) {
                    return;
                }
                localVariable = true;
            } else if (target instanceof PsiParameter) {
                PsiParameter parameter = (PsiParameter)target;
                PsiElement scope = parameter.getDeclarationScope();
                if (scope instanceof PsiMethod) {
                    if (!SynchronizationOnLocalVariableOrMethodParameterInspection.this.reportMethodParameters) {
                        return;
                    }
                } else {
                    if (!SynchronizationOnLocalVariableOrMethodParameterInspection.this.reportLocalVariables) {
                        return;
                    }
                    localVariable = true;
                }
            } else {
                return;
            }
            PsiElement statementScope = this.getScope(statement);
            PsiElement targetScope = this.getScope(target);
            if (statementScope != targetScope || SynchronizationOnLocalVariableOrMethodParameterInspection.isEscaping((PsiVariable)target)) {
                return;
            }
            this.registerError((PsiElement)referenceExpression, localVariable);
        }

        private PsiElement getScope(PsiElement element) {
            return PsiTreeUtil.getParentOfType(element, PsiMethod.class, PsiLambdaExpression.class, PsiClassInitializer.class);
        }

        private boolean isSynchronizedCollection(@NotNull PsiVariable variable, PsiReferenceExpression referenceExpression) {
            if (variable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/threading/SynchronizationOnLocalVariableOrMethodParameterInspection$SynchronizationOnLocalVariableVisitor", "isSynchronizedCollection"));
            }
            PsiExpression definition = VariableSearchUtils.findDefinition(referenceExpression, variable);
            if (!(definition instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)definition;
            PsiMethod method = methodCallExpression.resolveMethod();
            if (method == null) {
                return false;
            }
            String methodName = method.getName();
            if (!methodName.startsWith("synchronized")) {
                return false;
            }
            PsiClass containingClass = method.getContainingClass();
            return containingClass != null && "java.util.Collections".equals(containingClass.getQualifiedName());
        }
    }
}

