/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.ui;

import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.OrderedSet;
import org.jdom.Element;

public class ExternalizableStringSet
extends OrderedSet<String>
implements JDOMExternalizable {
    private static final String ITEM = "item";
    private static final String VALUE = "value";
    private final String[] defaultValues;

    public ExternalizableStringSet(String ... defaultValues) {
        this.defaultValues = defaultValues.length == 0 ? ArrayUtil.EMPTY_STRING_ARRAY : defaultValues;
        for (String defaultValue : defaultValues) {
            this.add(defaultValue);
        }
    }

    public boolean hasDefaultValues() {
        if (this.size() != this.defaultValues.length) {
            return false;
        }
        for (String defaultValue : this.defaultValues) {
            if (this.contains(defaultValue)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void readExternal(Element element) throws InvalidDataException {
        boolean dataFound = false;
        for (Element item : element.getChildren(ITEM)) {
            if (!dataFound) {
                this.clear();
                dataFound = true;
            }
            this.add(StringUtil.unescapeXml(item.getAttributeValue(VALUE)));
        }
    }

    @Override
    public void writeExternal(Element element) throws WriteExternalException {
        if (this.hasDefaultValues()) {
            return;
        }
        for (String value : this) {
            if (value == null) continue;
            Element item = new Element(ITEM);
            item.setAttribute(VALUE, StringUtil.escapeXml(value));
            element.addContent(item);
        }
    }
}

