/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.generate.config;

import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.java.generate.config.InsertNewMethodStrategy;
import org.jetbrains.java.generate.psi.PsiAdapter;

public class InsertLastStrategy
implements InsertNewMethodStrategy {
    private static final InsertLastStrategy instance = new InsertLastStrategy();

    private InsertLastStrategy() {
    }

    public static InsertLastStrategy getInstance() {
        return instance;
    }

    @Override
    public PsiMethod insertNewMethod(PsiClass clazz, @NotNull PsiMethod newMethod, Editor editor) {
        PsiMethod[] methods;
        if (newMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newMethod", "org/jetbrains/java/generate/config/InsertLastStrategy", "insertNewMethod"));
        }
        PsiMethod mainMethod = PsiAdapter.findPublicStaticVoidMainMethod(clazz);
        if (mainMethod != null && mainMethod.equals((methods = clazz.getMethods())[methods.length - 1])) {
            return (PsiMethod)clazz.addBefore(newMethod, mainMethod);
        }
        PsiElement last = clazz.getRBrace();
        return (PsiMethod)clazz.addBefore(newMethod, last);
    }

    public String toString() {
        return "Last";
    }
}

