/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.defUse;

import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInsight.daemon.impl.quickfix.RemoveUnusedVariableUtil;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.DefUseUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class DefUseInspectionBase
extends BaseJavaBatchLocalInspectionTool {
    public boolean REPORT_PREFIX_EXPRESSIONS;
    public boolean REPORT_POSTFIX_EXPRESSIONS = true;
    public boolean REPORT_REDUNDANT_INITIALIZER = true;
    public static final String DISPLAY_NAME = InspectionsBundle.message("inspection.unused.assignment.display.name", new Object[0]);
    @NonNls
    public static final String SHORT_NAME = "UnusedAssignment";

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/defUse/DefUseInspectionBase", "buildVisitor"));
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            @Override
            public void visitMethod(PsiMethod method) {
                DefUseInspectionBase.this.checkCodeBlock(method.getBody(), holder, isOnTheFly);
            }

            @Override
            public void visitClassInitializer(PsiClassInitializer initializer) {
                DefUseInspectionBase.this.checkCodeBlock(initializer.getBody(), holder, isOnTheFly);
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/defUse/DefUseInspectionBase", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    private void checkCodeBlock(PsiCodeBlock body, ProblemsHolder holder, boolean isOnTheFly) {
        if (body == null) {
            return;
        }
        THashSet usedVariables = new THashSet();
        List<DefUseUtil.Info> unusedDefs = DefUseUtil.getUnusedDefs(body, (Set<PsiVariable>)usedVariables);
        if (unusedDefs != null && !unusedDefs.isEmpty()) {
            Collections.sort(unusedDefs, (o1, o2) -> {
                int offset2;
                int offset1 = o1.getContext().getTextOffset();
                if (offset1 == (offset2 = o2.getContext().getTextOffset())) {
                    return 0;
                }
                if (offset1 < offset2) {
                    return -1;
                }
                return 1;
            });
            for (DefUseUtil.Info info : unusedDefs) {
                PsiElement context = info.getContext();
                PsiVariable psiVariable = info.getVariable();
                if (context instanceof PsiDeclarationStatement || context instanceof PsiResourceVariable) {
                    if (!info.isRead()) {
                        if (isOnTheFly) continue;
                        holder.registerProblem((PsiElement)ObjectUtils.notNull(psiVariable.getNameIdentifier(), psiVariable), InspectionsBundle.message("inspection.unused.assignment.problem.descriptor1", "<code>#ref</code> #loc"), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[0]);
                        continue;
                    }
                    if (!this.REPORT_REDUNDANT_INITIALIZER) continue;
                    List<LocalQuickFix> fixes = ContainerUtil.createMaybeSingletonList(DefUseInspectionBase.isOnTheFlyOrNoSideEffects(isOnTheFly, psiVariable, psiVariable.getInitializer()) ? this.createRemoveInitializerFix() : null);
                    holder.registerProblem((PsiElement)ObjectUtils.notNull(psiVariable.getInitializer(), psiVariable), InspectionsBundle.message("inspection.unused.assignment.problem.descriptor2", "<code>" + psiVariable.getName() + "</code>", "<code>#ref</code> #loc"), ProblemHighlightType.LIKE_UNUSED_SYMBOL, fixes.toArray(new LocalQuickFix[fixes.size()]));
                    continue;
                }
                if (context instanceof PsiAssignmentExpression) {
                    PsiAssignmentExpression assignment = (PsiAssignmentExpression)context;
                    List<LocalQuickFix> fixes = ContainerUtil.createMaybeSingletonList(DefUseInspectionBase.isOnTheFlyOrNoSideEffects(isOnTheFly, psiVariable, assignment.getRExpression()) ? this.createRemoveAssignmentFix() : null);
                    holder.registerProblem((PsiElement)assignment.getLExpression(), InspectionsBundle.message("inspection.unused.assignment.problem.descriptor3", ObjectUtils.assertNotNull(assignment.getRExpression()).getText(), "<code>#ref</code> #loc"), ProblemHighlightType.LIKE_UNUSED_SYMBOL, fixes.toArray(new LocalQuickFix[fixes.size()]));
                    continue;
                }
                if ((!(context instanceof PsiPrefixExpression) || !this.REPORT_PREFIX_EXPRESSIONS) && (!(context instanceof PsiPostfixExpression) || !this.REPORT_POSTFIX_EXPRESSIONS)) continue;
                holder.registerProblem(context, InspectionsBundle.message("inspection.unused.assignment.problem.descriptor4", "<code>#ref</code> #loc"), new LocalQuickFix[0]);
            }
        }
        body.accept(new JavaRecursiveElementWalkingVisitor((Set)usedVariables, isOnTheFly, holder){
            final /* synthetic */ Set val$usedVariables;
            final /* synthetic */ boolean val$isOnTheFly;
            final /* synthetic */ ProblemsHolder val$holder;
            {
                this.val$usedVariables = set;
                this.val$isOnTheFly = bl;
                this.val$holder = problemsHolder;
            }

            @Override
            public void visitClass(PsiClass aClass) {
            }

            @Override
            public void visitLocalVariable(PsiLocalVariable variable) {
                if (!this.val$usedVariables.contains(variable) && variable.getInitializer() == null && !this.val$isOnTheFly) {
                    this.val$holder.registerProblem((PsiElement)ObjectUtils.notNull(variable.getNameIdentifier(), variable), InspectionsBundle.message("inspection.unused.assignment.problem.descriptor5", "<code>#ref</code> #loc"), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[0]);
                }
            }
        });
    }

    private static boolean isOnTheFlyOrNoSideEffects(boolean isOnTheFly, PsiVariable psiVariable, PsiExpression initializer) {
        return isOnTheFly || !RemoveUnusedVariableUtil.checkSideEffects(initializer, psiVariable, new ArrayList<PsiElement>());
    }

    protected LocalQuickFix createRemoveInitializerFix() {
        return null;
    }

    protected LocalQuickFix createRemoveAssignmentFix() {
        return null;
    }

    @Override
    public JComponent createOptionsPanel() {
        return new OptionsPanel();
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = DISPLAY_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/defUse/DefUseInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.BUGS_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/defUse/DefUseInspectionBase", "getGroupDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getShortName() {
        if (SHORT_NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/defUse/DefUseInspectionBase", "getShortName"));
        }
        return SHORT_NAME;
    }

    private class OptionsPanel
    extends JPanel {
        private final JCheckBox myReportPrefix;
        private final JCheckBox myReportPostfix;
        private final JCheckBox myReportInitializer;

        private OptionsPanel() {
            super(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.weighty = 0.0;
            gc.weightx = 1.0;
            gc.fill = 2;
            gc.anchor = 18;
            this.myReportInitializer = new JCheckBox(InspectionsBundle.message("inspection.unused.assignment.option2", new Object[0]));
            this.myReportInitializer.setSelected(DefUseInspectionBase.this.REPORT_REDUNDANT_INITIALIZER);
            this.myReportInitializer.getModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    DefUseInspectionBase.this.REPORT_REDUNDANT_INITIALIZER = OptionsPanel.this.myReportInitializer.isSelected();
                }
            });
            gc.insets = new Insets(0, 0, 15, 0);
            gc.gridy = 0;
            this.add((Component)this.myReportInitializer, gc);
            this.myReportPrefix = new JCheckBox(InspectionsBundle.message("inspection.unused.assignment.option", new Object[0]));
            this.myReportPrefix.setSelected(DefUseInspectionBase.this.REPORT_PREFIX_EXPRESSIONS);
            this.myReportPrefix.getModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    DefUseInspectionBase.this.REPORT_PREFIX_EXPRESSIONS = OptionsPanel.this.myReportPrefix.isSelected();
                }
            });
            gc.insets = new Insets(0, 0, 0, 0);
            ++gc.gridy;
            this.add((Component)this.myReportPrefix, gc);
            this.myReportPostfix = new JCheckBox(InspectionsBundle.message("inspection.unused.assignment.option1", new Object[0]));
            this.myReportPostfix.setSelected(DefUseInspectionBase.this.REPORT_POSTFIX_EXPRESSIONS);
            this.myReportPostfix.getModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    DefUseInspectionBase.this.REPORT_POSTFIX_EXPRESSIONS = OptionsPanel.this.myReportPostfix.isSelected();
                }
            });
            gc.weighty = 1.0;
            ++gc.gridy;
            this.add((Component)this.myReportPostfix, gc);
        }
    }
}

