/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.application.options.PathMacrosCollector;
import com.intellij.openapi.components.StateSplitterEx;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.stores.FileStorageCoreUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.StringInterner;
import gnu.trove.THashMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DirectoryStorageUtil {
    private static final Logger LOG = Logger.getInstance(DirectoryStorageUtil.class);

    @NotNull
    public static Map<String, Element> loadFrom(@Nullable VirtualFile dir, @Nullable TrackingPathMacroSubstitutor pathMacroSubstitutor) {
        if (dir == null || !dir.exists()) {
            Map<String, Element> map = Collections.emptyMap();
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/DirectoryStorageUtil", "loadFrom"));
            }
            return map;
        }
        StringInterner interner = new StringInterner();
        THashMap fileToState = new THashMap();
        for (VirtualFile file : dir.getChildren()) {
            if (!StringUtilRt.endsWithIgnoreCase(file.getNameSequence(), ".xml")) continue;
            try {
                Element state;
                if (file.getLength() == 0L) {
                    LOG.warn("Ignore empty file " + file.getPath());
                    continue;
                }
                Element element = JDOMUtil.load(file.getInputStream());
                String componentName = FileStorageCoreUtil.getComponentNameIfValid(element);
                if (componentName == null) continue;
                if (!element.getName().equals("component")) {
                    LOG.error("Incorrect root tag name (" + element.getName() + ") in " + file.getPresentableUrl());
                    continue;
                }
                List elementChildren = element.getChildren();
                if (elementChildren.isEmpty() || JDOMUtil.isEmpty(state = (Element)((Element)elementChildren.get(0)).detach())) continue;
                JDOMUtil.internElement(state, interner);
                if (pathMacroSubstitutor != null) {
                    pathMacroSubstitutor.expandPaths(state);
                    pathMacroSubstitutor.addUnknownMacros(componentName, PathMacrosCollector.getMacroNames(state));
                }
                fileToState.put(file.getName(), state);
            }
            catch (Throwable e) {
                LOG.warn("Unable to load state", e);
            }
        }
        THashMap tHashMap = fileToState;
        if (tHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/DirectoryStorageUtil", "loadFrom"));
        }
        return tHashMap;
    }

    @Nullable
    public static Element getCompositeState(@NotNull Map<String, Element> fileToState, @NotNull StateSplitterEx splitter) {
        if (fileToState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileToState", "com/intellij/openapi/components/impl/stores/DirectoryStorageUtil", "getCompositeState"));
        }
        if (splitter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "splitter", "com/intellij/openapi/components/impl/stores/DirectoryStorageUtil", "getCompositeState"));
        }
        Element state = new Element("component");
        if (fileToState.isEmpty()) {
            return state;
        }
        for (String fileName : fileToState.keySet()) {
            Element subState = fileToState.get(fileName);
            if (subState == null) {
                return null;
            }
            splitter.mergeStateInto(state, subState);
        }
        return state;
    }
}

