/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.util.CheckTagEmptyBodyInspection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class CollapseTagIntention
implements LocalQuickFix,
IntentionAction {
    @Override
    @NotNull
    public String getName() {
        String string = XmlBundle.message("xml.inspections.replace.tag.empty.body.with.empty.end", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/util/CollapseTagIntention", "getName"));
        }
        return string;
    }

    @Override
    @Nls
    @NotNull
    public String getText() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/util/CollapseTagIntention", "getText"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/util/CollapseTagIntention", "getFamilyName"));
        }
        return string;
    }

    @Override
    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xml/util/CollapseTagIntention", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/xml/util/CollapseTagIntention", "applyFix"));
        }
        CollapseTagIntention.applyFix(project, descriptor.getPsiElement());
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xml/util/CollapseTagIntention", "isAvailable"));
        }
        XmlTag tag = CollapseTagIntention.getTag(editor, file);
        return tag != null && !tag.isEmpty() && tag.getSubTags().length == 0 && tag.getValue().getTrimmedText().isEmpty() && CheckTagEmptyBodyInspection.isCollapsibleTag(tag);
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xml/util/CollapseTagIntention", "invoke"));
        }
        CollapseTagIntention.applyFix(project, CollapseTagIntention.getTag(editor, file));
    }

    private static XmlTag getTag(Editor editor, PsiFile file) {
        FileViewProvider provider = file.getViewProvider();
        PsiElement element = provider.findElementAt(editor.getCaretModel().getOffset(), provider.getBaseLanguage());
        return PsiTreeUtil.getParentOfType(element, XmlTag.class, false);
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    private static void applyFix(final @NotNull Project project, final @NotNull PsiElement tag) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xml/util/CollapseTagIntention", "applyFix"));
        }
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/xml/util/CollapseTagIntention", "applyFix"));
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(tag.getContainingFile())) {
            return;
        }
        PsiDocumentManager.getInstance(project).commitAllDocuments();
        ASTNode child = XmlChildRole.START_TAG_END_FINDER.findChild(tag.getNode());
        if (child == null) {
            return;
        }
        final int offset = child.getTextRange().getStartOffset();
        VirtualFile file = tag.getContainingFile().getVirtualFile();
        final Document document = FileDocumentManager.getInstance().getDocument(file);
        new WriteCommandAction(project, new PsiFile[0]){

            @Override
            protected void run(@NotNull Result result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/xml/util/CollapseTagIntention$1", "run"));
                }
                assert (document != null);
                document.replaceString(offset, tag.getTextRange().getEndOffset(), "/>");
                PsiDocumentManager.getInstance(project).commitDocument(document);
                CodeStyleManager.getInstance(project).reformat(tag);
            }
        }.execute();
    }
}

