/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiTypeElement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class ReflectionForUnavailableAnnotationInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("reflection.for.unavailable.annotation.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/ReflectionForUnavailableAnnotationInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("reflection.for.unavailable.annotation.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/ReflectionForUnavailableAnnotationInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ReflectionForUnavailableAnnotationVisitor();
    }

    private static class ReflectionForUnavailableAnnotationVisitor
    extends BaseInspectionVisitor {
        private ReflectionForUnavailableAnnotationVisitor() {
        }

        @Override
        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            PsiNameValuePair[] attributes;
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/bugs/ReflectionForUnavailableAnnotationInspection$ReflectionForUnavailableAnnotationVisitor", "visitMethodCallExpression"));
            }
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"isAnnotationPresent".equals(methodName) && !"getAnnotation".equals(methodName)) {
                return;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            PsiExpression[] args = argumentList.getExpressions();
            if (args.length != 1) {
                return;
            }
            PsiExpression arg = args[0];
            if (arg == null) {
                return;
            }
            if (!(arg instanceof PsiClassObjectAccessExpression)) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (!TypeUtils.expressionHasTypeOrSubtype(qualifier, "java.lang.reflect.AnnotatedElement")) {
                return;
            }
            PsiClassObjectAccessExpression classObjectAccessExpression = (PsiClassObjectAccessExpression)arg;
            PsiTypeElement operand = classObjectAccessExpression.getOperand();
            PsiClassType annotationClassType = (PsiClassType)operand.getType();
            PsiClass annotationClass = annotationClassType.resolve();
            if (annotationClass == null) {
                return;
            }
            PsiModifierList modifierList = annotationClass.getModifierList();
            if (modifierList == null) {
                return;
            }
            PsiAnnotation retentionAnnotation = modifierList.findAnnotation("java.lang.annotation.Retention");
            if (retentionAnnotation == null) {
                this.registerError((PsiElement)arg, new Object[0]);
                return;
            }
            PsiAnnotationParameterList parameters = retentionAnnotation.getParameterList();
            for (PsiNameValuePair attribute : attributes = parameters.getAttributes()) {
                String text;
                PsiAnnotationMemberValue value;
                String name = attribute.getName();
                if (name != null && !"value".equals(name) || (value = attribute.getValue()) == null || (text = value.getText()).contains("RUNTIME")) continue;
                this.registerError((PsiElement)arg, new Object[0]);
                return;
            }
        }
    }
}

