/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.visibility;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ClassUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AmbiguousMethodCallInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("ambiguous.method.call.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/visibility/AmbiguousMethodCallInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiClass superClass = (PsiClass)infos[0];
        PsiClass outerClass = (PsiClass)infos[1];
        String string = InspectionGadgetsBundle.message("ambiguous.method.call.problem.descriptor", superClass.getName(), outerClass.getName());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/visibility/AmbiguousMethodCallInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new AmbiguousMethodCallFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AmbiguousMethodCallVisitor();
    }

    private static class AmbiguousMethodCallVisitor
    extends BaseInspectionVisitor {
        private AmbiguousMethodCallVisitor() {
        }

        @Override
        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier != null) {
                return;
            }
            PsiClass containingClass = ClassUtils.getContainingClass(expression);
            if (containingClass == null) {
                return;
            }
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass methodClass = method.getContainingClass();
            if (methodClass == null || !containingClass.isInheritor(methodClass, true)) {
                return;
            }
            containingClass = ClassUtils.getContainingClass(containingClass);
            String methodName = methodExpression.getReferenceName();
            while (containingClass != null) {
                PsiMethod[] methods = containingClass.findMethodsByName(methodName, false);
                if (methods.length > 0 && !methodClass.equals(containingClass)) {
                    this.registerMethodCallError(expression, methodClass, containingClass);
                    return;
                }
                containingClass = ClassUtils.getContainingClass(containingClass);
            }
        }
    }

    private static class AmbiguousMethodCallFix
    extends InspectionGadgetsFix {
        private AmbiguousMethodCallFix() {
        }

        @Override
        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("ambiguous.method.call.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/visibility/AmbiguousMethodCallInspection$AmbiguousMethodCallFix", "getName"));
            }
            return string;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/visibility/AmbiguousMethodCallInspection$AmbiguousMethodCallFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)parent.getParent();
            String newExpressionText = "super." + methodCallExpression.getText();
            PsiReplacementUtil.replaceExpression(methodCallExpression, newExpressionText);
        }
    }
}

