/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class VisibilityUtil {
    @NonNls
    public static final String ESCALATE_VISIBILITY = "EscalateVisible";
    private static final String[] visibilityModifiers = new String[]{"private", "packageLocal", "protected", "public"};

    private VisibilityUtil() {
    }

    public static int compare(@PsiModifier.ModifierConstant String v1, @PsiModifier.ModifierConstant String v2) {
        return ArrayUtilRt.find(visibilityModifiers, v2) - ArrayUtilRt.find(visibilityModifiers, v1);
    }

    @PsiModifier.ModifierConstant
    public static String getHighestVisibility(@PsiModifier.ModifierConstant String v1, @PsiModifier.ModifierConstant String v2) {
        return VisibilityUtil.compare(v1, v2) < 0 ? v1 : v2;
    }

    public static void escalateVisibility(PsiMember modifierListOwner, PsiElement place) throws IncorrectOperationException {
        String modifier;
        int index;
        String visibilityModifier = VisibilityUtil.getVisibilityModifier(modifierListOwner.getModifierList());
        for (index = 0; index < visibilityModifiers.length && !(modifier = visibilityModifiers[index]).equals(visibilityModifier); ++index) {
        }
        while (index < visibilityModifiers.length && !PsiUtil.isAccessible(modifierListOwner, place, null)) {
            modifier = visibilityModifiers[index];
            PsiUtil.setModifierProperty(modifierListOwner, modifier, true);
            ++index;
        }
    }

    public static void escalateVisibility(PsiModifierList modifierList, PsiElement place) throws IncorrectOperationException {
        PsiElement parent = modifierList.getParent();
        if (parent instanceof PsiMember) {
            VisibilityUtil.escalateVisibility((PsiMember)parent, place);
        }
    }

    @PsiModifier.ModifierConstant
    public static String getPossibleVisibility(PsiMember psiMethod, PsiElement place) {
        Project project = psiMethod.getProject();
        if (PsiUtil.isAccessible(project, psiMethod, place, null)) {
            return VisibilityUtil.getVisibilityModifier(psiMethod.getModifierList());
        }
        if (JavaPsiFacade.getInstance(project).arePackagesTheSame(psiMethod, place)) {
            return "packageLocal";
        }
        if (InheritanceUtil.isInheritorOrSelf(PsiTreeUtil.getParentOfType(place, PsiClass.class), psiMethod.getContainingClass(), true)) {
            return "protected";
        }
        return "public";
    }

    @PsiModifier.ModifierConstant
    public static String getVisibilityModifier(PsiModifierList list) {
        if (list == null) {
            return "packageLocal";
        }
        for (String modifier : visibilityModifiers) {
            if (!list.hasModifierProperty(modifier)) continue;
            return modifier;
        }
        return "packageLocal";
    }

    @NotNull
    @NonNls
    public static String getVisibilityString(@PsiModifier.ModifierConstant String visibilityModifier) {
        if ("packageLocal".equals(visibilityModifier)) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/VisibilityUtil", "getVisibilityString"));
            }
            return "";
        }
        String string = visibilityModifier;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/VisibilityUtil", "getVisibilityString"));
        }
        return string;
    }

    @Nls
    @NotNull
    public static String getVisibilityStringToDisplay(@NotNull PsiMember member) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/util/VisibilityUtil", "getVisibilityStringToDisplay"));
        }
        if (member.hasModifierProperty("public")) {
            String string = VisibilityUtil.toPresentableText("public");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/VisibilityUtil", "getVisibilityStringToDisplay"));
            }
            return string;
        }
        if (member.hasModifierProperty("protected")) {
            String string = VisibilityUtil.toPresentableText("protected");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/VisibilityUtil", "getVisibilityStringToDisplay"));
            }
            return string;
        }
        if (member.hasModifierProperty("private")) {
            String string = VisibilityUtil.toPresentableText("private");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/VisibilityUtil", "getVisibilityStringToDisplay"));
            }
            return string;
        }
        String string = VisibilityUtil.toPresentableText("packageLocal");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/VisibilityUtil", "getVisibilityStringToDisplay"));
        }
        return string;
    }

    @NotNull
    public static String toPresentableText(@PsiModifier.ModifierConstant @NotNull String modifier) {
        if (modifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifier", "com/intellij/util/VisibilityUtil", "toPresentableText"));
        }
        String string = PsiBundle.visibilityPresentation(modifier);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/VisibilityUtil", "toPresentableText"));
        }
        return string;
    }

    public static void fixVisibility(PsiElement[] elements, PsiMember member, @PsiModifier.ModifierConstant String newVisibility) {
        if (newVisibility == null) {
            return;
        }
        if (ESCALATE_VISIBILITY.equals(newVisibility)) {
            for (PsiElement element : elements) {
                if (element == null) continue;
                VisibilityUtil.escalateVisibility(member, element);
            }
        } else {
            VisibilityUtil.setVisibility(member.getModifierList(), newVisibility);
        }
    }

    public static void setVisibility(PsiModifierList modifierList, @PsiModifier.ModifierConstant String newVisibility) throws IncorrectOperationException {
        modifierList.setModifierProperty(newVisibility, true);
    }

    public static void fixVisibility(PsiExpression[] expressions, PsiMember member, String newVisibility) {
        if (newVisibility == null) {
            return;
        }
        if (ESCALATE_VISIBILITY.equals(newVisibility)) {
            for (PsiExpression element : expressions) {
                VisibilityUtil.escalateVisibility(member, (PsiElement)element);
            }
        } else {
            VisibilityUtil.setVisibility(member.getModifierList(), newVisibility);
        }
    }
}

