/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.application.options.colors.ScopeAttributesUtil;
import com.intellij.codeHighlighting.RainbowHighlighter;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.JavaHighlightInfoTypes;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.TextAttributesScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.packageDependencies.DependencyValidationManagerImpl;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightNamesUtil {
    private static final Logger LOG = Logger.getInstance("#" + HighlightNamesUtil.class.getName());

    @Nullable
    static HighlightInfo highlightMethodName(@NotNull PsiMethod method, @NotNull PsiElement elementToHighlight, boolean isDeclaration, @NotNull TextAttributesScheme colorsScheme) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInsight/daemon/impl/analysis/HighlightNamesUtil", "highlightMethodName"));
        }
        if (elementToHighlight == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToHighlight", "com/intellij/codeInsight/daemon/impl/analysis/HighlightNamesUtil", "highlightMethodName"));
        }
        if (colorsScheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorsScheme", "com/intellij/codeInsight/daemon/impl/analysis/HighlightNamesUtil", "highlightMethodName"));
        }
        return HighlightNamesUtil.highlightMethodName(method, elementToHighlight, elementToHighlight.getTextRange(), colorsScheme, isDeclaration);
    }

    @Nullable
    static HighlightInfo highlightMethodName(@NotNull PsiMember methodOrClass, @NotNull PsiElement elementToHighlight, @NotNull TextRange range, @NotNull TextAttributesScheme colorsScheme, boolean isDeclaration) {
        HighlightInfoType type;
        if (methodOrClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodOrClass", "com/intellij/codeInsight/daemon/impl/analysis/HighlightNamesUtil", "highlightMethodName"));
        }
        if (elementToHighlight == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToHighlight", "com/intellij/codeInsight/daemon/impl/analysis/HighlightNamesUtil", "highlightMethodName"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/codeInsight/daemon/impl/analysis/HighlightNamesUtil", "highlightMethodName"));
        }
        if (colorsScheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorsScheme", "com/intellij/codeInsight/daemon/impl/analysis/HighlightNamesUtil", "highlightMethodName"));
        }
        boolean isInherited = false;
        if (!isDeclaration && HighlightNamesUtil.isCalledOnThis(elementToHighlight)) {
            PsiClass enclosingClass;
            PsiClass containingClass = methodOrClass instanceof PsiMethod ? methodOrClass.getContainingClass() : null;
            PsiClass psiClass = enclosingClass = containingClass == null ? null : PsiTreeUtil.getParentOfType(elementToHighlight, PsiClass.class);
            while (enclosingClass != null && !(isInherited = enclosingClass.isInheritor(containingClass, true))) {
                enclosingClass = PsiTreeUtil.getParentOfType((PsiElement)enclosingClass, PsiClass.class, true);
            }
        }
        LOG.assertTrue(methodOrClass instanceof PsiMethod || !isDeclaration);
        HighlightInfoType highlightInfoType = type = methodOrClass instanceof PsiMethod ? HighlightNamesUtil.getMethodNameHighlightType((PsiMethod)methodOrClass, isDeclaration, isInherited) : JavaHighlightInfoTypes.CONSTRUCTOR_CALL;
        if (type != null) {
            TextAttributes attributes = HighlightNamesUtil.mergeWithScopeAttributes(methodOrClass, type, colorsScheme);
            HighlightInfo.Builder builder = HighlightInfo.newHighlightInfo(type).range(range);
            if (attributes != null) {
                builder.textAttributes(attributes);
            }
            return builder.createUnconditionally();
        }
        return null;
    }

    private static boolean isCalledOnThis(@NotNull PsiElement elementToHighlight) {
        PsiElement qualifier;
        if (elementToHighlight == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToHighlight", "com/intellij/codeInsight/daemon/impl/analysis/HighlightNamesUtil", "isCalledOnThis"));
        }
        PsiMethodCallExpression methodCallExpression = PsiTreeUtil.getParentOfType(elementToHighlight, PsiMethodCallExpression.class);
        return methodCallExpression != null && ((qualifier = methodCallExpression.getMethodExpression().getQualifier()) == null || qualifier instanceof PsiThisExpression);
    }

    private static TextAttributes mergeWithScopeAttributes(@Nullable PsiElement element, @NotNull HighlightInfoType type, @NotNull TextAttributesScheme colorsScheme) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/codeInsight/daemon/impl/analysis/HighlightNamesUtil", "mergeWithScopeAttributes"));
        }
        if (colorsScheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorsScheme", "com/intellij/codeInsight/daemon/impl/analysis/HighlightNamesUtil", "mergeWithScopeAttributes"));
        }
        TextAttributes regularAttributes = HighlightInfo.getAttributesByType(element, type, colorsScheme);
        if (element == null) {
            return regularAttributes;
        }
        TextAttributes scopeAttributes = HighlightNamesUtil.getScopeAttributes(element, colorsScheme);
        return TextAttributes.merge(scopeAttributes, regularAttributes);
    }

    @NotNull
    static HighlightInfo highlightClassName(@Nullable PsiClass aClass, @NotNull PsiElement elementToHighlight, @NotNull TextAttributesScheme colorsScheme) {
        PsiElement parent;
        TextRange paramListRange;
        PsiJavaCodeReferenceElement referenceElement;
        PsiReferenceParameterList parameterList;
        if (elementToHighlight == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToHighlight", "com/intellij/codeInsight/daemon/impl/analysis/HighlightNamesUtil", "highlightClassName"));
        }
        if (colorsScheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorsScheme", "com/intellij/codeInsight/daemon/impl/analysis/HighlightNamesUtil", "highlightClassName"));
        }
        HighlightInfoType type = HighlightNamesUtil.getClassNameHighlightType(aClass, elementToHighlight);
        TextAttributes attributes = HighlightNamesUtil.mergeWithScopeAttributes(aClass, type, colorsScheme);
        TextRange range = elementToHighlight.getTextRange();
        if (elementToHighlight instanceof PsiJavaCodeReferenceElement && (parameterList = (referenceElement = (PsiJavaCodeReferenceElement)elementToHighlight).getParameterList()) != null && (paramListRange = parameterList.getTextRange()).getEndOffset() > paramListRange.getStartOffset()) {
            range = new TextRange(range.getStartOffset(), paramListRange.getStartOffset());
        }
        if ((parent = elementToHighlight.getParent()) instanceof PsiAnnotation) {
            PsiAnnotation psiAnnotation = (PsiAnnotation)parent;
            range = new TextRange(psiAnnotation.getTextRange().getStartOffset(), range.getEndOffset());
        }
        HighlightInfo.Builder builder = HighlightInfo.newHighlightInfo(type).range(range);
        if (attributes != null) {
            builder.textAttributes(attributes);
        }
        HighlightInfo highlightInfo = builder.createUnconditionally();
        if (highlightInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/HighlightNamesUtil", "highlightClassName"));
        }
        return highlightInfo;
    }

    @Nullable
    static HighlightInfo highlightVariableName(@NotNull PsiVariable variable, @NotNull PsiElement elementToHighlight, @NotNull TextAttributesScheme colorsScheme, @Nullable RainbowHighlighter rainbowHighlighter) {
        String name;
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/codeInsight/daemon/impl/analysis/HighlightNamesUtil", "highlightVariableName"));
        }
        if (elementToHighlight == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToHighlight", "com/intellij/codeInsight/daemon/impl/analysis/HighlightNamesUtil", "highlightVariableName"));
        }
        if (colorsScheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorsScheme", "com/intellij/codeInsight/daemon/impl/analysis/HighlightNamesUtil", "highlightVariableName"));
        }
        HighlightInfoType varType = HighlightNamesUtil.getVariableNameHighlightType(variable);
        if (varType == null) {
            return null;
        }
        if (variable instanceof PsiField) {
            TextAttributes attributes = HighlightNamesUtil.mergeWithScopeAttributes(variable, varType, colorsScheme);
            HighlightInfo.Builder builder = HighlightInfo.newHighlightInfo(varType).range(elementToHighlight.getTextRange());
            if (attributes != null) {
                builder.textAttributes(attributes);
            }
            return builder.createUnconditionally();
        }
        HighlightInfo.Builder builder = HighlightInfo.newHighlightInfo(varType).range(elementToHighlight);
        if (rainbowHighlighter != null && (varType == JavaHighlightInfoTypes.LOCAL_VARIABLE || varType == JavaHighlightInfoTypes.PARAMETER) && (name = variable.getName()) != null) {
            TextAttributes rainbowAttributes = rainbowHighlighter.getAttributes(name);
            builder.textAttributes(rainbowAttributes);
        }
        return builder.create();
    }

    @Nullable
    static HighlightInfo highlightClassNameInQualifier(@NotNull PsiJavaCodeReferenceElement element, @NotNull TextAttributesScheme colorsScheme) {
        PsiElement resolved;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/analysis/HighlightNamesUtil", "highlightClassNameInQualifier"));
        }
        if (colorsScheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorsScheme", "com/intellij/codeInsight/daemon/impl/analysis/HighlightNamesUtil", "highlightClassNameInQualifier"));
        }
        PsiElement qualifierExpression = element.getQualifier();
        if (qualifierExpression instanceof PsiJavaCodeReferenceElement && (resolved = ((PsiJavaCodeReferenceElement)qualifierExpression).resolve()) instanceof PsiClass) {
            return HighlightNamesUtil.highlightClassName((PsiClass)resolved, qualifierExpression, colorsScheme);
        }
        return null;
    }

    private static HighlightInfoType getMethodNameHighlightType(@NotNull PsiMethod method, boolean isDeclaration, boolean isInheritedMethod) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInsight/daemon/impl/analysis/HighlightNamesUtil", "getMethodNameHighlightType"));
        }
        if (method.isConstructor()) {
            return isDeclaration ? JavaHighlightInfoTypes.CONSTRUCTOR_DECLARATION : JavaHighlightInfoTypes.CONSTRUCTOR_CALL;
        }
        if (isDeclaration) {
            return JavaHighlightInfoTypes.METHOD_DECLARATION;
        }
        if (method.hasModifierProperty("static")) {
            return JavaHighlightInfoTypes.STATIC_METHOD;
        }
        if (isInheritedMethod) {
            return JavaHighlightInfoTypes.INHERITED_METHOD;
        }
        if (method.hasModifierProperty("abstract")) {
            return JavaHighlightInfoTypes.ABSTRACT_METHOD;
        }
        return JavaHighlightInfoTypes.METHOD_CALL;
    }

    @Nullable
    private static HighlightInfoType getVariableNameHighlightType(@NotNull PsiVariable var) {
        if (var == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "var", "com/intellij/codeInsight/daemon/impl/analysis/HighlightNamesUtil", "getVariableNameHighlightType"));
        }
        if (var instanceof PsiLocalVariable || var instanceof PsiParameter && ((PsiParameter)var).getDeclarationScope() instanceof PsiForeachStatement) {
            return JavaHighlightInfoTypes.LOCAL_VARIABLE;
        }
        if (var instanceof PsiField) {
            return var.hasModifierProperty("static") ? (var.hasModifierProperty("final") ? JavaHighlightInfoTypes.STATIC_FINAL_FIELD : JavaHighlightInfoTypes.STATIC_FIELD) : (var.hasModifierProperty("final") ? JavaHighlightInfoTypes.INSTANCE_FINAL_FIELD : JavaHighlightInfoTypes.INSTANCE_FIELD);
        }
        if (var instanceof PsiParameter) {
            return JavaHighlightInfoTypes.PARAMETER;
        }
        return null;
    }

    @NotNull
    private static HighlightInfoType getClassNameHighlightType(@Nullable PsiClass aClass, @Nullable PsiElement element) {
        if (element instanceof PsiJavaCodeReferenceElement && element.getParent() instanceof PsiAnonymousClass) {
            HighlightInfoType highlightInfoType = JavaHighlightInfoTypes.ANONYMOUS_CLASS_NAME;
            if (highlightInfoType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/HighlightNamesUtil", "getClassNameHighlightType"));
            }
            return highlightInfoType;
        }
        if (aClass != null) {
            if (aClass.isAnnotationType()) {
                HighlightInfoType highlightInfoType = JavaHighlightInfoTypes.ANNOTATION_NAME;
                if (highlightInfoType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/HighlightNamesUtil", "getClassNameHighlightType"));
                }
                return highlightInfoType;
            }
            if (aClass.isInterface()) {
                HighlightInfoType highlightInfoType = JavaHighlightInfoTypes.INTERFACE_NAME;
                if (highlightInfoType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/HighlightNamesUtil", "getClassNameHighlightType"));
                }
                return highlightInfoType;
            }
            if (aClass.isEnum()) {
                HighlightInfoType highlightInfoType = JavaHighlightInfoTypes.ENUM_NAME;
                if (highlightInfoType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/HighlightNamesUtil", "getClassNameHighlightType"));
                }
                return highlightInfoType;
            }
            if (aClass instanceof PsiTypeParameter) {
                HighlightInfoType highlightInfoType = JavaHighlightInfoTypes.TYPE_PARAMETER_NAME;
                if (highlightInfoType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/HighlightNamesUtil", "getClassNameHighlightType"));
                }
                return highlightInfoType;
            }
            PsiModifierList modList = aClass.getModifierList();
            if (modList != null && modList.hasModifierProperty("abstract")) {
                HighlightInfoType highlightInfoType = JavaHighlightInfoTypes.ABSTRACT_CLASS_NAME;
                if (highlightInfoType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/HighlightNamesUtil", "getClassNameHighlightType"));
                }
                return highlightInfoType;
            }
        }
        HighlightInfoType highlightInfoType = JavaHighlightInfoTypes.CLASS_NAME;
        if (highlightInfoType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/HighlightNamesUtil", "getClassNameHighlightType"));
        }
        return highlightInfoType;
    }

    @Nullable
    static HighlightInfo highlightReassignedVariable(@NotNull PsiVariable variable, @NotNull PsiElement elementToHighlight) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/codeInsight/daemon/impl/analysis/HighlightNamesUtil", "highlightReassignedVariable"));
        }
        if (elementToHighlight == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToHighlight", "com/intellij/codeInsight/daemon/impl/analysis/HighlightNamesUtil", "highlightReassignedVariable"));
        }
        if (variable instanceof PsiLocalVariable) {
            return HighlightInfo.newHighlightInfo(JavaHighlightInfoTypes.REASSIGNED_LOCAL_VARIABLE).range(elementToHighlight).create();
        }
        if (variable instanceof PsiParameter) {
            return HighlightInfo.newHighlightInfo(JavaHighlightInfoTypes.REASSIGNED_PARAMETER).range(elementToHighlight).create();
        }
        return null;
    }

    private static TextAttributes getScopeAttributes(@NotNull PsiElement element, @NotNull TextAttributesScheme colorsScheme) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/analysis/HighlightNamesUtil", "getScopeAttributes"));
        }
        if (colorsScheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorsScheme", "com/intellij/codeInsight/daemon/impl/analysis/HighlightNamesUtil", "getScopeAttributes"));
        }
        PsiFile file = element.getContainingFile();
        if (file == null) {
            return null;
        }
        TextAttributes result = null;
        DependencyValidationManagerImpl validationManager = (DependencyValidationManagerImpl)DependencyValidationManager.getInstance(file.getProject());
        List<Pair<NamedScope, NamedScopesHolder>> scopes = validationManager.getScopeBasedHighlightingCachedScopes();
        for (Pair<NamedScope, NamedScopesHolder> scope : scopes) {
            PackageSet packageSet;
            NamedScope namedScope = scope.getFirst();
            TextAttributesKey scopeKey = ScopeAttributesUtil.getScopeTextAttributeKey(namedScope.getName());
            TextAttributes attributes = colorsScheme.getAttributes(scopeKey);
            if (attributes == null || attributes.isEmpty() || (packageSet = namedScope.getValue()) == null || !packageSet.contains(file, scope.getSecond())) continue;
            result = TextAttributes.merge(attributes, result);
        }
        return result;
    }

    @NotNull
    public static TextRange getMethodDeclarationTextRange(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInsight/daemon/impl/analysis/HighlightNamesUtil", "getMethodDeclarationTextRange"));
        }
        if (method instanceof SyntheticElement) {
            TextRange textRange = TextRange.EMPTY_RANGE;
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/HighlightNamesUtil", "getMethodDeclarationTextRange"));
            }
            return textRange;
        }
        int start = HighlightNamesUtil.stripAnnotationsFromModifierList(method.getModifierList());
        TextRange throwsRange = method.getThrowsList().getTextRange();
        LOG.assertTrue(throwsRange != null, method);
        int end = throwsRange.getEndOffset();
        TextRange textRange = new TextRange(start, end);
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/HighlightNamesUtil", "getMethodDeclarationTextRange"));
        }
        return textRange;
    }

    @NotNull
    public static TextRange getFieldDeclarationTextRange(@NotNull PsiField field) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/codeInsight/daemon/impl/analysis/HighlightNamesUtil", "getFieldDeclarationTextRange"));
        }
        int start = HighlightNamesUtil.stripAnnotationsFromModifierList(field.getModifierList());
        int end = field.getNameIdentifier().getTextRange().getEndOffset();
        TextRange textRange = new TextRange(start, end);
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/HighlightNamesUtil", "getFieldDeclarationTextRange"));
        }
        return textRange;
    }

    @NotNull
    public static TextRange getClassDeclarationTextRange(@NotNull PsiClass aClass) {
        PsiElement endElement;
        PsiJavaCodeReferenceElement psiElement;
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/codeInsight/daemon/impl/analysis/HighlightNamesUtil", "getClassDeclarationTextRange"));
        }
        if (aClass instanceof PsiEnumConstantInitializer) {
            TextRange textRange = ((PsiEnumConstantInitializer)aClass).getEnumConstant().getNameIdentifier().getTextRange();
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/HighlightNamesUtil", "getClassDeclarationTextRange"));
            }
            return textRange;
        }
        PsiElement psiElement2 = aClass instanceof PsiAnonymousClass ? ((PsiAnonymousClass)aClass).getBaseClassReference() : (psiElement = aClass.getModifierList() == null ? aClass.getNameIdentifier() : aClass.getModifierList());
        if (psiElement == null) {
            TextRange textRange = new TextRange(aClass.getTextRange().getStartOffset(), aClass.getTextRange().getStartOffset());
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/HighlightNamesUtil", "getClassDeclarationTextRange"));
            }
            return textRange;
        }
        int start = HighlightNamesUtil.stripAnnotationsFromModifierList(psiElement);
        PsiElement psiElement3 = endElement = aClass instanceof PsiAnonymousClass ? ((PsiAnonymousClass)aClass).getBaseClassReference() : aClass.getImplementsList();
        if (endElement == null) {
            endElement = aClass.getNameIdentifier();
        }
        TextRange endTextRange = endElement == null ? null : endElement.getTextRange();
        int end = endTextRange == null ? start : endTextRange.getEndOffset();
        TextRange textRange = new TextRange(start, end);
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/HighlightNamesUtil", "getClassDeclarationTextRange"));
        }
        return textRange;
    }

    private static int stripAnnotationsFromModifierList(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/analysis/HighlightNamesUtil", "stripAnnotationsFromModifierList"));
        }
        TextRange textRange = element.getTextRange();
        if (textRange == null) {
            return 0;
        }
        PsiElement lastAnnotation = null;
        for (PsiElement child : element.getChildren()) {
            if (!(child instanceof PsiAnnotation)) continue;
            lastAnnotation = (PsiAnnotation)child;
        }
        if (lastAnnotation == null) {
            return textRange.getStartOffset();
        }
        ASTNode node = lastAnnotation.getNode();
        if (node != null) {
            while ((node = TreeUtil.nextLeaf(node)) != null && ElementType.JAVA_COMMENT_OR_WHITESPACE_BIT_SET.contains(node.getElementType())) {
            }
        }
        if (node != null) {
            return node.getTextRange().getStartOffset();
        }
        return textRange.getStartOffset();
    }
}

