/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.diagnostic.ThreadDumper;
import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationAdapter;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.StandardProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.PomManager;
import com.intellij.pom.PomModel;
import com.intellij.pom.event.PomModelEvent;
import com.intellij.pom.impl.PomTransactionBase;
import com.intellij.pom.tree.TreeAspect;
import com.intellij.pom.tree.TreeAspectEvent;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLock;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.DocumentCommitProcessor;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.PsiToDocumentSynchronizer;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.text.DiffLog;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.ForeignLeafPsiElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.text.BlockSupport;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.BoundedTaskExecutor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSetQueue;
import com.intellij.util.ui.UIUtil;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;

public class DocumentCommitThread
implements Runnable,
Disposable,
DocumentCommitProcessor {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.DocumentCommitThread");
    private final ExecutorService executor = new BoundedTaskExecutor(PooledThreadExecutor.INSTANCE, 1, this);
    private final Object lock = new Object();
    private final HashSetQueue<CommitTask> documentsToCommit = new HashSetQueue();
    private final HashSetQueue<CommitTask> documentsToApplyInEDT = new HashSetQueue();
    private final ApplicationEx myApplication;
    private volatile boolean isDisposed;
    private CommitTask currentTask;
    private boolean myEnabled;
    private int runningWriteActions;
    final StringBuilder log = new StringBuilder();
    private static final Key<Lock> DOCUMENT_LOCK = Key.create("DOCUMENT_LOCK");

    public static DocumentCommitThread getInstance() {
        return (DocumentCommitThread)ServiceManager.getService(DocumentCommitProcessor.class);
    }

    public DocumentCommitThread(final ApplicationEx application) {
        this.myApplication = application;
        application.invokeLater(new Runnable(){

            @Override
            public void run() {
                assert (DocumentCommitThread.this.runningWriteActions == 0);
                if (application.isDisposed()) {
                    return;
                }
                assert (!application.isWriteAccessAllowed() || application.isUnitTestMode());
                application.addApplicationListener(new ApplicationAdapter(){

                    @Override
                    public void beforeWriteActionStart(@NotNull Object action) {
                        if (action == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/psi/impl/DocumentCommitThread$1$1", "beforeWriteActionStart"));
                        }
                        int writeActionsBefore = DocumentCommitThread.this.runningWriteActions++;
                        if (writeActionsBefore == 0) {
                            DocumentCommitThread.this.disable("Write action started: " + action);
                        }
                    }

                    @Override
                    public void writeActionFinished(@NotNull Object action) {
                        if (action == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/psi/impl/DocumentCommitThread$1$1", "writeActionFinished"));
                        }
                        int writeActionsAfter = DocumentCommitThread.this.runningWriteActions = Math.max(0, DocumentCommitThread.this.runningWriteActions - 1);
                        if (writeActionsAfter == 0) {
                            DocumentCommitThread.this.enable("Write action finished: " + action);
                        } else if (writeActionsAfter < 0) {
                            System.err.println("mismatched listeners: " + writeActionsAfter + ";\n==== log===" + DocumentCommitThread.this.log + "\n====end log===" + ";\n=======threaddump====\n" + ThreadDumper.dumpThreadsToString() + "\n=====END threaddump=======");
                            assert (false);
                        }
                    }
                }, DocumentCommitThread.this);
                DocumentCommitThread.this.enable("Listener installed, started");
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        this.isDisposed = true;
        Object object = this.lock;
        synchronized (object) {
            this.documentsToCommit.clear();
        }
        this.cancel("Stop thread");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disable(@NonNls @NotNull Object reason) {
        if (reason == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "com/intellij/psi/impl/DocumentCommitThread", "disable"));
        }
        Object object = this.lock;
        synchronized (object) {
            this.cancel(reason);
            this.myEnabled = false;
        }
        this.log(null, "disabled", null, reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enable(@NonNls @NotNull Object reason) {
        if (reason == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "com/intellij/psi/impl/DocumentCommitThread", "enable"));
        }
        Object object = this.lock;
        synchronized (object) {
            this.myEnabled = true;
            this.wakeUpQueue();
        }
        this.log(null, "enabled", null, reason);
    }

    private void wakeUpQueue() {
        if (!this.isDisposed) {
            this.executor.execute(this);
        }
    }

    private void cancel(@NonNls @NotNull Object reason) {
        if (reason == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "com/intellij/psi/impl/DocumentCommitThread", "cancel"));
        }
        this.startNewTask(null, reason);
    }

    @Override
    public void commitAsynchronously(@NotNull Project project, @NotNull Document document, @NonNls @NotNull Object reason, @NotNull ModalityState currentModalityState) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/DocumentCommitThread", "commitAsynchronously"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/DocumentCommitThread", "commitAsynchronously"));
        }
        if (reason == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "com/intellij/psi/impl/DocumentCommitThread", "commitAsynchronously"));
        }
        if (currentModalityState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentModalityState", "com/intellij/psi/impl/DocumentCommitThread", "commitAsynchronously"));
        }
        assert (!this.isDisposed) : "already disposed";
        if (!project.isInitialized()) {
            return;
        }
        PsiFile psiFile = PsiDocumentManager.getInstance(project).getCachedPsiFile(document);
        if (psiFile == null) {
            return;
        }
        this.doQueue(project, document, DocumentCommitThread.getAllFileNodes(psiFile), reason, currentModalityState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private CommitTask doQueue(@NotNull Project project, @NotNull Document document, @NotNull List<Pair<PsiFileImpl, FileASTNode>> oldFileNodes, @NotNull Object reason, @NotNull ModalityState currentModalityState) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/DocumentCommitThread", "doQueue"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/DocumentCommitThread", "doQueue"));
        }
        if (oldFileNodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldFileNodes", "com/intellij/psi/impl/DocumentCommitThread", "doQueue"));
        }
        if (reason == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "com/intellij/psi/impl/DocumentCommitThread", "doQueue"));
        }
        if (currentModalityState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentModalityState", "com/intellij/psi/impl/DocumentCommitThread", "doQueue"));
        }
        Object object = this.lock;
        // MONITORENTER : object
        CommitTask newTask = this.createNewTaskAndCancelSimilar(project, document, oldFileNodes, reason, currentModalityState);
        this.documentsToCommit.offer(newTask);
        this.log(project, "Queued", newTask, reason);
        this.wakeUpQueue();
        CommitTask commitTask = newTask;
        // MONITOREXIT : object
        if (commitTask != null) return commitTask;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/DocumentCommitThread", "doQueue"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private CommitTask createNewTaskAndCancelSimilar(@NotNull Project project, @NotNull Document document, @NotNull List<Pair<PsiFileImpl, FileASTNode>> oldFileNodes, @NotNull Object reason, @NotNull ModalityState currentModalityState) {
        Pair<PsiFileImpl, FileASTNode> pair;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/DocumentCommitThread", "createNewTaskAndCancelSimilar"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/DocumentCommitThread", "createNewTaskAndCancelSimilar"));
        }
        if (oldFileNodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldFileNodes", "com/intellij/psi/impl/DocumentCommitThread", "createNewTaskAndCancelSimilar"));
        }
        if (reason == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "com/intellij/psi/impl/DocumentCommitThread", "createNewTaskAndCancelSimilar"));
        }
        if (currentModalityState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentModalityState", "com/intellij/psi/impl/DocumentCommitThread", "createNewTaskAndCancelSimilar"));
        }
        Object object = this.lock;
        // MONITORENTER : object
        Iterator<Pair<PsiFileImpl, FileASTNode>> iterator = oldFileNodes.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                CommitTask newTask = new CommitTask(project, document, oldFileNodes, this.createProgressIndicator(), reason, currentModalityState);
                this.cancelAndRemoveFromDocsToCommit(newTask, reason);
                this.cancelAndRemoveCurrentTask(newTask, reason);
                this.cancelAndRemoveFromDocsToApplyInEDT(newTask, reason);
                CommitTask commitTask = newTask;
                // MONITOREXIT : object
                if (commitTask != null) return commitTask;
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/DocumentCommitThread", "createNewTaskAndCancelSimilar"));
            }
            pair = iterator.next();
            assert (((PsiFileImpl)pair.first).getProject() == project);
        }
    }

    public void log(Project project, @NonNls String msg, @Nullable CommitTask task, Object ... args) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelAll() {
        Object object = this.lock;
        synchronized (object) {
            String reason = "Cancel all in tests";
            this.cancel(reason);
            for (CommitTask commitTask : this.documentsToCommit) {
                commitTask.cancel(reason, this);
                this.log(commitTask.project, "Removed from background queue", commitTask, new Object[0]);
            }
            this.documentsToCommit.clear();
            for (CommitTask commitTask : this.documentsToApplyInEDT) {
                commitTask.cancel(reason, this);
                this.log(commitTask.project, "Removed from EDT apply queue (sync commit called)", commitTask, new Object[0]);
            }
            this.documentsToApplyInEDT.clear();
            CommitTask task = this.currentTask;
            if (task != null) {
                this.cancelAndRemoveFromDocsToCommit(task, reason);
            }
            this.cancel("Sync commit intervened");
            ((BoundedTaskExecutor)this.executor).clearAndCancelAll();
        }
    }

    public void clearQueue() {
        this.cancelAll();
        this.clearLog();
        this.wakeUpQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearLog() {
        StringBuilder stringBuilder = this.log;
        synchronized (stringBuilder) {
            this.log.setLength(0);
        }
    }

    private void cancelAndRemoveCurrentTask(@NotNull CommitTask newTask, @NotNull Object reason) {
        if (newTask == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newTask", "com/intellij/psi/impl/DocumentCommitThread", "cancelAndRemoveCurrentTask"));
        }
        if (reason == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "com/intellij/psi/impl/DocumentCommitThread", "cancelAndRemoveCurrentTask"));
        }
        CommitTask currentTask = this.currentTask;
        if (currentTask != null && currentTask.equals(newTask)) {
            this.cancelAndRemoveFromDocsToCommit(currentTask, reason);
            this.cancel(reason);
        }
    }

    private void cancelAndRemoveFromDocsToApplyInEDT(@NotNull CommitTask newTask, @NotNull Object reason) {
        if (newTask == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newTask", "com/intellij/psi/impl/DocumentCommitThread", "cancelAndRemoveFromDocsToApplyInEDT"));
        }
        if (reason == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "com/intellij/psi/impl/DocumentCommitThread", "cancelAndRemoveFromDocsToApplyInEDT"));
        }
        boolean removed = DocumentCommitThread.cancelAndRemoveFromQueue(newTask, this.documentsToApplyInEDT, reason);
        if (removed) {
            this.log(newTask.project, "Removed from EDT apply queue", newTask, new Object[0]);
        }
    }

    private void cancelAndRemoveFromDocsToCommit(@NotNull CommitTask newTask, @NotNull Object reason) {
        if (newTask == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newTask", "com/intellij/psi/impl/DocumentCommitThread", "cancelAndRemoveFromDocsToCommit"));
        }
        if (reason == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "com/intellij/psi/impl/DocumentCommitThread", "cancelAndRemoveFromDocsToCommit"));
        }
        boolean removed = DocumentCommitThread.cancelAndRemoveFromQueue(newTask, this.documentsToCommit, reason);
        if (removed) {
            this.log(newTask.project, "Removed from background queue", newTask, new Object[0]);
        }
    }

    private static boolean cancelAndRemoveFromQueue(@NotNull CommitTask newTask, @NotNull HashSetQueue<CommitTask> queue, @NotNull Object reason) {
        if (newTask == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newTask", "com/intellij/psi/impl/DocumentCommitThread", "cancelAndRemoveFromQueue"));
        }
        if (queue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queue", "com/intellij/psi/impl/DocumentCommitThread", "cancelAndRemoveFromQueue"));
        }
        if (reason == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "com/intellij/psi/impl/DocumentCommitThread", "cancelAndRemoveFromQueue"));
        }
        CommitTask queuedTask = queue.find(newTask);
        if (queuedTask != null) {
            assert (queuedTask != newTask);
            queuedTask.cancel(reason, DocumentCommitThread.getInstance());
        }
        return queue.remove(newTask);
    }

    @Override
    public void run() {
        while (!this.isDisposed) {
            try {
                boolean polled = this.pollQueue();
                if (polled) continue;
                break;
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean pollQueue() {
        Object object;
        assert (!this.myApplication.isDispatchThread()) : Thread.currentThread();
        boolean success = false;
        Document document = null;
        Project project = null;
        CommitTask task = null;
        Object failureReason = null;
        try {
            ProgressIndicator indicator;
            object = this.lock;
            synchronized (object) {
                if (!this.myEnabled || (task = this.documentsToCommit.poll()) == null) {
                    return false;
                }
                document = task.document;
                indicator = task.indicator;
                project = task.project;
                if (project.isDisposed() || !((PsiDocumentManagerBase)PsiDocumentManager.getInstance(project)).isInUncommittedSet(document)) {
                    this.log(project, "Abandon and proceed to next", task, new Object[0]);
                    return true;
                }
                if (indicator.isCanceled()) {
                    return true;
                }
                this.startNewTask(task, "Pulled new task");
                this.documentsToApplyInEDT.add(task);
            }
            Runnable finishRunnable = null;
            if (indicator.isCanceled()) {
                success = false;
            } else {
                final CommitTask commitTask = task;
                final Ref result = new Ref();
                ProgressManager.getInstance().executeProcessUnderProgress(new Runnable(){

                    @Override
                    public void run() {
                        result.set(DocumentCommitThread.this.commitUnderProgress(commitTask, false));
                    }
                }, commitTask.indicator);
                finishRunnable = (Runnable)((Pair)result.get()).first;
                success = finishRunnable != null;
                failureReason = ((Pair)result.get()).second;
            }
            if (success) {
                assert (!this.myApplication.isDispatchThread());
                final Runnable finalFinishRunnable = finishRunnable;
                final Project finalProject = project;
                final TransactionGuardImpl guard = (TransactionGuardImpl)TransactionGuard.getInstance();
                final TransactionGuardImpl.TransactionIdImpl transaction = guard.getModalityTransaction(task.myCreationModalityState);
                this.myApplication.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        guard.submitTransaction(finalProject, transaction, finalFinishRunnable);
                    }
                }, task.myCreationModalityState);
            }
        }
        catch (ProcessCanceledException e) {
            this.cancel(e + " (cancel reason: " + ((UserDataHolder)((Object)task.indicator)).getUserData(CommitTask.CANCEL_REASON) + ")");
            success = false;
            failureReason = e;
        }
        catch (Throwable e) {
            LOG.error(this.log.toString(), e);
            this.cancel(e);
            failureReason = ExceptionUtil.getThrowableText(e);
        }
        final PsiDocumentManager documentManager = PsiDocumentManager.getInstance(project);
        if (!success && task != null && documentManager.isUncommited(task.document)) {
            final Document finalDocument = document;
            final Project finalProject = project;
            List<Pair<PsiFileImpl, FileASTNode>> oldFileNodes = ApplicationManager.getApplication().runReadAction(new Computable<List<Pair<PsiFileImpl, FileASTNode>>>(){

                @Override
                public List<Pair<PsiFileImpl, FileASTNode>> compute() {
                    PsiFile file = finalProject.isDisposed() ? null : documentManager.getPsiFile(finalDocument);
                    return file == null ? null : DocumentCommitThread.getAllFileNodes(file);
                }
            });
            if (oldFileNodes != null) {
                this.doQueue(project, document, oldFileNodes, "re-added on failure: " + failureReason, task.myCreationModalityState);
            }
        }
        object = this.lock;
        synchronized (object) {
            this.currentTask = null;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commitSynchronously(@NotNull Document document, @NotNull Project project, @NotNull PsiFile psiFile) {
        CommitTask task;
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/DocumentCommitThread", "commitSynchronously"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/DocumentCommitThread", "commitSynchronously"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/psi/impl/DocumentCommitThread", "commitSynchronously"));
        }
        assert (!this.isDisposed);
        if (!project.isInitialized() && !project.isDefault()) {
            String s = project + "; Disposed: " + project.isDisposed() + "; Open: " + project.isOpen();
            try {
                Disposer.dispose(project);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw new RuntimeException(s);
        }
        List<Pair<PsiFileImpl, FileASTNode>> allFileNodes = DocumentCommitThread.getAllFileNodes(psiFile);
        Lock documentLock = DocumentCommitThread.getDocumentLock(document);
        Object object = this.lock;
        synchronized (object) {
            task = this.createNewTaskAndCancelSimilar(project, document, allFileNodes, "Sync commit", ModalityState.current());
            documentLock.lock();
        }
        try {
            assert (!task.indicator.isCanceled());
            Pair<Runnable, Object> result = this.commitUnderProgress(task, true);
            Runnable finish = (Runnable)result.first;
            this.log(project, "Committed sync", task, finish, task.indicator);
            assert (finish != null);
            finish.run();
        }
        finally {
            documentLock.unlock();
        }
    }

    @NotNull
    private static List<Pair<PsiFileImpl, FileASTNode>> getAllFileNodes(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/DocumentCommitThread", "getAllFileNodes"));
        }
        List<Pair<PsiFileImpl, FileASTNode>> list = ContainerUtil.map(file.getViewProvider().getAllFiles(), new Function<PsiFile, Pair<PsiFileImpl, FileASTNode>>(){

            @Override
            public Pair<PsiFileImpl, FileASTNode> fun(PsiFile root) {
                return Pair.create((PsiFileImpl)root, root.getNode());
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/DocumentCommitThread", "getAllFileNodes"));
        }
        return list;
    }

    @NotNull
    protected ProgressIndicator createProgressIndicator() {
        StandardProgressIndicatorBase standardProgressIndicatorBase = new StandardProgressIndicatorBase();
        if (standardProgressIndicatorBase == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/DocumentCommitThread", "createProgressIndicator"));
        }
        return standardProgressIndicatorBase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startNewTask(@Nullable CommitTask task, @NotNull Object reason) {
        if (reason == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "com/intellij/psi/impl/DocumentCommitThread", "startNewTask"));
        }
        Object object = this.lock;
        synchronized (object) {
            CommitTask cur = this.currentTask;
            if (cur != null) {
                cur.cancel(reason, this);
            }
            this.currentTask = task;
        }
    }

    @NotNull
    private Pair<Runnable, Object> commitUnderProgress(final @NotNull CommitTask task, final boolean synchronously) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/psi/impl/DocumentCommitThread", "commitUnderProgress"));
        }
        if (synchronously) assert (!task.indicator.isCanceled());
        final Project project = task.project;
        final Document document = task.document;
        final PsiDocumentManagerBase documentManager = (PsiDocumentManagerBase)PsiDocumentManager.getInstance(project);
        final SmartList finishProcessors = new SmartList();
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                DocumentCommitThread.this.myApplication.assertReadAccessAllowed();
                if (project.isDisposed()) {
                    return;
                }
                Lock lock = DocumentCommitThread.getDocumentLock(document);
                if (!lock.tryLock()) {
                    task.cancel("Can't obtain document lock", DocumentCommitThread.this);
                    return;
                }
                try {
                    if (documentManager.isCommitted(document)) {
                        return;
                    }
                    if (!task.isStillValid()) {
                        task.cancel("Task invalidated", DocumentCommitThread.this);
                        return;
                    }
                    FileViewProvider viewProvider = documentManager.getCachedViewProvider(document);
                    if (viewProvider == null) {
                        finishProcessors.add(DocumentCommitThread.this.handleCommitWithoutPsi(documentManager, task));
                        return;
                    }
                    for (Pair<PsiFileImpl, FileASTNode> pair : task.myOldFileNodes) {
                        FileASTNode oldFileNode;
                        Processor<Document> finishProcessor;
                        PsiFileImpl file = (PsiFileImpl)pair.first;
                        if (!file.isValid() || (finishProcessor = DocumentCommitThread.this.doCommit(task, file, oldFileNode = (FileASTNode)pair.second)) == null) continue;
                        finishProcessors.add(finishProcessor);
                    }
                }
                finally {
                    lock.unlock();
                }
            }
        };
        if (synchronously) {
            runnable.run();
        } else if (!this.myApplication.tryRunReadAction(runnable)) {
            this.log(project, "Could not start read action", task, this.myApplication.isReadAccessAllowed(), Thread.currentThread());
            Pair<Object, String> pair = new Pair<Object, String>(null, "Could not start read action");
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/DocumentCommitThread", "commitUnderProgress"));
            }
            return pair;
        }
        boolean canceled = task.indicator.isCanceled();
        assert (!synchronously || !canceled);
        if (canceled) {
            Pair<Object, String> pair = new Pair<Object, String>(null, "Indicator was canceled");
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/DocumentCommitThread", "commitUnderProgress"));
            }
            return pair;
        }
        Runnable result = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                DocumentCommitThread.this.myApplication.assertIsDispatchThread();
                boolean committed = project.isDisposed() || documentManager.isCommitted(document);
                Object object = DocumentCommitThread.this.lock;
                synchronized (object) {
                    DocumentCommitThread.this.documentsToApplyInEDT.remove(task);
                    if (committed) {
                        DocumentCommitThread.this.log(project, "Marked as already committed in EDT apply queue, return", task, new Object[0]);
                        return;
                    }
                }
                try {
                    boolean success;
                    boolean changeStillValid = task.isStillValid();
                    boolean bl = success = changeStillValid && documentManager.finishCommit(document, finishProcessors, synchronously, task.reason);
                    if (synchronously) assert (success);
                    if (!changeStillValid) {
                        DocumentCommitThread.this.log(project, "document changed; ignore", task, new Object[0]);
                        return;
                    }
                    if (synchronously || success) assert (!documentManager.isInUncommittedSet(document));
                    if (success) {
                        DocumentCommitThread.this.log(project, "Commit finished", task, new Object[0]);
                    } else {
                        DocumentCommitThread.this.commitAsynchronously(project, document, "Re-added back", task.myCreationModalityState);
                    }
                }
                catch (Error e) {
                    System.err.println("Log:" + DocumentCommitThread.this.log);
                    throw e;
                }
            }
        };
        Pair<7, Object> pair = Pair.create(result, null);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/DocumentCommitThread", "commitUnderProgress"));
        }
        return pair;
    }

    @NotNull
    private Processor<Document> handleCommitWithoutPsi(final @NotNull PsiDocumentManagerBase documentManager, final @NotNull CommitTask task) {
        if (documentManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "documentManager", "com/intellij/psi/impl/DocumentCommitThread", "handleCommitWithoutPsi"));
        }
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/psi/impl/DocumentCommitThread", "handleCommitWithoutPsi"));
        }
        Processor<Document> processor = new Processor<Document>(){

            @Override
            public boolean process(Document document) {
                DocumentCommitThread.this.log(task.project, "Finishing without PSI", task, new Object[0]);
                if (!task.isStillValid() || documentManager.getCachedViewProvider(document) != null) {
                    return false;
                }
                documentManager.handleCommitWithoutPsi(document);
                return true;
            }
        };
        if (processor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/DocumentCommitThread", "handleCommitWithoutPsi"));
        }
        return processor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isEnabled() {
        Object object = this.lock;
        synchronized (object) {
            return this.myEnabled;
        }
    }

    public String toString() {
        return "Document commit thread; application: " + this.myApplication + "; isDisposed: " + this.isDisposed + "; myEnabled: " + this.isEnabled() + "; runningWriteActions: " + this.runningWriteActions;
    }

    public void waitForAllCommits() throws ExecutionException, InterruptedException, TimeoutException {
        ApplicationManager.getApplication().assertIsDispatchThread();
        assert (!ApplicationManager.getApplication().isWriteAccessAllowed());
        ((BoundedTaskExecutor)this.executor).waitAllTasksExecuted(100, TimeUnit.SECONDS);
        UIUtil.dispatchAllInvocationEvents();
    }

    @Nullable(value="returns runnable to execute under write action in AWT to finish the commit")
    public Processor<Document> doCommit(final @NotNull CommitTask task, final @NotNull PsiFile file, final @NotNull FileASTNode oldFileNode) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/psi/impl/DocumentCommitThread", "doCommit"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/DocumentCommitThread", "doCommit"));
        }
        if (oldFileNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldFileNode", "com/intellij/psi/impl/DocumentCommitThread", "doCommit"));
        }
        Document document = task.document;
        CharSequence newDocumentText = document.getImmutableCharSequence();
        TextRange changedPsiRange = DocumentCommitThread.getChangedPsiRange(file, task.myLastCommittedText, newDocumentText);
        if (changedPsiRange == null) {
            return null;
        }
        Boolean data = document.getUserData(BlockSupport.DO_NOT_REPARSE_INCREMENTALLY);
        if (data != null) {
            document.putUserData(BlockSupport.DO_NOT_REPARSE_INCREMENTALLY, null);
            file.putUserData(BlockSupport.DO_NOT_REPARSE_INCREMENTALLY, data);
        }
        BlockSupport blockSupport = BlockSupport.getInstance(file.getProject());
        final DiffLog diffLog = blockSupport.reparseRange(file, oldFileNode, changedPsiRange, newDocumentText, task.indicator, task.myLastCommittedText);
        return new Processor<Document>(){

            @Override
            public boolean process(Document document) {
                FileViewProvider viewProvider = file.getViewProvider();
                if (!task.isStillValid() || ((PsiDocumentManagerBase)PsiDocumentManager.getInstance(file.getProject())).getCachedViewProvider(document) != viewProvider) {
                    return false;
                }
                if (file.isPhysical() && !ApplicationManager.getApplication().isWriteAccessAllowed()) {
                    VirtualFile vFile = viewProvider.getVirtualFile();
                    LOG.error("Write action expected; file=" + file + " of " + file.getClass() + "; file.valid=" + file.isValid() + "; file.eventSystemEnabled=" + viewProvider.isEventSystemEnabled() + "; language=" + file.getLanguage() + "; vFile=" + vFile + " of " + vFile.getClass() + "; free-threaded=" + PsiDocumentManagerBase.isFreeThreaded(vFile));
                }
                DocumentCommitThread.doActualPsiChange(file, diffLog);
                DocumentCommitThread.this.assertAfterCommit(document, file, (FileElement)oldFileNode);
                return true;
            }
        };
    }

    private static int getLeafMatchingLength(CharSequence leafText, CharSequence pattern, int patternIndex, int finalPatternIndex, int direction) {
        int leafIndex = direction == 1 ? 0 : leafText.length() - 1;
        int finalLeafIndex = direction == 1 ? leafText.length() - 1 : 0;
        int result = 0;
        while (leafText.charAt(leafIndex) == pattern.charAt(patternIndex)) {
            ++result;
            if (leafIndex == finalLeafIndex || patternIndex == finalPatternIndex) break;
            leafIndex += direction;
            patternIndex += direction;
        }
        return result;
    }

    private static int getMatchingLength(@NotNull FileElement treeElement, @NotNull CharSequence text, boolean fromStart) {
        if (treeElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treeElement", "com/intellij/psi/impl/DocumentCommitThread", "getMatchingLength"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/DocumentCommitThread", "getMatchingLength"));
        }
        int patternIndex = fromStart ? 0 : text.length() - 1;
        int finalPatternIndex = fromStart ? text.length() - 1 : 0;
        int direction = fromStart ? 1 : -1;
        ASTNode leaf = fromStart ? TreeUtil.findFirstLeaf(treeElement, false) : TreeUtil.findLastLeaf(treeElement, false);
        int result = 0;
        while (leaf != null && (fromStart ? patternIndex <= finalPatternIndex : patternIndex >= finalPatternIndex)) {
            CharSequence chars;
            if (!(leaf instanceof ForeignLeafPsiElement) && (chars = leaf.getChars()).length() > 0) {
                int matchingLength = DocumentCommitThread.getLeafMatchingLength(chars, text, patternIndex, finalPatternIndex, direction);
                result += matchingLength;
                if (matchingLength != chars.length()) break;
                patternIndex += fromStart ? matchingLength : -matchingLength;
            }
            leaf = fromStart ? TreeUtil.nextLeaf(leaf, false) : TreeUtil.prevLeaf(leaf, false);
        }
        return result;
    }

    @Nullable
    public static TextRange getChangedPsiRange(@NotNull PsiFile file, @NotNull FileElement treeElement, @NotNull CharSequence newDocumentText) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/DocumentCommitThread", "getChangedPsiRange"));
        }
        if (treeElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treeElement", "com/intellij/psi/impl/DocumentCommitThread", "getChangedPsiRange"));
        }
        if (newDocumentText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newDocumentText", "com/intellij/psi/impl/DocumentCommitThread", "getChangedPsiRange"));
        }
        int psiLength = treeElement.getTextLength();
        if (!file.getViewProvider().supportsIncrementalReparse(file.getLanguage())) {
            return new TextRange(0, psiLength);
        }
        int commonPrefixLength = DocumentCommitThread.getMatchingLength(treeElement, newDocumentText, true);
        if (commonPrefixLength == newDocumentText.length() && newDocumentText.length() == psiLength) {
            return null;
        }
        int commonSuffixLength = Math.min(DocumentCommitThread.getMatchingLength(treeElement, newDocumentText, false), psiLength - commonPrefixLength);
        return new TextRange(commonPrefixLength, psiLength - commonSuffixLength);
    }

    @Nullable
    private static TextRange getChangedPsiRange(@NotNull PsiFile file, @NotNull CharSequence oldDocumentText, @NotNull CharSequence newDocumentText) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/DocumentCommitThread", "getChangedPsiRange"));
        }
        if (oldDocumentText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldDocumentText", "com/intellij/psi/impl/DocumentCommitThread", "getChangedPsiRange"));
        }
        if (newDocumentText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newDocumentText", "com/intellij/psi/impl/DocumentCommitThread", "getChangedPsiRange"));
        }
        int psiLength = oldDocumentText.length();
        if (!file.getViewProvider().supportsIncrementalReparse(file.getLanguage())) {
            return new TextRange(0, psiLength);
        }
        int commonPrefixLength = StringUtil.commonPrefixLength(oldDocumentText, newDocumentText);
        if (commonPrefixLength == newDocumentText.length() && newDocumentText.length() == psiLength) {
            return null;
        }
        int commonSuffixLength = Math.min(StringUtil.commonSuffixLength(oldDocumentText, newDocumentText), psiLength - commonPrefixLength);
        return new TextRange(commonPrefixLength, psiLength - commonSuffixLength);
    }

    public static void doActualPsiChange(final @NotNull PsiFile file, final @NotNull DiffLog diffLog) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/DocumentCommitThread", "doActualPsiChange"));
        }
        if (diffLog == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diffLog", "com/intellij/psi/impl/DocumentCommitThread", "doActualPsiChange"));
        }
        CodeStyleManager.getInstance(file.getProject()).performActionWithFormatterDisabled(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = PsiLock.LOCK;
                synchronized (object) {
                    file.getViewProvider().beforeContentsSynchronized();
                    Document document = file.getViewProvider().getDocument();
                    PsiDocumentManagerBase documentManager = (PsiDocumentManagerBase)PsiDocumentManager.getInstance(file.getProject());
                    PsiToDocumentSynchronizer.DocumentChangeTransaction transaction = documentManager.getSynchronizer().getTransaction(document);
                    PsiFileImpl fileImpl = (PsiFileImpl)file;
                    if (transaction == null) {
                        final PomModel model = PomManager.getModel(fileImpl.getProject());
                        model.runTransaction(new PomTransactionBase(fileImpl, model.getModelAspect(TreeAspect.class)){

                            @Override
                            public PomModelEvent runInner() {
                                return new TreeAspectEvent(model, diffLog.performActualPsiChange(file));
                            }
                        });
                    } else {
                        diffLog.performActualPsiChange(file);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertAfterCommit(@NotNull Document document, @NotNull PsiFile file, @NotNull FileElement oldFileNode) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/DocumentCommitThread", "assertAfterCommit"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/DocumentCommitThread", "assertAfterCommit"));
        }
        if (oldFileNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldFileNode", "com/intellij/psi/impl/DocumentCommitThread", "assertAfterCommit"));
        }
        if (oldFileNode.getTextLength() != document.getTextLength()) {
            String documentText = document.getText();
            String fileText = file.getText();
            boolean sameText = Comparing.equal(fileText, documentText);
            LOG.error("commitDocument() left PSI inconsistent: " + DebugUtil.diagnosePsiDocumentInconsistency(file, document) + "; node.length=" + oldFileNode.getTextLength() + "; doc.text" + (sameText ? "==" : "!=") + "file.text", new Attachment("file psi text", fileText), new Attachment("old text", documentText));
            file.putUserData(BlockSupport.DO_NOT_REPARSE_INCREMENTALLY, Boolean.TRUE);
            try {
                BlockSupport blockSupport = BlockSupport.getInstance(file.getProject());
                DiffLog diffLog = blockSupport.reparseRange(file, file.getNode(), new TextRange(0, documentText.length()), documentText, this.createProgressIndicator(), oldFileNode.getText());
                DocumentCommitThread.doActualPsiChange(file, diffLog);
                if (oldFileNode.getTextLength() != document.getTextLength()) {
                    LOG.error("PSI is broken beyond repair in: " + file);
                }
            }
            finally {
                file.putUserData(BlockSupport.DO_NOT_REPARSE_INCREMENTALLY, null);
            }
        }
    }

    private static Lock getDocumentLock(Document document) {
        Lock lock = document.getUserData(DOCUMENT_LOCK);
        return lock != null ? lock : (Lock)((UserDataHolderEx)((Object)document)).putUserDataIfAbsent(DOCUMENT_LOCK, new ReentrantLock());
    }

    private static class CommitTask {
        static final Key<Object> CANCEL_REASON = Key.create("CANCEL_REASON");
        @NotNull
        final Document document;
        @NotNull
        final Project project;
        private final int modificationSequence;
        @NotNull
        final ProgressIndicator indicator;
        @NotNull
        final Object reason;
        @NotNull
        final ModalityState myCreationModalityState;
        private final CharSequence myLastCommittedText;
        @NotNull
        final List<Pair<PsiFileImpl, FileASTNode>> myOldFileNodes;

        protected CommitTask(@NotNull Project project, @NotNull Document document, @NotNull List<Pair<PsiFileImpl, FileASTNode>> oldFileNodes, @NotNull ProgressIndicator indicator, @NotNull Object reason, @NotNull ModalityState currentModalityState) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/DocumentCommitThread$CommitTask", "<init>"));
            }
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/DocumentCommitThread$CommitTask", "<init>"));
            }
            if (oldFileNodes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldFileNodes", "com/intellij/psi/impl/DocumentCommitThread$CommitTask", "<init>"));
            }
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/psi/impl/DocumentCommitThread$CommitTask", "<init>"));
            }
            if (reason == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "com/intellij/psi/impl/DocumentCommitThread$CommitTask", "<init>"));
            }
            if (currentModalityState == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentModalityState", "com/intellij/psi/impl/DocumentCommitThread$CommitTask", "<init>"));
            }
            this.document = document;
            this.project = project;
            this.indicator = indicator;
            this.reason = reason;
            this.myCreationModalityState = currentModalityState;
            this.myLastCommittedText = PsiDocumentManager.getInstance(project).getLastCommittedText(document);
            this.myOldFileNodes = oldFileNodes;
            this.modificationSequence = ((DocumentEx)document).getModificationSequence();
        }

        @NonNls
        public String toString() {
            return "Doc: " + this.document + " (\"" + StringUtil.first(this.document.getImmutableCharSequence(), 40, true).toString().replaceAll("\n", " ") + "\")" + (this.indicator.isCanceled() ? " (Canceled: " + ((UserDataHolder)((Object)this.indicator)).getUserData(CANCEL_REASON) + ")" : "") + " Reason: " + this.reason + (this.isStillValid() ? "" : "; changed: old seq=" + this.modificationSequence + ", new seq=" + ((DocumentEx)this.document).getModificationSequence());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CommitTask)) {
                return false;
            }
            CommitTask task = (CommitTask)o;
            return this.document.equals(task.document) && this.project.equals(task.project);
        }

        public int hashCode() {
            int result = this.document.hashCode();
            result = 31 * result + this.project.hashCode();
            return result;
        }

        public boolean isStillValid() {
            return ((DocumentEx)this.document).getModificationSequence() == this.modificationSequence;
        }

        private void cancel(@NotNull Object reason, @NotNull DocumentCommitThread commitProcessor) {
            if (reason == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "com/intellij/psi/impl/DocumentCommitThread$CommitTask", "cancel"));
            }
            if (commitProcessor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitProcessor", "com/intellij/psi/impl/DocumentCommitThread$CommitTask", "cancel"));
            }
            if (!this.indicator.isCanceled()) {
                commitProcessor.log(this.project, "indicator cancel", this, new Object[0]);
                this.indicator.cancel();
                ((UserDataHolder)((Object)this.indicator)).putUserData(CANCEL_REASON, reason);
            }
        }
    }
}

