/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiSuperMethodUtil;
import com.intellij.psi.util.TypeConversionUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class FindSuperElementsHelper {
    @NotNull
    public static PsiElement[] findSuperElements(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/FindSuperElementsHelper", "findSuperElements"));
        }
        if (element instanceof PsiClass) {
            PsiClass aClass = (PsiClass)element;
            ArrayList<PsiClass> allSupers = new ArrayList<PsiClass>(Arrays.asList(aClass.getSupers()));
            Iterator iterator = allSupers.iterator();
            while (iterator.hasNext()) {
                PsiClass superClass = (PsiClass)iterator.next();
                if (!"java.lang.Object".equals(superClass.getQualifiedName())) continue;
                iterator.remove();
            }
            PsiElement[] psiElementArray = allSupers.toArray(new PsiClass[allSupers.size()]);
            if (psiElementArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/FindSuperElementsHelper", "findSuperElements"));
            }
            return psiElementArray;
        }
        if (element instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)element;
            if (method.isConstructor()) {
                PsiMethod constructorInSuper = PsiSuperMethodUtil.findConstructorInSuper(method);
                if (constructorInSuper != null) {
                    PsiElement[] psiElementArray = new PsiMethod[]{constructorInSuper};
                    if (psiElementArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/FindSuperElementsHelper", "findSuperElements"));
                    }
                    return psiElementArray;
                }
            } else {
                PsiMethod superMethod;
                PsiElement[] superMethods = method.findSuperMethods(false);
                if (superMethods.length == 0 && (superMethod = FindSuperElementsHelper.getSiblingInheritedViaSubClass(method)) != null) {
                    superMethods = new PsiMethod[]{superMethod};
                }
                if (superMethods == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/FindSuperElementsHelper", "findSuperElements"));
                }
                return superMethods;
            }
        }
        if (PsiElement.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/FindSuperElementsHelper", "findSuperElements"));
        }
        return PsiElement.EMPTY_ARRAY;
    }

    public static PsiMethod getSiblingInheritedViaSubClass(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/impl/FindSuperElementsHelper", "getSiblingInheritedViaSubClass"));
        }
        return Pair.getFirst(FindSuperElementsHelper.getSiblingInfoInheritedViaSubClass(method));
    }

    public static Pair<PsiMethod, PsiClass> getSiblingInfoInheritedViaSubClass(@NotNull PsiMethod method) {
        boolean canHaveSiblingSuper;
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/impl/FindSuperElementsHelper", "getSiblingInfoInheritedViaSubClass"));
        }
        boolean bl = canHaveSiblingSuper = !method.hasModifierProperty("abstract") && !method.hasModifierProperty("static") && method.hasModifierProperty("public") && !method.hasModifierProperty("final") && !method.hasModifierProperty("native");
        if (!canHaveSiblingSuper) {
            return null;
        }
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null || containingClass.isInterface() || containingClass.hasModifierProperty("final")) {
            return null;
        }
        if ("java.lang.Object".equals(containingClass.getQualifiedName())) {
            return null;
        }
        THashSet checkedInterfaces = new THashSet();
        checkedInterfaces.add(PsiAnchor.create(containingClass));
        Ref result = Ref.create();
        ClassInheritorsSearch.search(containingClass, containingClass.getUseScope(), true, true, false).forEach(arg_0 -> FindSuperElementsHelper.lambda$getSiblingInfoInheritedViaSubClass$0((Collection)checkedInterfaces, method, containingClass, result, arg_0));
        return (Pair)result.get();
    }

    private static /* synthetic */ boolean lambda$getSiblingInfoInheritedViaSubClass$0(Collection checkedInterfaces, @NotNull PsiMethod method, PsiClass containingClass, Ref result, PsiClass inheritor) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/impl/FindSuperElementsHelper", "lambda$getSiblingInfoInheritedViaSubClass$0"));
        }
        ProgressManager.checkCanceled();
        for (PsiClassType interfaceType : inheritor.getImplementsListTypes()) {
            ProgressManager.checkCanceled();
            PsiClassType.ClassResolveResult resolved = interfaceType.resolveGenerics();
            PsiClass anInterface = resolved.getElement();
            if (anInterface == null || !checkedInterfaces.add(PsiAnchor.create(anInterface))) continue;
            for (PsiMethod superMethod : anInterface.findMethodsByName(method.getName(), true)) {
                MethodSignature derivedSignature;
                PsiElement navigationElement = superMethod.getNavigationElement();
                if (!(navigationElement instanceof PsiMethod)) continue;
                superMethod = (PsiMethod)navigationElement;
                ProgressManager.checkCanceled();
                PsiClass superInterface = superMethod.getContainingClass();
                if (superInterface == null || containingClass.isInheritor(superInterface, true)) continue;
                PsiSubstitutor substitutor = TypeConversionUtil.getSuperClassSubstitutor(containingClass, inheritor, PsiSubstitutor.EMPTY);
                MethodSignature superSignature = superMethod.getSignature(substitutor = TypeConversionUtil.getSuperClassSubstitutor(superInterface, inheritor, substitutor));
                boolean isOverridden = MethodSignatureUtil.isSubsignature(superSignature, derivedSignature = method.getSignature(PsiSubstitutor.EMPTY));
                if (!isOverridden) continue;
                result.set(Pair.create(superMethod, inheritor));
                return false;
            }
        }
        return true;
    }
}

