/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs.index;

import com.intellij.psi.impl.java.stubs.hierarchy.IndexTree;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.KeyDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class JavaUnitKeyDescriptor
implements KeyDescriptor<IndexTree.Unit> {
    public static JavaUnitKeyDescriptor INSTANCE = new JavaUnitKeyDescriptor();

    @Override
    public void save(@NotNull DataOutput out, IndexTree.Unit value) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/psi/impl/java/stubs/index/JavaUnitKeyDescriptor", "save"));
        }
        out.writeInt(value.myFileId);
        String pidToWrite = value.myPackageId == null ? "" : value.myPackageId;
        out.writeUTF(pidToWrite);
        out.writeByte(value.myUnitType);
        if (value.myUnitType != 0) {
            DataInputOutputUtil.writeINT(out, value.imports.length);
            for (IndexTree.Import anImport : value.imports) {
                out.writeUTF(anImport.myFullname);
                out.writeBoolean(anImport.myStaticImport);
                out.writeBoolean(anImport.myOnDemand);
            }
        }
        DataInputOutputUtil.writeINT(out, value.myDecls.length);
        for (IndexTree.ClassDecl def : value.myDecls) {
            this.saveClassDecl(out, def);
        }
    }

    private void saveClassDecl(@NotNull DataOutput out, IndexTree.ClassDecl value) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/psi/impl/java/stubs/index/JavaUnitKeyDescriptor", "saveClassDecl"));
        }
        out.writeInt(value.myStubId);
        DataInputOutputUtil.writeINT(out, value.myMods);
        out.writeUTF(value.myName == null ? "" : value.myName);
        DataInputOutputUtil.writeINT(out, value.mySupers.length);
        for (String aSuper : value.mySupers) {
            out.writeUTF(aSuper);
        }
        DataInputOutputUtil.writeINT(out, value.myDecls.length);
        for (IndexTree.Decl def : value.myDecls) {
            this.saveDecl(out, def);
        }
    }

    private void saveDecl(@NotNull DataOutput out, IndexTree.Decl value) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/psi/impl/java/stubs/index/JavaUnitKeyDescriptor", "saveDecl"));
        }
        if (value instanceof IndexTree.ClassDecl) {
            out.writeBoolean(true);
            this.saveClassDecl(out, (IndexTree.ClassDecl)value);
        } else if (value instanceof IndexTree.MemberDecl) {
            out.writeBoolean(false);
            IndexTree.MemberDecl memberDecl = (IndexTree.MemberDecl)value;
            DataInputOutputUtil.writeINT(out, memberDecl.myDecls.length);
            for (IndexTree.Decl def : memberDecl.myDecls) {
                this.saveDecl(out, def);
            }
        }
    }

    @Override
    public IndexTree.Unit read(@NotNull DataInput in) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/psi/impl/java/stubs/index/JavaUnitKeyDescriptor", "read"));
        }
        int fileId = in.readInt();
        String pid = in.readUTF();
        if (pid.isEmpty()) {
            pid = null;
        }
        byte type = in.readByte();
        IndexTree.Import[] imports = IndexTree.Import.EMPTY_ARRAY;
        if (type != 0) {
            imports = new IndexTree.Import[DataInputOutputUtil.readINT(in)];
            for (int i = 0; i < imports.length; ++i) {
                imports[i] = new IndexTree.Import(in.readUTF(), in.readBoolean(), in.readBoolean(), null);
            }
        }
        IndexTree.ClassDecl[] classes = new IndexTree.ClassDecl[DataInputOutputUtil.readINT(in)];
        for (int i = 0; i < classes.length; ++i) {
            classes[i] = this.readClassDecl(in);
        }
        return new IndexTree.Unit(fileId, pid, type, imports, classes);
    }

    private IndexTree.ClassDecl readClassDecl(DataInput in) throws IOException {
        int stubId = in.readInt();
        int mods = DataInputOutputUtil.readINT(in);
        String name = in.readUTF();
        if (name.isEmpty()) {
            name = null;
        }
        String[] supers = new String[DataInputOutputUtil.readINT(in)];
        for (int i = 0; i < supers.length; ++i) {
            supers[i] = in.readUTF();
        }
        IndexTree.Decl[] decls = new IndexTree.Decl[DataInputOutputUtil.readINT(in)];
        for (int i = 0; i < decls.length; ++i) {
            decls[i] = this.readDecl(in);
        }
        return new IndexTree.ClassDecl(stubId, mods, name, supers, decls);
    }

    private IndexTree.Decl readDecl(DataInput in) throws IOException {
        boolean isClassDecl = in.readBoolean();
        if (isClassDecl) {
            return this.readClassDecl(in);
        }
        IndexTree.Decl[] decls = new IndexTree.Decl[DataInputOutputUtil.readINT(in)];
        for (int i = 0; i < decls.length; ++i) {
            decls[i] = this.readDecl(in);
        }
        return new IndexTree.MemberDecl(decls);
    }

    @Override
    public int getHashCode(IndexTree.Unit value) {
        return value.hashCode();
    }

    @Override
    public boolean isEqual(IndexTree.Unit val1, IndexTree.Unit val2) {
        return val1.equals(val2);
    }
}

