/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.light;

import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.impl.light.LightReferenceParameterList;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightClassReference
extends LightElement
implements PsiJavaCodeReferenceElement {
    private final String myText;
    private final String myClassName;
    private final PsiElement myContext;
    @NotNull
    private final GlobalSearchScope myResolveScope;
    private final PsiClass myRefClass;
    private final PsiSubstitutor mySubstitutor;
    private LightReferenceParameterList myParameterList;

    private LightClassReference(@NotNull PsiManager manager, @NotNull @NonNls String text, @Nullable @NonNls String className, @Nullable PsiSubstitutor substitutor, @NotNull GlobalSearchScope resolveScope, @Nullable PsiElement context, @Nullable PsiClass refClass) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/impl/light/LightClassReference", "<init>"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/light/LightClassReference", "<init>"));
        }
        if (resolveScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveScope", "com/intellij/psi/impl/light/LightClassReference", "<init>"));
        }
        super(manager, JavaLanguage.INSTANCE);
        this.myText = text;
        this.myClassName = className;
        this.myResolveScope = resolveScope;
        this.myContext = context;
        this.myRefClass = refClass;
        this.mySubstitutor = substitutor;
    }

    public LightClassReference(@NotNull PsiManager manager, @NotNull @NonNls String text, @NotNull @NonNls String className, @NotNull GlobalSearchScope resolveScope) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/impl/light/LightClassReference", "<init>"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/light/LightClassReference", "<init>"));
        }
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/intellij/psi/impl/light/LightClassReference", "<init>"));
        }
        if (resolveScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveScope", "com/intellij/psi/impl/light/LightClassReference", "<init>"));
        }
        this(manager, text, className, null, resolveScope, null, null);
    }

    public LightClassReference(@NotNull PsiManager manager, @NotNull @NonNls String text, @NotNull @NonNls String className, PsiSubstitutor substitutor, @NotNull PsiElement context) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/impl/light/LightClassReference", "<init>"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/light/LightClassReference", "<init>"));
        }
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/intellij/psi/impl/light/LightClassReference", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/impl/light/LightClassReference", "<init>"));
        }
        this(manager, text, className, substitutor, context.getResolveScope(), context, null);
    }

    public LightClassReference(@NotNull PsiManager manager, @NotNull @NonNls String text, @NotNull PsiClass refClass) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/impl/light/LightClassReference", "<init>"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/light/LightClassReference", "<init>"));
        }
        if (refClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refClass", "com/intellij/psi/impl/light/LightClassReference", "<init>"));
        }
        this(manager, text, refClass, null);
    }

    public LightClassReference(@NotNull PsiManager manager, @NotNull @NonNls String text, @NotNull PsiClass refClass, PsiSubstitutor substitutor) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/impl/light/LightClassReference", "<init>"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/light/LightClassReference", "<init>"));
        }
        if (refClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refClass", "com/intellij/psi/impl/light/LightClassReference", "<init>"));
        }
        this(manager, text, null, substitutor, refClass.getResolveScope(), null, refClass);
    }

    @Override
    public PsiElement resolve() {
        if (this.myClassName != null) {
            JavaPsiFacade facade = JavaPsiFacade.getInstance(this.getProject());
            if (this.myContext != null) {
                return facade.getResolveHelper().resolveReferencedClass(this.myClassName, this.myContext);
            }
            return facade.findClass(this.myClassName, this.myResolveScope);
        }
        return this.myRefClass;
    }

    @Override
    @NotNull
    public JavaResolveResult advancedResolve(boolean incompleteCode) {
        PsiElement resolved = this.resolve();
        if (resolved == null) {
            JavaResolveResult javaResolveResult = JavaResolveResult.EMPTY;
            if (javaResolveResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightClassReference", "advancedResolve"));
            }
            return javaResolveResult;
        }
        PsiSubstitutor substitutor = this.mySubstitutor;
        if (substitutor == null) {
            substitutor = resolved instanceof PsiClass ? JavaPsiFacade.getInstance(this.myManager.getProject()).getElementFactory().createRawSubstitutor((PsiClass)resolved) : PsiSubstitutor.EMPTY;
        }
        CandidateInfo candidateInfo = new CandidateInfo(resolved, substitutor);
        if (candidateInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightClassReference", "advancedResolve"));
        }
        return candidateInfo;
    }

    @Override
    @NotNull
    public JavaResolveResult[] multiResolve(boolean incompleteCode) {
        JavaResolveResult result = this.advancedResolve(incompleteCode);
        if (result != JavaResolveResult.EMPTY) {
            JavaResolveResult[] javaResolveResultArray = new JavaResolveResult[]{result};
            if (javaResolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightClassReference", "multiResolve"));
            }
            return javaResolveResultArray;
        }
        if (JavaResolveResult.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightClassReference", "multiResolve"));
        }
        return JavaResolveResult.EMPTY_ARRAY;
    }

    @Override
    public void processVariants(@NotNull PsiScopeProcessor processor) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/light/LightClassReference", "processVariants"));
        }
        throw new RuntimeException("Variants are not available for light references");
    }

    @Override
    public PsiElement getReferenceNameElement() {
        return null;
    }

    @Override
    public PsiReferenceParameterList getParameterList() {
        if (this.myParameterList == null) {
            this.myParameterList = new LightReferenceParameterList(this.myManager, PsiTypeElement.EMPTY_ARRAY);
        }
        return this.myParameterList;
    }

    @Override
    public String getQualifiedName() {
        if (this.myClassName != null) {
            PsiClass psiClass;
            if (this.myContext != null && (psiClass = (PsiClass)this.resolve()) != null) {
                return psiClass.getQualifiedName();
            }
            return this.myClassName;
        }
        return this.myRefClass.getQualifiedName();
    }

    @Override
    public String getReferenceName() {
        if (this.myClassName != null) {
            return PsiNameHelper.getShortClassName(this.myClassName);
        }
        if (this.myRefClass instanceof PsiAnonymousClass) {
            return ((PsiAnonymousClass)this.myRefClass).getBaseClassReference().getReferenceName();
        }
        return this.myRefClass.getName();
    }

    @Override
    public String getText() {
        return this.myText;
    }

    @Override
    public PsiReference getReference() {
        return this;
    }

    @Override
    @NotNull
    public String getCanonicalText() {
        String name = this.getQualifiedName();
        if (name == null) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightClassReference", "getCanonicalText"));
            }
            return "";
        }
        PsiType[] types = this.getTypeParameters();
        if (types.length == 0) {
            String string = name;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightClassReference", "getCanonicalText"));
            }
            return string;
        }
        StringBuilder buf = new StringBuilder();
        buf.append(name);
        buf.append('<');
        for (int i = 0; i < types.length; ++i) {
            if (i > 0) {
                buf.append(',');
            }
            buf.append(types[i].getCanonicalText());
        }
        buf.append('>');
        String string = buf.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightClassReference", "getCanonicalText"));
        }
        return string;
    }

    @Override
    public PsiElement copy() {
        if (this.myClassName != null) {
            if (this.myContext != null) {
                return new LightClassReference(this.myManager, this.myText, this.myClassName, this.mySubstitutor, this.myContext);
            }
            return new LightClassReference(this.myManager, this.myText, this.myClassName, this.mySubstitutor, this.myResolveScope, null, null);
        }
        return new LightClassReference(this.myManager, this.myText, this.myRefClass, this.mySubstitutor);
    }

    @Override
    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/light/LightClassReference", "bindToElement"));
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/light/LightClassReference", "accept"));
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitReferenceElement(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "LightClassReference:" + this.myText;
    }

    @Override
    public boolean isReferenceTo(PsiElement element) {
        return element instanceof PsiClass && this.getManager().areElementsEquivalent(this.resolve(), element);
    }

    @Override
    @NotNull
    public Object[] getVariants() {
        throw new RuntimeException("Variants are not available for light references");
    }

    @Override
    public boolean isSoft() {
        return false;
    }

    @Override
    public TextRange getRangeInElement() {
        return new TextRange(0, this.getTextLength());
    }

    @Override
    public PsiElement getElement() {
        return this;
    }

    @Override
    public boolean isValid() {
        return this.myRefClass == null || this.myRefClass.isValid();
    }

    @Override
    @NotNull
    public PsiType[] getTypeParameters() {
        if (PsiType.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightClassReference", "getTypeParameters"));
        }
        return PsiType.EMPTY_ARRAY;
    }

    @Override
    public PsiElement getQualifier() {
        return null;
    }

    @Override
    public boolean isQualified() {
        return false;
    }

    @Override
    @NotNull
    public GlobalSearchScope getResolveScope() {
        GlobalSearchScope globalSearchScope = this.myResolveScope;
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightClassReference", "getResolveScope"));
        }
        return globalSearchScope;
    }
}

