/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.impl.light.LightMemberReference;
import com.intellij.psi.impl.search.MethodUsagesSearcher;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;

public class ConstructorReferencesSearchHelper {
    private final PsiManager myManager;

    public ConstructorReferencesSearchHelper(@NotNull PsiManager manager) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "<init>"));
        }
        this.myManager = manager;
    }

    public boolean processConstructorReferences(final @NotNull Processor<PsiReference> processor, final @NotNull PsiMethod constructor, final @NotNull PsiClass containingClass, final @NotNull SearchScope searchScope, final @NotNull Project project, boolean ignoreAccessScope, final boolean isStrictSignatureSearch, @NotNull SearchRequestCollector collector) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "processConstructorReferences"));
        }
        if (constructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "processConstructorReferences"));
        }
        if (containingClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingClass", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "processConstructorReferences"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "processConstructorReferences"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "processConstructorReferences"));
        }
        if (collector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collector", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "processConstructorReferences"));
        }
        final boolean[] constructorCanBeCalledImplicitly = new boolean[1];
        final boolean[] isEnum = new boolean[1];
        final boolean[] isUnder18 = new boolean[1];
        MethodUsagesSearcher.resolveInReadAction(project, new Computable<Void>(){

            @Override
            public Void compute() {
                constructorCanBeCalledImplicitly[0] = constructor.getParameterList().getParametersCount() == 0;
                isEnum[0] = containingClass.isEnum();
                isUnder18[0] = PsiUtil.getLanguageLevel(containingClass).isAtLeast(LanguageLevel.JDK_1_8);
                return null;
            }
        });
        if (isEnum[0] && !ConstructorReferencesSearchHelper.processEnumReferences(processor, constructor, project, containingClass)) {
            return false;
        }
        PairProcessor<PsiReference, SearchRequestCollector> processor1 = (reference, collector1) -> {
            PsiMethod constructor1;
            if (constructor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "lambda$processConstructorReferences$0"));
            }
            if (processor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "lambda$processConstructorReferences$0"));
            }
            if (containingClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingClass", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "lambda$processConstructorReferences$0"));
            }
            PsiElement parent = reference.getElement().getParent();
            if (parent instanceof PsiAnonymousClass) {
                parent = parent.getParent();
            }
            if (parent instanceof PsiNewExpression && (constructor1 = ((PsiNewExpression)parent).resolveConstructor()) != null && (isStrictSignatureSearch ? this.myManager.areElementsEquivalent(constructor, constructor1) : this.myManager.areElementsEquivalent(containingClass, constructor1.getContainingClass()))) {
                return processor.process((PsiReference)reference);
            }
            return true;
        };
        ReferencesSearch.searchOptimized(containingClass, searchScope, ignoreAccessScope, collector, true, processor1);
        if (isUnder18[0] && !ConstructorReferencesSearchHelper.process18MethodPointers(processor, constructor, project, containingClass, searchScope)) {
            return false;
        }
        if (!MethodUsagesSearcher.resolveInReadAction(project, new Computable<Boolean>(){

            @Override
            public Boolean compute() {
                return ConstructorReferencesSearchHelper.this.processSuperOrThis(containingClass, constructor, constructorCanBeCalledImplicitly[0], searchScope, project, isStrictSignatureSearch, "this", processor);
            }
        }).booleanValue()) {
            return false;
        }
        Processor<PsiClass> processor2 = inheritor -> {
            if (constructor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "lambda$processConstructorReferences$1"));
            }
            if (searchScope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "lambda$processConstructorReferences$1"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "lambda$processConstructorReferences$1"));
            }
            if (processor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "lambda$processConstructorReferences$1"));
            }
            PsiElement navigationElement = inheritor.getNavigationElement();
            if (navigationElement instanceof PsiClass) {
                return this.processSuperOrThis((PsiClass)navigationElement, constructor, constructorCanBeCalledImplicitly[0], searchScope, project, isStrictSignatureSearch, "super", processor);
            }
            return true;
        };
        return ClassInheritorsSearch.search(containingClass, searchScope, false).forEach(processor2);
    }

    private static boolean processEnumReferences(final @NotNull Processor<PsiReference> processor, final @NotNull PsiMethod constructor, @NotNull Project project, final @NotNull PsiClass aClass) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "processEnumReferences"));
        }
        if (constructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "processEnumReferences"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "processEnumReferences"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "processEnumReferences"));
        }
        return MethodUsagesSearcher.resolveInReadAction(project, new Computable<Boolean>(){

            @Override
            public Boolean compute() {
                for (PsiField field : aClass.getFields()) {
                    PsiReference reference;
                    if (!(field instanceof PsiEnumConstant) || (reference = field.getReference()) == null || !reference.isReferenceTo(constructor) || processor.process(reference)) continue;
                    return false;
                }
                return true;
            }
        });
    }

    private static boolean process18MethodPointers(final @NotNull Processor<PsiReference> processor, final @NotNull PsiMethod constructor, @NotNull Project project, @NotNull PsiClass aClass, SearchScope searchScope) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "process18MethodPointers"));
        }
        if (constructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "process18MethodPointers"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "process18MethodPointers"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "process18MethodPointers"));
        }
        return ReferencesSearch.search(aClass, searchScope).forEach(reference -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "lambda$process18MethodPointers$2"));
            }
            if (constructor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "lambda$process18MethodPointers$2"));
            }
            if (processor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "lambda$process18MethodPointers$2"));
            }
            final PsiElement element = reference.getElement();
            if (element != null) {
                return MethodUsagesSearcher.resolveInReadAction(project, new Computable<Boolean>(){

                    @Override
                    public Boolean compute() {
                        PsiElement parent = element.getParent();
                        if (parent instanceof PsiMethodReferenceExpression && ((PsiMethodReferenceExpression)parent).getReferenceNameElement() instanceof PsiKeyword && ((PsiMethodReferenceExpression)parent).isReferenceTo(constructor) && !processor.process((PsiReference)((Object)parent))) {
                            return false;
                        }
                        return true;
                    }
                });
            }
            return true;
        });
    }

    private boolean processSuperOrThis(@NotNull PsiClass inheritor, @NotNull PsiMethod constructor, boolean constructorCanBeCalledImplicitly, @NotNull SearchScope searchScope, @NotNull Project project, boolean isStrictSignatureSearch, @NotNull String superOrThisKeyword, @NotNull Processor<PsiReference> processor) {
        if (inheritor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inheritor", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "processSuperOrThis"));
        }
        if (constructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "processSuperOrThis"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "processSuperOrThis"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "processSuperOrThis"));
        }
        if (superOrThisKeyword == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superOrThisKeyword", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "processSuperOrThis"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "processSuperOrThis"));
        }
        PsiMethod[] constructors = inheritor.getConstructors();
        if (constructors.length == 0 && constructorCanBeCalledImplicitly && !this.processImplicitConstructorCall(inheritor, processor, constructor, project, inheritor)) {
            return false;
        }
        for (PsiMethod method : constructors) {
            PsiReferenceExpression refExpr;
            PsiExpression expr;
            PsiStatement statement;
            PsiCodeBlock body = method.getBody();
            if (body == null || method == constructor && isStrictSignatureSearch) continue;
            PsiStatement[] statements = body.getStatements();
            if (statements.length != 0 && (statement = statements[0]) instanceof PsiExpressionStatement && (expr = ((PsiExpressionStatement)statement).getExpression()) instanceof PsiMethodCallExpression && PsiSearchScopeUtil.isInScope(searchScope, (PsiElement)(refExpr = ((PsiMethodCallExpression)expr).getMethodExpression())) && refExpr.textMatches(superOrThisKeyword)) {
                boolean match;
                PsiElement referencedElement = refExpr.resolve();
                if (!(referencedElement instanceof PsiMethod)) continue;
                PsiMethod constructor1 = (PsiMethod)referencedElement;
                boolean bl = match = isStrictSignatureSearch ? this.myManager.areElementsEquivalent(constructor1, constructor) : this.myManager.areElementsEquivalent(constructor.getContainingClass(), constructor1.getContainingClass());
                if (!match || processor.process(refExpr)) continue;
                return false;
            }
            if (!constructorCanBeCalledImplicitly || !PsiSearchScopeUtil.isInScope(searchScope, (PsiElement)method) || this.processImplicitConstructorCall(method, processor, constructor, project, inheritor)) continue;
            return false;
        }
        return true;
    }

    private boolean processImplicitConstructorCall(final @NotNull PsiMember usage, @NotNull Processor<PsiReference> processor, final @NotNull PsiMethod constructor, @NotNull Project project, final @NotNull PsiClass containingClass) {
        if (usage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usage", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "processImplicitConstructorCall"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "processImplicitConstructorCall"));
        }
        if (constructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "processImplicitConstructorCall"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "processImplicitConstructorCall"));
        }
        if (containingClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingClass", "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper", "processImplicitConstructorCall"));
        }
        if (containingClass instanceof PsiAnonymousClass) {
            return true;
        }
        boolean same = MethodUsagesSearcher.resolveInReadAction(project, new Computable<Boolean>(){

            @Override
            public Boolean compute() {
                return ConstructorReferencesSearchHelper.this.myManager.areElementsEquivalent(constructor.getContainingClass(), containingClass.getSuperClass());
            }
        });
        if (!same) {
            return true;
        }
        return processor.process(new LightMemberReference(this.myManager, usage, PsiSubstitutor.EMPTY){

            @Override
            public PsiElement getElement() {
                return usage;
            }

            @Override
            public TextRange getRangeInElement() {
                int startOffsetInParent;
                PsiElement identifier;
                if (usage instanceof PsiNameIdentifierOwner && (identifier = ((PsiNameIdentifierOwner)((Object)usage)).getNameIdentifier()) != null && (startOffsetInParent = identifier.getStartOffsetInParent()) >= 0) {
                    return TextRange.from(startOffsetInParent, identifier.getTextLength());
                }
                return super.getRangeInElement();
            }
        });
    }
}

