/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AllOverridingMethodsSearch;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import com.intellij.util.containers.MultiMap;
import org.jetbrains.annotations.NotNull;

public class JavaAllOverridingMethodsSearcher
implements QueryExecutor<Pair<PsiMethod, PsiMethod>, AllOverridingMethodsSearch.SearchParameters> {
    @Override
    public boolean execute(@NotNull AllOverridingMethodsSearch.SearchParameters p, @NotNull Processor<Pair<PsiMethod, PsiMethod>> consumer) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/psi/impl/search/JavaAllOverridingMethodsSearcher", "execute"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/search/JavaAllOverridingMethodsSearcher", "execute"));
        }
        PsiClass psiClass = p.getPsiClass();
        MultiMap potentials = ApplicationManager.getApplication().runReadAction(() -> {
            MultiMap<String, PsiMethod> result = MultiMap.create();
            for (PsiMethod method : psiClass.getMethods()) {
                ProgressManager.checkCanceled();
                if (!PsiUtil.canBeOverriden(method)) continue;
                result.putValue(method.getName(), method);
            }
            return result;
        });
        SearchScope scope = p.getScope();
        Processor<PsiClass> inheritorsProcessor = inheritor -> {
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/search/JavaAllOverridingMethodsSearcher", "lambda$execute$1"));
            }
            PsiSubstitutor substitutor = null;
            for (String name : potentials.keySet()) {
                ProgressManager.checkCanceled();
                for (PsiMethod superMethod : potentials.get(name)) {
                    PsiClass superClass;
                    ProgressManager.checkCanceled();
                    if (superMethod.hasModifierProperty("packageLocal") && !JavaPsiFacade.getInstance(inheritor.getProject()).arePackagesTheSame(psiClass, (PsiElement)inheritor)) continue;
                    if (substitutor == null && (substitutor = TypeConversionUtil.getClassSubstitutor(psiClass, inheritor, PsiSubstitutor.EMPTY)) == null) {
                        return true;
                    }
                    MethodSignature superSignature = superMethod.getSignature(substitutor);
                    PsiMethod inInheritor = MethodSignatureUtil.findMethodBySuperSignature(inheritor, superSignature, false);
                    if (inInheritor != null && !inInheritor.hasModifierProperty("static") && !consumer.process(Pair.create(superMethod, inInheritor))) {
                        return false;
                    }
                    if (!psiClass.isInterface() || inheritor.isInterface() || (superClass = inheritor.getSuperClass()) == null || superClass.isInheritor(psiClass, true) || (inInheritor = MethodSignatureUtil.findMethodInSuperClassBySignatureInDerived(inheritor, superClass, superSignature, true)) == null || inInheritor.hasModifierProperty("static") || consumer.process(Pair.create(superMethod, inInheritor))) continue;
                    return false;
                }
            }
            return true;
        };
        return ClassInheritorsSearch.search(psiClass, scope, true).forEach(inheritorsProcessor);
    }
}

