/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors;

import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.util.containers.ConcurrentFactoryMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScopeAttributesUtil {
    private static final ConcurrentFactoryMap<String, TextAttributesKey> ourCache = new ConcurrentFactoryMap<String, TextAttributesKey>(){

        @Override
        @Nullable
        protected TextAttributesKey create(String scope) {
            return TextAttributesKey.find("SCOPE_KEY_" + scope);
        }
    };

    @NotNull
    public static TextAttributesKey getScopeTextAttributeKey(@NotNull String scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/application/options/colors/ScopeAttributesUtil", "getScopeTextAttributeKey"));
        }
        TextAttributesKey textAttributesKey = (TextAttributesKey)ourCache.get(scope);
        if (textAttributesKey == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/colors/ScopeAttributesUtil", "getScopeTextAttributeKey"));
        }
        return textAttributesKey;
    }
}

