/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeHighlighting;

import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.TextAttributesScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringHash;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;

public class RainbowHighlighter {
    private final float[] myFloats;
    private static final HighlightSeverity RAINBOW_ELEMENT_SEV = new HighlightSeverity("RAINBOW_ELEMENT", HighlightSeverity.ERROR.myVal + 10);
    public static final HighlightInfoType RAINBOW_ELEMENT = new HighlightInfoType.HighlightInfoTypeImpl(RAINBOW_ELEMENT_SEV, TextAttributesKey.createTextAttributesKey("RAINBOW_ELEMENT"));

    public RainbowHighlighter(@NotNull TextAttributesScheme colorsScheme) {
        if (colorsScheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorsScheme", "com/intellij/codeHighlighting/RainbowHighlighter", "<init>"));
        }
        float[] components = colorsScheme.getAttributes(DefaultLanguageHighlighterColors.CONSTANT).getForegroundColor().getRGBColorComponents(null);
        this.myFloats = Color.RGBtoHSB((int)(255.0f * components[0]), (int)(255.0f * components[0]), (int)(255.0f * components[0]), null);
    }

    public static boolean isRainbowEnabled() {
        return Registry.is("editor.rainbow.identifiers", false);
    }

    @NotNull
    public TextAttributes getAttributes(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/codeHighlighting/RainbowHighlighter", "getAttributes"));
        }
        int hash = StringHash.murmur(name, 0);
        float colors = 36.0f;
        float v = (float)Math.round(Math.abs(36.0f * (float)hash) / 2.1474836E9f) / 36.0f;
        Color color = Color.getHSBColor(v, 0.7f, this.myFloats[2] + 0.3f);
        TextAttributes attributes = new TextAttributes();
        attributes.setForegroundColor(color);
        TextAttributes textAttributes = attributes;
        if (textAttributes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeHighlighting/RainbowHighlighter", "getAttributes"));
        }
        return textAttributes;
    }
}

