/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.AnnotationHolderImpl;
import com.intellij.codeInsight.daemon.impl.CachedAnnotators;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.HighlightVisitor;
import com.intellij.codeInsight.daemon.impl.analysis.ErrorQuickFixProvider;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.highlighting.HighlightErrorFilter;
import com.intellij.lang.ASTNode;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class DefaultHighlightVisitor
implements HighlightVisitor,
DumbAware {
    private AnnotationHolderImpl myAnnotationHolder;
    private final HighlightErrorFilter[] myErrorFilters;
    private final Project myProject;
    private final boolean myHighlightErrorElements;
    private final boolean myRunAnnotators;
    private final DumbService myDumbService;
    private HighlightInfoHolder myHolder;
    private final boolean myBatchMode;
    private final CachedAnnotators cachedAnnotators;

    DefaultHighlightVisitor(@NotNull Project project, @NotNull CachedAnnotators cachedAnnotators) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/DefaultHighlightVisitor", "<init>"));
        }
        if (cachedAnnotators == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cachedAnnotators", "com/intellij/codeInsight/daemon/impl/DefaultHighlightVisitor", "<init>"));
        }
        this(project, true, true, false, cachedAnnotators);
    }

    DefaultHighlightVisitor(@NotNull Project project, boolean highlightErrorElements, boolean runAnnotators, boolean batchMode, @NotNull CachedAnnotators cachedAnnotators) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/DefaultHighlightVisitor", "<init>"));
        }
        if (cachedAnnotators == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cachedAnnotators", "com/intellij/codeInsight/daemon/impl/DefaultHighlightVisitor", "<init>"));
        }
        this.myProject = project;
        this.myHighlightErrorElements = highlightErrorElements;
        this.myRunAnnotators = runAnnotators;
        this.cachedAnnotators = cachedAnnotators;
        this.myErrorFilters = Extensions.getExtensions(HighlightErrorFilter.EP_NAME, (AreaInstance)project);
        this.myDumbService = DumbService.getInstance(project);
        this.myBatchMode = batchMode;
    }

    @Override
    public boolean suitableForFile(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/DefaultHighlightVisitor", "suitableForFile"));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean analyze(@NotNull PsiFile file, boolean updateWholeFile, @NotNull HighlightInfoHolder holder, @NotNull Runnable action) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/DefaultHighlightVisitor", "analyze"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInsight/daemon/impl/DefaultHighlightVisitor", "analyze"));
        }
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/codeInsight/daemon/impl/DefaultHighlightVisitor", "analyze"));
        }
        this.myHolder = holder;
        this.myAnnotationHolder = new AnnotationHolderImpl(holder.getAnnotationSession(), this.myBatchMode);
        try {
            action.run();
        }
        finally {
            this.myAnnotationHolder.clear();
            this.myAnnotationHolder = null;
            this.myHolder = null;
        }
        return true;
    }

    @Override
    public void visit(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/DefaultHighlightVisitor", "visit"));
        }
        if (element instanceof PsiErrorElement) {
            if (this.myHighlightErrorElements) {
                this.visitErrorElement((PsiErrorElement)element);
            }
        } else {
            ASTNode node = element.getNode();
            if (node != null && node.getElementType() == TokenType.BAD_CHARACTER) {
                char c = element.textToCharArray()[0];
                boolean printable = StringUtil.isPrintableUnicode(c) && !Character.isSpaceChar(c);
                String hex = String.format("U+%04X", c);
                String text = "Illegal character: " + (printable ? c + " (" + hex + ")" : hex);
                this.myHolder.add(HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(element).descriptionAndTooltip(text).create());
            }
            if (this.myRunAnnotators) {
                this.runAnnotators(element);
            }
        }
        if (this.myAnnotationHolder.hasAnnotations()) {
            for (Annotation annotation : this.myAnnotationHolder) {
                this.myHolder.add(HighlightInfo.fromAnnotation(annotation, null, this.myBatchMode));
            }
            this.myAnnotationHolder.clear();
        }
    }

    @Override
    @NotNull
    public HighlightVisitor clone() {
        DefaultHighlightVisitor defaultHighlightVisitor = new DefaultHighlightVisitor(this.myProject, this.myHighlightErrorElements, this.myRunAnnotators, this.myBatchMode, this.cachedAnnotators);
        if (defaultHighlightVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/DefaultHighlightVisitor", "clone"));
        }
        return defaultHighlightVisitor;
    }

    @Override
    public int order() {
        return 2;
    }

    private void runAnnotators(PsiElement element) {
        List<Annotator> annotators = this.cachedAnnotators.get(element.getLanguage().getID());
        if (annotators.isEmpty()) {
            return;
        }
        boolean dumb = this.myDumbService.isDumb();
        for (int i = 0; i < annotators.size(); ++i) {
            Annotator annotator = annotators.get(i);
            if (dumb && !DumbService.isDumbAware(annotator)) continue;
            ProgressManager.checkCanceled();
            annotator.annotate(element, this.myAnnotationHolder);
        }
    }

    private void visitErrorElement(PsiErrorElement element) {
        for (HighlightErrorFilter errorFilter : this.myErrorFilters) {
            if (errorFilter.shouldHighlightErrorElement(element)) continue;
            return;
        }
        HighlightInfo info = DefaultHighlightVisitor.createErrorElementInfo(element);
        this.myHolder.add(info);
    }

    private static HighlightInfo createErrorElementInfo(@NotNull PsiErrorElement element) {
        HighlightInfo info;
        String text;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/DefaultHighlightVisitor", "createErrorElementInfo"));
        }
        TextRange range = element.getTextRange();
        String errorDescription = element.getErrorDescription();
        if (!range.isEmpty()) {
            HighlightInfo info2;
            HighlightInfo.Builder builder = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(range);
            if (errorDescription != null) {
                builder.descriptionAndTooltip(errorDescription);
            }
            if ((info2 = builder.create()) != null) {
                for (ErrorQuickFixProvider provider : Extensions.getExtensions(ErrorQuickFixProvider.EP_NAME)) {
                    provider.registerErrorQuickFix(element, info2);
                }
            }
            return info2;
        }
        int offset = range.getStartOffset();
        PsiFile containingFile = element.getContainingFile();
        int fileLength = containingFile.getTextLength();
        FileViewProvider viewProvider = containingFile.getViewProvider();
        PsiElement elementAtOffset = viewProvider.findElementAt(offset, LanguageUtil.getRootLanguage(element));
        String string = text = elementAtOffset == null ? null : elementAtOffset.getText();
        if (offset < fileLength && text != null && !StringUtil.startsWithChar(text, '\n') && !StringUtil.startsWithChar(text, '\r')) {
            HighlightInfo.Builder builder = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(offset, offset + 1);
            if (errorDescription != null) {
                builder.descriptionAndTooltip(errorDescription);
            }
            info = builder.create();
        } else {
            int end;
            int start;
            if (offset > 0) {
                start = offset;
                end = offset;
            } else {
                start = offset;
                end = offset < fileLength ? offset + 1 : offset;
            }
            HighlightInfo.Builder builder = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(element, start, end);
            if (errorDescription != null) {
                builder.descriptionAndTooltip(errorDescription);
            }
            builder.endOfLine();
            info = builder.create();
        }
        return info;
    }
}

