/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.DfaMemoryStateImpl;
import com.intellij.codeInspection.dataFlow.DfaVariableState;
import com.intellij.codeInspection.dataFlow.EqClass;
import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaPsiType;
import com.intellij.codeInspection.dataFlow.value.DfaRelationValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.UnorderedPair;
import com.intellij.psi.JavaTokenType;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class StateMerger {
    private final Map<DfaMemoryStateImpl, Set<Fact>> myFacts = ContainerUtil.newIdentityHashMap();
    private final Map<DfaMemoryState, Map<DfaVariableValue, DfaMemoryStateImpl>> myCopyCache = ContainerUtil.newIdentityHashMap();

    StateMerger() {
    }

    @Nullable
    List<DfaMemoryStateImpl> mergeByFacts(@NotNull List<DfaMemoryStateImpl> states) {
        if (states == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "states", "com/intellij/codeInspection/dataFlow/StateMerger", "mergeByFacts"));
        }
        MultiMap<Fact, DfaMemoryStateImpl> statesByFact = MultiMap.createLinked();
        for (DfaMemoryStateImpl state : states) {
            ProgressManager.checkCanceled();
            for (Fact fact : this.getFacts(state)) {
                statesByFact.putValue(fact, state);
            }
        }
        for (Fact fact : statesByFact.keySet()) {
            Collection<DfaMemoryStateImpl> statesWithNegations;
            if (statesByFact.get(fact).size() == states.size() || fact.myPositive || (statesWithNegations = statesByFact.get(fact.getPositiveCounterpart())).isEmpty()) continue;
            ProgressManager.checkCanceled();
            MultiMap<Set<Fact>, DfaMemoryStateImpl> statesByUnrelatedFacts1 = this.mapByUnrelatedFacts(fact, statesByFact.get(fact));
            MultiMap<Set<Fact>, DfaMemoryStateImpl> statesByUnrelatedFacts2 = this.mapByUnrelatedFacts(fact, statesWithNegations);
            Replacements replacements = new Replacements(states);
            for (Set<Fact> key : statesByUnrelatedFacts1.keySet()) {
                Collection<DfaMemoryStateImpl> group1 = statesByUnrelatedFacts1.get(key);
                Collection<DfaMemoryStateImpl> group2 = statesByUnrelatedFacts2.get(key);
                if (group1.isEmpty() || group2.isEmpty()) continue;
                ArrayList<DfaMemoryStateImpl> group = ContainerUtil.newArrayList(ContainerUtil.concat(group1, group2));
                Set<DfaVariableValue> unknowns = StateMerger.getAllUnknownVariables(group);
                replacements.stripAndMerge(group, original -> {
                    DfaMemoryStateImpl copy = StateMerger.withUnknownVariables(original, unknowns);
                    fact.removeFromState(copy);
                    if (fact.myType == FactType.equality) {
                        this.restoreOtherInequalities(fact, group, copy);
                    }
                    return copy;
                });
            }
            if (!replacements.hasMerges()) continue;
            return replacements.getMergeResult();
        }
        return null;
    }

    @NotNull
    private MultiMap<Set<Fact>, DfaMemoryStateImpl> mapByUnrelatedFacts(@NotNull Fact fact, @NotNull Collection<DfaMemoryStateImpl> states1) {
        if (fact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fact", "com/intellij/codeInspection/dataFlow/StateMerger", "mapByUnrelatedFacts"));
        }
        if (states1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "states1", "com/intellij/codeInspection/dataFlow/StateMerger", "mapByUnrelatedFacts"));
        }
        MultiMap<Set<Fact>, DfaMemoryStateImpl> statesByUnrelatedFacts1 = MultiMap.createLinked();
        for (DfaMemoryStateImpl state : states1) {
            statesByUnrelatedFacts1.putValue(this.getUnrelatedFacts(fact, state), state);
        }
        MultiMap<Set<Fact>, DfaMemoryStateImpl> multiMap = statesByUnrelatedFacts1;
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/StateMerger", "mapByUnrelatedFacts"));
        }
        return multiMap;
    }

    @NotNull
    private LinkedHashSet<Fact> getUnrelatedFacts(final @NotNull Fact fact, @NotNull DfaMemoryStateImpl state) {
        if (fact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fact", "com/intellij/codeInspection/dataFlow/StateMerger", "getUnrelatedFacts"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/codeInspection/dataFlow/StateMerger", "getUnrelatedFacts"));
        }
        LinkedHashSet<Fact> linkedHashSet = new LinkedHashSet<Fact>(ContainerUtil.filter(this.getFacts(state), new Condition<Fact>(){

            @Override
            public boolean value(Fact another) {
                return !fact.invalidatesFact(another);
            }
        }));
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/StateMerger", "getUnrelatedFacts"));
        }
        return linkedHashSet;
    }

    private void restoreOtherInequalities(@NotNull Fact removedFact, @NotNull Collection<DfaMemoryStateImpl> mergedGroup, @NotNull DfaMemoryStateImpl state) {
        if (removedFact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "removedFact", "com/intellij/codeInspection/dataFlow/StateMerger", "restoreOtherInequalities"));
        }
        if (mergedGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergedGroup", "com/intellij/codeInspection/dataFlow/StateMerger", "restoreOtherInequalities"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/codeInspection/dataFlow/StateMerger", "restoreOtherInequalities"));
        }
        Set<DfaConstValue> inequalitiesToRestore = null;
        for (DfaMemoryStateImpl member : mergedGroup) {
            Set<Fact> memberFacts = this.getFacts(member);
            if (!memberFacts.contains(removedFact)) continue;
            Set<DfaConstValue> otherInequalities = StateMerger.getOtherInequalities(removedFact, memberFacts, member);
            if (inequalitiesToRestore == null) {
                inequalitiesToRestore = otherInequalities;
                continue;
            }
            inequalitiesToRestore.retainAll(otherInequalities);
        }
        if (inequalitiesToRestore != null) {
            DfaRelationValue.Factory relationFactory = state.getFactory().getRelationFactory();
            for (DfaConstValue toRestore : inequalitiesToRestore) {
                state.applyCondition(relationFactory.createRelation(removedFact.myVar, toRestore, JavaTokenType.EQEQ, true));
            }
        }
    }

    @NotNull
    private static Set<DfaConstValue> getOtherInequalities(@NotNull Fact removedFact, @NotNull Set<Fact> memberFacts, @NotNull DfaMemoryStateImpl state) {
        if (removedFact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "removedFact", "com/intellij/codeInspection/dataFlow/StateMerger", "getOtherInequalities"));
        }
        if (memberFacts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberFacts", "com/intellij/codeInspection/dataFlow/StateMerger", "getOtherInequalities"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/codeInspection/dataFlow/StateMerger", "getOtherInequalities"));
        }
        LinkedHashSet<DfaConstValue> otherInequalities = ContainerUtil.newLinkedHashSet();
        HashSet<DfaValue> eqValues = ContainerUtil.newHashSet(state.getEquivalentValues((DfaValue)removedFact.myArg));
        for (Fact candidate : memberFacts) {
            if (candidate.myType != FactType.equality || candidate.myPositive || candidate.myVar != removedFact.myVar || eqValues.contains((DfaValue)candidate.myArg) || !(candidate.myArg instanceof DfaConstValue)) continue;
            otherInequalities.add((DfaConstValue)candidate.myArg);
        }
        LinkedHashSet<DfaConstValue> linkedHashSet = otherInequalities;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/StateMerger", "getOtherInequalities"));
        }
        return linkedHashSet;
    }

    @NotNull
    private static Set<DfaVariableValue> getAllUnknownVariables(@NotNull Collection<DfaMemoryStateImpl> complementary) {
        if (complementary == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "complementary", "com/intellij/codeInspection/dataFlow/StateMerger", "getAllUnknownVariables"));
        }
        LinkedHashSet<DfaVariableValue> toFlush = ContainerUtil.newLinkedHashSet();
        for (DfaMemoryStateImpl removedState : complementary) {
            toFlush.addAll(removedState.getUnknownVariables());
        }
        LinkedHashSet<DfaVariableValue> linkedHashSet = toFlush;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/StateMerger", "getAllUnknownVariables"));
        }
        return linkedHashSet;
    }

    @NotNull
    private static DfaMemoryStateImpl withUnknownVariables(@NotNull DfaMemoryStateImpl original, @NotNull Set<DfaVariableValue> toFlush) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/intellij/codeInspection/dataFlow/StateMerger", "withUnknownVariables"));
        }
        if (toFlush == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toFlush", "com/intellij/codeInspection/dataFlow/StateMerger", "withUnknownVariables"));
        }
        DfaMemoryStateImpl copy = original.createCopy();
        for (DfaVariableValue value : toFlush) {
            copy.doFlush(value, true);
        }
        DfaMemoryStateImpl dfaMemoryStateImpl = copy;
        if (dfaMemoryStateImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/StateMerger", "withUnknownVariables"));
        }
        return dfaMemoryStateImpl;
    }

    @Nullable
    List<DfaMemoryStateImpl> mergeByUnknowns(@NotNull List<DfaMemoryStateImpl> states) {
        if (states == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "states", "com/intellij/codeInspection/dataFlow/StateMerger", "mergeByUnknowns"));
        }
        MultiMap<Integer, DfaMemoryStateImpl> byHash = new MultiMap<Integer, DfaMemoryStateImpl>();
        for (DfaMemoryStateImpl state : states) {
            ProgressManager.checkCanceled();
            byHash.putValue(state.getPartialHashCode(false, true), state);
        }
        Replacements replacements = new Replacements(states);
        block1: for (Integer key : byHash.keySet()) {
            Collection similarStates = byHash.get(key);
            if (similarStates.size() < 2) continue;
            for (final DfaMemoryStateImpl state1 : similarStates) {
                ProgressManager.checkCanceled();
                List<DfaMemoryStateImpl> complementary = ContainerUtil.filter(similarStates, new Condition<DfaMemoryStateImpl>(){

                    @Override
                    public boolean value(DfaMemoryStateImpl state2) {
                        return state1.equalsByRelations(state2) && state1.equalsByVariableStates(state2);
                    }
                });
                if (!StateMerger.mergeUnknowns(replacements, complementary)) continue;
                continue block1;
            }
        }
        return replacements.getMergeResult();
    }

    @Nullable
    List<DfaMemoryStateImpl> mergeByNullability(List<DfaMemoryStateImpl> states) {
        MultiMap<Integer, DfaMemoryStateImpl> byHash = new MultiMap<Integer, DfaMemoryStateImpl>();
        for (DfaMemoryStateImpl state : states) {
            ProgressManager.checkCanceled();
            byHash.putValue(state.getPartialHashCode(false, false), state);
        }
        Replacements replacements = new Replacements(states);
        block1: for (Integer key : byHash.keySet()) {
            Collection similarStates = byHash.get(key);
            if (similarStates.size() < 2) continue;
            for (final DfaMemoryStateImpl state1 : similarStates) {
                ProgressManager.checkCanceled();
                for (final DfaVariableValue var : state1.getChangedVariables()) {
                    List<DfaMemoryStateImpl> complementary;
                    if (state1.getVariableState(var).getNullability() != Nullness.NULLABLE || !StateMerger.mergeUnknowns(replacements, complementary = ContainerUtil.filter(similarStates, new Condition<DfaMemoryStateImpl>(){

                        @Override
                        public boolean value(DfaMemoryStateImpl state2) {
                            return state1.equalsByRelations(state2) && StateMerger.this.areEquivalentModuloVar(state1, state2, var) && StateMerger.areVarStatesEqualModuloNullability(state1, state2, var);
                        }
                    }))) continue;
                    continue block1;
                }
            }
        }
        return replacements.getMergeResult();
    }

    private static boolean mergeUnknowns(@NotNull Replacements replacements, @NotNull List<DfaMemoryStateImpl> complementary) {
        if (replacements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "replacements", "com/intellij/codeInspection/dataFlow/StateMerger", "mergeUnknowns"));
        }
        if (complementary == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "complementary", "com/intellij/codeInspection/dataFlow/StateMerger", "mergeUnknowns"));
        }
        if (complementary.size() < 2) {
            return false;
        }
        Set<DfaVariableValue> toFlush = StateMerger.getAllUnknownVariables(complementary);
        if (toFlush.isEmpty()) {
            return false;
        }
        return replacements.stripAndMerge(complementary, original -> StateMerger.withUnknownVariables(original, toFlush));
    }

    private boolean areEquivalentModuloVar(@NotNull DfaMemoryStateImpl state1, @NotNull DfaMemoryStateImpl state2, @NotNull DfaVariableValue var) {
        if (state1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state1", "com/intellij/codeInspection/dataFlow/StateMerger", "areEquivalentModuloVar"));
        }
        if (state2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state2", "com/intellij/codeInspection/dataFlow/StateMerger", "areEquivalentModuloVar"));
        }
        if (var == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "var", "com/intellij/codeInspection/dataFlow/StateMerger", "areEquivalentModuloVar"));
        }
        DfaMemoryStateImpl copy1 = this.copyWithoutVar(state1, var);
        DfaMemoryStateImpl copy2 = this.copyWithoutVar(state2, var);
        return copy2.equalsByRelations(copy1) && copy2.equalsByVariableStates(copy1);
    }

    @NotNull
    private DfaMemoryStateImpl copyWithoutVar(@NotNull DfaMemoryStateImpl state, @NotNull DfaVariableValue var) {
        DfaMemoryStateImpl copy;
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/codeInspection/dataFlow/StateMerger", "copyWithoutVar"));
        }
        if (var == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "var", "com/intellij/codeInspection/dataFlow/StateMerger", "copyWithoutVar"));
        }
        Map<DfaVariableValue, DfaMemoryStateImpl> map = this.myCopyCache.get(state);
        if (map == null) {
            map = ContainerUtil.newIdentityHashMap();
            this.myCopyCache.put(state, map);
        }
        if ((copy = map.get(var)) == null) {
            copy = state.createCopy();
            copy.flushVariable(var);
            map.put(var, copy);
        }
        DfaMemoryStateImpl dfaMemoryStateImpl = copy;
        if (dfaMemoryStateImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/StateMerger", "copyWithoutVar"));
        }
        return dfaMemoryStateImpl;
    }

    private static boolean areVarStatesEqualModuloNullability(@NotNull DfaMemoryStateImpl state1, @NotNull DfaMemoryStateImpl state2, @NotNull DfaVariableValue var) {
        if (state1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state1", "com/intellij/codeInspection/dataFlow/StateMerger", "areVarStatesEqualModuloNullability"));
        }
        if (state2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state2", "com/intellij/codeInspection/dataFlow/StateMerger", "areVarStatesEqualModuloNullability"));
        }
        if (var == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "var", "com/intellij/codeInspection/dataFlow/StateMerger", "areVarStatesEqualModuloNullability"));
        }
        return state1.getVariableState(var).withNullability(Nullness.UNKNOWN).equals(state2.getVariableState(var).withNullability(Nullness.UNKNOWN));
    }

    @NotNull
    private Set<Fact> getFacts(@NotNull DfaMemoryStateImpl state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/codeInspection/dataFlow/StateMerger", "getFacts"));
        }
        Set<Fact> result = this.myFacts.get(state);
        if (result != null) {
            Set<Fact> set = result;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/StateMerger", "getFacts"));
            }
            return set;
        }
        result = ContainerUtil.newLinkedHashSet();
        for (EqClass eqClass : state.getNonTrivialEqClasses()) {
            DfaValue constant = eqClass.findConstant(true);
            List<DfaVariableValue> vars = eqClass.getVariables(false);
            for (DfaVariableValue var : vars) {
                if (constant != null) {
                    result.add(Fact.createEqualityFact(var, constant, true));
                }
                for (DfaVariableValue eqVar : vars) {
                    if (var == eqVar) continue;
                    result.add(Fact.createEqualityFact(var, eqVar, true));
                }
            }
        }
        for (UnorderedPair unorderedPair : state.getDistinctClassPairs()) {
            List<DfaVariableValue> vars1 = ((EqClass)unorderedPair.first).getVariables(false);
            List<DfaVariableValue> vars2 = ((EqClass)unorderedPair.second).getVariables(false);
            LinkedHashSet<DfaVariableValue> firstSet = new LinkedHashSet<DfaVariableValue>(vars1);
            ContainerUtil.addIfNotNull(firstSet, ((EqClass)unorderedPair.first).findConstant(true));
            LinkedHashSet<DfaVariableValue> secondSet = new LinkedHashSet<DfaVariableValue>(vars2);
            ContainerUtil.addIfNotNull(secondSet, ((EqClass)unorderedPair.second).findConstant(true));
            for (DfaVariableValue var : vars1) {
                for (DfaValue dfaValue : secondSet) {
                    result.add(new Fact(FactType.equality, var, false, dfaValue));
                }
            }
            for (DfaVariableValue var : vars2) {
                for (DfaValue dfaValue : firstSet) {
                    result.add(new Fact(FactType.equality, var, false, dfaValue));
                }
            }
        }
        Map<DfaVariableValue, DfaVariableState> states = state.getVariableStates();
        for (DfaVariableValue var : states.keySet()) {
            DfaVariableState variableState = states.get(var);
            for (DfaPsiType type : variableState.getInstanceofValues()) {
                result.add(new Fact(FactType.instanceOf, var, true, type));
            }
            for (DfaPsiType type : variableState.getNotInstanceofValues()) {
                result.add(new Fact(FactType.instanceOf, var, false, type));
            }
        }
        this.myFacts.put(state, result);
        Set<Fact> set = result;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/StateMerger", "getFacts"));
        }
        return set;
    }

    private static class Replacements {
        @NotNull
        private final List<DfaMemoryStateImpl> myAllStates;
        private final Set<DfaMemoryStateImpl> myRemovedStates;
        private final List<DfaMemoryStateImpl> myMerged;

        private Replacements(@NotNull List<DfaMemoryStateImpl> allStates) {
            if (allStates == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allStates", "com/intellij/codeInspection/dataFlow/StateMerger$Replacements", "<init>"));
            }
            this.myRemovedStates = ContainerUtil.newIdentityTroveSet();
            this.myMerged = ContainerUtil.newArrayList();
            this.myAllStates = allStates;
        }

        private boolean hasMerges() {
            return !this.myMerged.isEmpty();
        }

        @Nullable
        private List<DfaMemoryStateImpl> getMergeResult() {
            if (this.hasMerges()) {
                ArrayList<DfaMemoryStateImpl> result = ContainerUtil.newArrayList(this.myMerged);
                for (DfaMemoryStateImpl state : this.myAllStates) {
                    if (this.myRemovedStates.contains(state)) continue;
                    result.add(state);
                }
                return result;
            }
            return null;
        }

        private boolean stripAndMerge(@NotNull Collection<DfaMemoryStateImpl> group, @NotNull Function<DfaMemoryStateImpl, DfaMemoryStateImpl> stripper) {
            if (group == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/codeInspection/dataFlow/StateMerger$Replacements", "stripAndMerge"));
            }
            if (stripper == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stripper", "com/intellij/codeInspection/dataFlow/StateMerger$Replacements", "stripAndMerge"));
            }
            if (group.size() <= 1) {
                return false;
            }
            MultiMap<DfaMemoryStateImpl, DfaMemoryStateImpl> strippedToOriginals = MultiMap.create();
            for (DfaMemoryStateImpl original : group) {
                strippedToOriginals.putValue(stripper.fun(original), original);
            }
            boolean hasMerges = false;
            for (Map.Entry entry : strippedToOriginals.entrySet()) {
                Collection merged = entry.getValue();
                if (merged.size() <= 1) continue;
                this.myRemovedStates.addAll(merged);
                this.myMerged.add((DfaMemoryStateImpl)entry.getKey());
                hasMerges = true;
            }
            return hasMerges;
        }
    }

    private static class Fact {
        @NotNull
        final FactType myType;
        @NotNull
        private final DfaVariableValue myVar;
        private final boolean myPositive;
        @NotNull
        private final Object myArg;

        private Fact(@NotNull FactType type, @NotNull DfaVariableValue var, boolean positive, @NotNull Object arg) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/codeInspection/dataFlow/StateMerger$Fact", "<init>"));
            }
            if (var == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "var", "com/intellij/codeInspection/dataFlow/StateMerger$Fact", "<init>"));
            }
            if (arg == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arg", "com/intellij/codeInspection/dataFlow/StateMerger$Fact", "<init>"));
            }
            this.myType = type;
            this.myVar = var;
            this.myPositive = positive;
            this.myArg = arg;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Fact)) {
                return false;
            }
            Fact fact = (Fact)o;
            if (this.myPositive != fact.myPositive) {
                return false;
            }
            if (!this.myArg.equals(fact.myArg)) {
                return false;
            }
            if (this.myType != fact.myType) {
                return false;
            }
            return this.myVar.equals(fact.myVar);
        }

        public int hashCode() {
            int result = this.myType.hashCode();
            result = 31 * result + this.myVar.hashCode();
            result = 31 * result + (this.myPositive ? 1 : 0);
            result = 31 * result + this.myArg.hashCode();
            return result;
        }

        public String toString() {
            return this.myVar + " " + (this.myPositive ? "" : "!") + (Object)((Object)this.myType) + " " + this.myArg;
        }

        @NotNull
        private static Fact createEqualityFact(@NotNull DfaVariableValue var, @NotNull DfaValue val, boolean equal) {
            if (var == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "var", "com/intellij/codeInspection/dataFlow/StateMerger$Fact", "createEqualityFact"));
            }
            if (val == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "val", "com/intellij/codeInspection/dataFlow/StateMerger$Fact", "createEqualityFact"));
            }
            if (val instanceof DfaVariableValue && val.getID() < var.getID()) {
                Fact fact = new Fact(FactType.equality, (DfaVariableValue)val, equal, var);
                if (fact == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/StateMerger$Fact", "createEqualityFact"));
                }
                return fact;
            }
            Fact fact = new Fact(FactType.equality, var, equal, val);
            if (fact == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/StateMerger$Fact", "createEqualityFact"));
            }
            return fact;
        }

        @NotNull
        private Fact getPositiveCounterpart() {
            Fact fact = new Fact(this.myType, this.myVar, true, this.myArg);
            if (fact == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/StateMerger$Fact", "getPositiveCounterpart"));
            }
            return fact;
        }

        boolean invalidatesFact(@NotNull Fact another) {
            if (another == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "another", "com/intellij/codeInspection/dataFlow/StateMerger$Fact", "invalidatesFact"));
            }
            if (another.myType != this.myType) {
                return false;
            }
            if (this.myType == FactType.equality) {
                return Fact.aboutSame(this.myVar, another.myVar) || Fact.aboutSame(this.myVar, another.myArg);
            }
            return Fact.aboutSame(this.myVar, another.myVar) && Fact.aboutSame(this.myArg, another.myArg);
        }

        private static boolean aboutSame(Object v1, Object v2) {
            return Fact.normalize(v1) == Fact.normalize(v2);
        }

        private static Object normalize(Object value) {
            if (value instanceof DfaVariableValue && ((DfaVariableValue)value).isNegated()) {
                return ((DfaVariableValue)value).createNegated();
            }
            return value;
        }

        void removeFromState(@NotNull DfaMemoryStateImpl state) {
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/codeInspection/dataFlow/StateMerger$Fact", "removeFromState"));
            }
            DfaVariableState varState = state.getVariableState(this.myVar);
            if (this.myType == FactType.equality) {
                state.flushVariable(this.myVar);
                state.setVariableState(this.myVar, varState);
            } else {
                state.setVariableState(this.myVar, varState.withoutType((DfaPsiType)this.myArg));
            }
        }
    }

    private static enum FactType {
        equality,
        instanceOf;

    }
}

