/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator.index;

import com.intellij.dupLocator.DuplicatesProfile;
import com.intellij.dupLocator.DuplocateVisitor;
import com.intellij.dupLocator.DuplocatorState;
import com.intellij.dupLocator.LightDuplicateProfile;
import com.intellij.dupLocator.index.TracingData;
import com.intellij.dupLocator.treeHash.FragmentsCollector;
import com.intellij.dupLocator.util.PsiFragment;
import com.intellij.lang.Language;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SystemProperties;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileContentImpl;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.PsiDependentIndex;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.KeyDescriptor;
import gnu.trove.THashMap;
import gnu.trove.TIntArrayList;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DuplicatesIndex
extends FileBasedIndexExtension<Integer, TIntArrayList>
implements PsiDependentIndex {
    static boolean ourEnabled = SystemProperties.getBooleanProperty("idea.enable.duplicates.online.calculation", true);
    static final boolean ourEnabledLightProfiles = true;
    private static boolean ourEnabledOldProfiles = false;
    @NonNls
    public static final ID<Integer, TIntArrayList> NAME = ID.create("DuplicatesIndex");
    private static final int myBaseVersion = 25;
    private final FileBasedIndex.InputFilter myInputFilter = new FileBasedIndex.InputFilter(){

        @Override
        public boolean acceptInput(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/dupLocator/index/DuplicatesIndex$1", "acceptInput"));
            }
            return ourEnabled && DuplicatesIndex.findDuplicatesProfile(file.getFileType()) != null && file.isInLocalFileSystem();
        }
    };
    private final DataExternalizer<TIntArrayList> myValueExternalizer = new DataExternalizer<TIntArrayList>(){

        @Override
        public void save(@NotNull DataOutput out, TIntArrayList list) throws IOException {
            if (out == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/dupLocator/index/DuplicatesIndex$2", "save"));
            }
            if (list.size() == 2) {
                DataInputOutputUtil.writeINT(out, list.getQuick(0));
                DataInputOutputUtil.writeINT(out, list.getQuick(1));
            } else {
                DataInputOutputUtil.writeINT(out, -list.size());
                int prev = 0;
                int len = list.size();
                for (int i = 0; i < len; i += 2) {
                    int value = list.getQuick(i);
                    DataInputOutputUtil.writeINT(out, value - prev);
                    prev = value;
                    DataInputOutputUtil.writeINT(out, list.getQuick(i + 1));
                }
            }
        }

        @Override
        public TIntArrayList read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/dupLocator/index/DuplicatesIndex$2", "read"));
            }
            int capacityOrValue = DataInputOutputUtil.readINT(in);
            if (capacityOrValue >= 0) {
                TIntArrayList list = new TIntArrayList(2);
                list.add(capacityOrValue);
                list.add(DataInputOutputUtil.readINT(in));
                return list;
            }
            TIntArrayList list = new TIntArrayList(capacityOrValue);
            int prev = 0;
            for (capacityOrValue = -capacityOrValue; capacityOrValue > 0; capacityOrValue -= 2) {
                int value = DataInputOutputUtil.readINT(in) + prev;
                list.add(value);
                prev = value;
                list.add(DataInputOutputUtil.readINT(in));
            }
            return list;
        }
    };
    private final DataIndexer<Integer, TIntArrayList, FileContent> myIndexer = new DataIndexer<Integer, TIntArrayList, FileContent>(){

        @Override
        @NotNull
        public Map<Integer, TIntArrayList> map(@NotNull FileContent inputData) {
            FileContentImpl fileContent;
            DuplicatesProfile profile;
            FileType type;
            block9: {
                THashMap tHashMap;
                if (inputData == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputData", "com/intellij/dupLocator/index/DuplicatesIndex$3", "map"));
                }
                type = inputData.getFileType();
                profile = DuplicatesIndex.findDuplicatesProfile(type);
                if (profile == null || !profile.acceptsContentForIndexing(inputData)) {
                    Map<Integer, TIntArrayList> map = Collections.emptyMap();
                    if (map == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/index/DuplicatesIndex$3", "map"));
                    }
                    return map;
                }
                try {
                    fileContent = (FileContentImpl)inputData;
                    if (!(profile instanceof LightDuplicateProfile)) break block9;
                    final THashMap result = new THashMap();
                    LighterAST ast = fileContent.getLighterASTForPsiDependentIndex();
                    ((LightDuplicateProfile)((Object)profile)).process(ast, new LightDuplicateProfile.Callback(){

                        @Override
                        public void process(int hash, int hash2, @NotNull LighterAST ast, LighterASTNode ... nodes) {
                            if (ast == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ast", "com/intellij/dupLocator/index/DuplicatesIndex$3$1", "process"));
                            }
                            if (nodes == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodes", "com/intellij/dupLocator/index/DuplicatesIndex$3$1", "process"));
                            }
                            TIntArrayList list = (TIntArrayList)result.get((Object)hash);
                            if (list == null) {
                                list = new TIntArrayList(2);
                                result.put((Object)hash, (Object)list);
                            }
                            list.add(nodes[0].getStartOffset());
                            list.add(hash2);
                        }
                    });
                    tHashMap = result;
                }
                catch (StackOverflowError ae) {
                    Map<Integer, TIntArrayList> map = Collections.emptyMap();
                    if (map == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/index/DuplicatesIndex$3", "map"));
                    }
                    return map;
                }
                if (tHashMap == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/index/DuplicatesIndex$3", "map"));
                }
                return tHashMap;
            }
            MyFragmentsCollector collector = new MyFragmentsCollector(profile, ((LanguageFileType)type).getLanguage());
            DuplocateVisitor visitor = profile.createVisitor(collector, true);
            visitor.visitNode(fileContent.getPsiFileForPsiDependentIndex());
            THashMap<Integer, TIntArrayList> tHashMap = collector.getMap();
            if (tHashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/index/DuplicatesIndex$3", "map"));
            }
            return tHashMap;
        }
    };
    private static final TracingData myTracingData = null;

    @Nullable
    public static DuplicatesProfile findDuplicatesProfile(FileType fileType) {
        if (!(fileType instanceof LanguageFileType)) {
            return null;
        }
        Language language = ((LanguageFileType)fileType).getLanguage();
        DuplicatesProfile profile = DuplicatesProfile.findProfileForLanguage(language);
        return profile != null && (ourEnabledOldProfiles && profile.supportDuplicatesIndex() || profile instanceof LightDuplicateProfile) ? profile : null;
    }

    @Override
    public int getVersion() {
        return 25 + (ourEnabled ? 255 : 0) + 127 + (ourEnabledOldProfiles ? 33 : 0);
    }

    @Override
    public boolean dependsOnFileContent() {
        return true;
    }

    @Override
    @NotNull
    public ID<Integer, TIntArrayList> getName() {
        ID<Integer, TIntArrayList> iD = NAME;
        if (iD == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/index/DuplicatesIndex", "getName"));
        }
        return iD;
    }

    @Override
    @NotNull
    public DataIndexer<Integer, TIntArrayList, FileContent> getIndexer() {
        DataIndexer<Integer, TIntArrayList, FileContent> dataIndexer = this.myIndexer;
        if (dataIndexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/index/DuplicatesIndex", "getIndexer"));
        }
        return dataIndexer;
    }

    @Override
    @NotNull
    public DataExternalizer<TIntArrayList> getValueExternalizer() {
        DataExternalizer<TIntArrayList> dataExternalizer = this.myValueExternalizer;
        if (dataExternalizer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/index/DuplicatesIndex", "getValueExternalizer"));
        }
        return dataExternalizer;
    }

    @Override
    @NotNull
    public KeyDescriptor<Integer> getKeyDescriptor() {
        EnumeratorIntegerDescriptor enumeratorIntegerDescriptor = EnumeratorIntegerDescriptor.INSTANCE;
        if (enumeratorIntegerDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/index/DuplicatesIndex", "getKeyDescriptor"));
        }
        return enumeratorIntegerDescriptor;
    }

    @Override
    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        FileBasedIndex.InputFilter inputFilter = this.myInputFilter;
        if (inputFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/index/DuplicatesIndex", "getInputFilter"));
        }
        return inputFilter;
    }

    static boolean isIndexedFragment(@Nullable PsiFragment frag, int cost, DuplicatesProfile profile, DuplocatorState duplocatorState) {
        if (frag == null) {
            return false;
        }
        return profile.shouldPutInIndex(frag, cost, duplocatorState);
    }

    public static boolean setEnabled(boolean value) {
        boolean old = ourEnabled;
        ourEnabled = value;
        return old;
    }

    public static boolean setEnabledOldProfiles(boolean value) {
        boolean old = ourEnabledOldProfiles;
        ourEnabledOldProfiles = value;
        return old;
    }

    @Override
    public boolean hasSnapshotMapping() {
        return true;
    }

    private static class MyFragmentsCollector
    implements FragmentsCollector {
        private final THashMap<Integer, TIntArrayList> myMap = new THashMap();
        private final DuplicatesProfile myProfile;
        private final DuplocatorState myDuplocatorState;

        public MyFragmentsCollector(DuplicatesProfile profile, Language language) {
            this.myProfile = profile;
            this.myDuplocatorState = profile.getDuplocatorState(language);
        }

        @Override
        public void add(int hash, int cost, @Nullable PsiFragment frag) {
            TIntArrayList list;
            if (!DuplicatesIndex.isIndexedFragment(frag, cost, this.myProfile, this.myDuplocatorState)) {
                return;
            }
            if (myTracingData != null) {
                myTracingData.record(hash, cost, frag);
            }
            if ((list = (TIntArrayList)this.myMap.get((Object)hash)) == null) {
                list = new TIntArrayList();
                this.myMap.put((Object)hash, (Object)list);
            }
            list.add(frag.getStartOffset());
            list.add(0);
        }

        public THashMap<Integer, TIntArrayList> getMap() {
            return this.myMap;
        }
    }
}

