/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.concurrency.JobLauncher;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiField;
import com.intellij.psi.impl.java.stubs.index.JavaAnonymousClassBaseRefOccurenceIndex;
import com.intellij.psi.impl.java.stubs.index.JavaSuperClassNameOccurenceIndex;
import com.intellij.psi.impl.search.HighlightingCaches;
import com.intellij.psi.impl.search.JavaClassInheritorsSearcher;
import com.intellij.psi.impl.search.MethodUsagesSearcher;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AllClassesSearch;
import com.intellij.psi.search.searches.DirectClassInheritorsSearch;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;

public class JavaDirectInheritorsSearcher
implements QueryExecutor<PsiClass, DirectClassInheritorsSearch.SearchParameters> {
    @Override
    public boolean execute(@NotNull DirectClassInheritorsSearch.SearchParameters parameters, @NotNull Processor<PsiClass> consumer) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "execute"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "execute"));
        }
        PsiClass baseClass = parameters.getClassToProcess();
        assert (parameters.isCheckInheritance());
        SearchScope useScope = ApplicationManager.getApplication().runReadAction(baseClass::getUseScope);
        Project project = PsiUtilCore.getProjectInReadAction(baseClass);
        if (JavaClassInheritorsSearcher.isJavaLangObject(baseClass)) {
            return AllClassesSearch.search(useScope, project).forEach(psiClass -> {
                if (consumer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "lambda$execute$0"));
                }
                ProgressManager.checkCanceled();
                if (psiClass.isInterface()) {
                    return consumer.process((PsiClass)psiClass);
                }
                PsiClass superClass = psiClass.getSuperClass();
                return superClass == null || !JavaClassInheritorsSearcher.isJavaLangObject(superClass) || consumer.process((PsiClass)psiClass);
            });
        }
        SearchScope scope = parameters.getScope();
        PsiClass[] cache = JavaDirectInheritorsSearcher.getOrCalculateDirectSubClasses(project, baseClass);
        if (cache.length == 0) {
            return true;
        }
        VirtualFile baseClassJarFile = null;
        int groupStart = 0;
        boolean sameJarClassFound = false;
        String currentFQN = null;
        for (int i = 0; i < cache.length + 1; ++i) {
            String fqn;
            PsiClass subClass;
            ProgressManager.checkCanceled();
            PsiClass psiClass2 = subClass = i == cache.length ? null : cache[i];
            if (subClass instanceof PsiAnonymousClass && !parameters.includeAnonymous()) {
                return true;
            }
            String string = fqn = i == cache.length ? null : ApplicationManager.getApplication().runReadAction(subClass::getQualifiedName);
            if (i != cache.length && !JavaDirectInheritorsSearcher.isInScope(scope, subClass)) continue;
            if (currentFQN != null && Comparing.equal(fqn, currentFQN)) {
                boolean fromSameJar;
                VirtualFile currentJarFile = JavaDirectInheritorsSearcher.getJarFile(subClass);
                if (baseClassJarFile == null) {
                    baseClassJarFile = JavaDirectInheritorsSearcher.getJarFile(baseClass);
                }
                if (!(fromSameJar = Comparing.equal(currentJarFile, baseClassJarFile))) continue;
                if (!consumer.process(subClass)) {
                    return false;
                }
                sameJarClassFound = true;
                continue;
            }
            currentFQN = fqn;
            if (!sameJarClassFound) {
                for (int g = groupStart; g < i; ++g) {
                    ProgressManager.checkCanceled();
                    PsiClass anonSubClass = cache[g];
                    if (consumer.process(anonSubClass)) continue;
                    return false;
                }
            }
            groupStart = i;
            sameJarClassFound = false;
        }
        return true;
    }

    private static boolean isInScope(@NotNull SearchScope scope, @NotNull PsiClass subClass) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "isInScope"));
        }
        if (subClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subClass", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "isInScope"));
        }
        return ApplicationManager.getApplication().runReadAction(() -> {
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "lambda$isInScope$1"));
            }
            if (subClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subClass", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "lambda$isInScope$1"));
            }
            return PsiSearchScopeUtil.isInScope(scope, (PsiElement)subClass);
        });
    }

    @NotNull
    private static PsiClass[] getOrCalculateDirectSubClasses(@NotNull Project project, @NotNull PsiClass baseClass) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "getOrCalculateDirectSubClasses"));
        }
        if (baseClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "getOrCalculateDirectSubClasses"));
        }
        ConcurrentMap<PsiClass, PsiClass[]> map = HighlightingCaches.getInstance((Project)project).DIRECT_SUB_CLASSES;
        PsiClass[] cache = (PsiClass[])map.get(baseClass);
        if (cache != null) {
            if (cache == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "getOrCalculateDirectSubClasses"));
            }
            return cache;
        }
        String baseClassName = ApplicationManager.getApplication().runReadAction(baseClass::getName);
        if (StringUtil.isEmpty(baseClassName)) {
            if (PsiClass.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "getOrCalculateDirectSubClasses"));
            }
            return PsiClass.EMPTY_ARRAY;
        }
        cache = JavaDirectInheritorsSearcher.calculateDirectSubClasses(project, baseClass, baseClassName);
        if (ApplicationManager.getApplication().runReadAction(baseClass::isPhysical).booleanValue()) {
            cache = ConcurrencyUtil.cacheOrGet(map, baseClass, cache);
        }
        if (cache == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "getOrCalculateDirectSubClasses"));
        }
        return cache;
    }

    private static <T> boolean processConcurrentlyIfTooMany(@NotNull Collection<T> collection, @NotNull Processor<? super T> processor) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "processConcurrentlyIfTooMany"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "processConcurrentlyIfTooMany"));
        }
        int size = collection.size();
        if (size == 0) {
            return true;
        }
        if (size > 100) {
            return JobLauncher.getInstance().invokeConcurrentlyUnderProgress(new ArrayList<T>(collection), ProgressIndicatorProvider.getGlobalProgressIndicator(), true, processor);
        }
        return ContainerUtil.process(collection, processor);
    }

    @NotNull
    private static PsiClass[] calculateDirectSubClasses(@NotNull Project project, @NotNull PsiClass baseClass, @NotNull String baseClassName) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "calculateDirectSubClasses"));
        }
        if (baseClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "calculateDirectSubClasses"));
        }
        if (baseClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClassName", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "calculateDirectSubClasses"));
        }
        GlobalSearchScope allScope = GlobalSearchScope.allScope(project);
        Collection candidates = MethodUsagesSearcher.resolveInReadAction(project, () -> {
            if (baseClassName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClassName", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "lambda$calculateDirectSubClasses$2"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "lambda$calculateDirectSubClasses$2"));
            }
            return JavaSuperClassNameOccurenceIndex.getInstance().get(baseClassName, project, allScope);
        });
        HashMap classes = new HashMap();
        JavaDirectInheritorsSearcher.processConcurrentlyIfTooMany(candidates, referenceList -> {
            if (baseClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "lambda$calculateDirectSubClasses$4"));
            }
            ProgressManager.checkCanceled();
            ApplicationManager.getApplication().runReadAction(() -> {
                if (baseClass == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "lambda$null$3"));
                }
                PsiClass candidate = (PsiClass)referenceList.getParent();
                boolean isInheritor = candidate.isInheritor(baseClass, false);
                if (isInheritor) {
                    String fqn = candidate.getQualifiedName();
                    Map map = classes;
                    synchronized (map) {
                        Object value = classes.get(fqn);
                        if (value == null) {
                            classes.put(fqn, candidate);
                        } else if (value instanceof PsiClass) {
                            ArrayList<PsiClass> list = new ArrayList<PsiClass>();
                            list.add((PsiClass)value);
                            list.add(candidate);
                            classes.put(fqn, list);
                        } else {
                            List list = (List)value;
                            list.add(candidate);
                        }
                    }
                }
            });
            return true;
        });
        ArrayList<PsiClass> result = new ArrayList<PsiClass>();
        for (Object value : classes.values()) {
            if (value instanceof PsiClass) {
                result.add((PsiClass)value);
                continue;
            }
            List list = (List)value;
            result.addAll(list);
        }
        Collection anonymousCandidates = MethodUsagesSearcher.resolveInReadAction(project, () -> {
            if (baseClassName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClassName", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "lambda$calculateDirectSubClasses$5"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "lambda$calculateDirectSubClasses$5"));
            }
            return JavaAnonymousClassBaseRefOccurenceIndex.getInstance().get(baseClassName, project, allScope);
        });
        JavaDirectInheritorsSearcher.processConcurrentlyIfTooMany(anonymousCandidates, candidate -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "lambda$calculateDirectSubClasses$7"));
            }
            if (baseClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "lambda$calculateDirectSubClasses$7"));
            }
            boolean isInheritor = MethodUsagesSearcher.resolveInReadAction(project, () -> {
                if (baseClass == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "lambda$null$6"));
                }
                return candidate.isInheritor(baseClass, false);
            });
            if (isInheritor) {
                List list = result;
                synchronized (list) {
                    result.add((PsiClass)candidate);
                }
            }
            return true;
        });
        boolean isEnum = ApplicationManager.getApplication().runReadAction(baseClass::isEnum);
        if (isEnum) {
            PsiField[] fields;
            for (PsiField field : fields = ApplicationManager.getApplication().runReadAction(baseClass::getFields)) {
                ProgressManager.checkCanceled();
                if (!(field instanceof PsiEnumConstant)) continue;
                PsiEnumConstantInitializer initializingClass = ApplicationManager.getApplication().runReadAction(((PsiEnumConstant)field)::getInitializingClass);
                if (initializingClass == null) continue;
                result.add(initializingClass);
            }
        }
        PsiClass[] psiClassArray = result.isEmpty() ? PsiClass.EMPTY_ARRAY : result.toArray(new PsiClass[result.size()]);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "calculateDirectSubClasses"));
        }
        return psiClassArray;
    }

    private static VirtualFile getJarFile(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "getJarFile"));
        }
        return ApplicationManager.getApplication().runReadAction(() -> {
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "lambda$getJarFile$8"));
            }
            return PsiUtil.getJarFile(aClass);
        });
    }
}

