/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.psi.impl.source.SubstrateRef;
import com.intellij.psi.impl.source.tree.AstPath;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.reference.SoftReference;
import com.intellij.util.containers.ContainerUtil;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AstPathPsiMap {
    private final ConcurrentMap<AstPath, MyReference> myMap = ContainerUtil.newConcurrentMap();

    AstPathPsiMap() {
    }

    void invalidatePsi() {
        AstPathPsiMap.processQueue();
        for (MyReference reference : this.myMap.values()) {
            StubBasedPsiElementBase psi = (StubBasedPsiElementBase)SoftReference.dereference(reference);
            if (psi == null) continue;
            psi.setSubstrateRef(SubstrateRef.createInvalidRef(psi));
        }
        this.myMap.clear();
    }

    void switchToStrongRefs() {
        AstPathPsiMap.processQueue();
        for (MyReference reference : this.myMap.values()) {
            StubBasedPsiElementBase psi = (StubBasedPsiElementBase)SoftReference.dereference(reference);
            if (psi == null) continue;
            CompositeElement node = (CompositeElement)psi.getNode();
            node.setPsi(psi);
            psi.setSubstrateRef(SubstrateRef.createAstStrongRef(node));
        }
        this.myMap.clear();
    }

    @Nullable
    StubBasedPsiElementBase<?> getCachedPsi(@NotNull AstPath ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/psi/impl/source/AstPathPsiMap", "getCachedPsi"));
        }
        return (StubBasedPsiElementBase)SoftReference.dereference((Reference)this.myMap.get(ref));
    }

    @NotNull
    StubBasedPsiElementBase<?> cachePsi(@NotNull AstPath key, @NotNull StubBasedPsiElementBase psi) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/psi/impl/source/AstPathPsiMap", "cachePsi"));
        }
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "com/intellij/psi/impl/source/AstPathPsiMap", "cachePsi"));
        }
        AstPathPsiMap.processQueue();
        this.myMap.put(key, new MyReference(psi, key));
        psi.setSubstrateRef(key);
        StubBasedPsiElementBase stubBasedPsiElementBase = psi;
        if (stubBasedPsiElementBase == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/AstPathPsiMap", "cachePsi"));
        }
        return stubBasedPsiElementBase;
    }

    private static void processQueue() {
        MyReference reference;
        while ((reference = (MyReference)MyReference.ourQueue.poll()) != null) {
            AstPath key = reference.pathRef;
            key.getContainingFile().getRefToPsi().myMap.remove(key, reference);
        }
    }

    private static class MyReference
    extends WeakReference<StubBasedPsiElementBase<?>> {
        static final ReferenceQueue<StubBasedPsiElementBase<?>> ourQueue = new ReferenceQueue();
        final AstPath pathRef;

        MyReference(StubBasedPsiElementBase psi, AstPath ref) {
            super(psi, ourQueue);
            this.pathRef = ref;
        }
    }
}

