/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.PsiField;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class VolatileLongOrDoubleFieldInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("volatile.long.or.double.field.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/VolatileLongOrDoubleFieldInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiType type = (PsiType)infos[0];
        String typeString = type.getPresentableText();
        String string = InspectionGadgetsBundle.message("volatile.field.problem.descriptor", typeString);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/VolatileLongOrDoubleFieldInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new VolatileLongOrDoubleFieldVisitor();
    }

    private static class VolatileLongOrDoubleFieldVisitor
    extends BaseInspectionVisitor {
        private VolatileLongOrDoubleFieldVisitor() {
        }

        @Override
        public void visitField(@NotNull PsiField field) {
            if (field == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/siyeh/ig/threading/VolatileLongOrDoubleFieldInspection$VolatileLongOrDoubleFieldVisitor", "visitField"));
            }
            super.visitField(field);
            if (!field.hasModifierProperty("volatile")) {
                return;
            }
            PsiType type = field.getType();
            if (PsiType.LONG.equals(type) || PsiType.DOUBLE.equals(type)) {
                this.registerFieldError(field, type);
            }
        }
    }
}

