/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.CaseInsensitiveValuePatternCondition;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.InitialPatternCondition;
import com.intellij.patterns.ObjectPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.ValuePatternCondition;
import com.intellij.util.ProcessingContext;
import dk.brics.automaton.Automaton;
import dk.brics.automaton.AutomatonProvider;
import dk.brics.automaton.DatatypesAutomatonProvider;
import dk.brics.automaton.RegExp;
import dk.brics.automaton.RunAutomaton;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringPattern
extends ObjectPattern<String, StringPattern> {
    static final StringPattern STRING_PATTERN = new StringPattern();

    private StringPattern() {
        super(new InitialPatternCondition<String>(String.class){

            @Override
            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                return o instanceof String;
            }

            @Override
            public void append(@NotNull @NonNls StringBuilder builder, String indent) {
                if (builder == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/patterns/StringPattern$1", "append"));
                }
                builder.append("string()");
            }
        });
    }

    @NotNull
    public StringPattern startsWith(final @NonNls @NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/patterns/StringPattern", "startsWith"));
        }
        StringPattern stringPattern = (StringPattern)this.with(new PatternCondition<String>("startsWith"){

            @Override
            public boolean accepts(@NotNull String str, ProcessingContext context) {
                if (str == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/patterns/StringPattern$2", "accepts"));
                }
                return StringUtil.startsWith(str, s);
            }
        });
        if (stringPattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/patterns/StringPattern", "startsWith"));
        }
        return stringPattern;
    }

    @NotNull
    public StringPattern endsWith(final @NonNls @NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/patterns/StringPattern", "endsWith"));
        }
        StringPattern stringPattern = (StringPattern)this.with(new PatternCondition<String>("endsWith"){

            @Override
            public boolean accepts(@NotNull String str, ProcessingContext context) {
                if (str == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/patterns/StringPattern$3", "accepts"));
                }
                return StringUtil.endsWith(str, s);
            }
        });
        if (stringPattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/patterns/StringPattern", "endsWith"));
        }
        return stringPattern;
    }

    @NotNull
    public StringPattern contains(final @NonNls @NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/patterns/StringPattern", "contains"));
        }
        StringPattern stringPattern = (StringPattern)this.with(new PatternCondition<String>("contains"){

            @Override
            public boolean accepts(@NotNull String str, ProcessingContext context) {
                if (str == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/patterns/StringPattern$4", "accepts"));
                }
                return StringUtil.contains(str, s);
            }
        });
        if (stringPattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/patterns/StringPattern", "contains"));
        }
        return stringPattern;
    }

    @NotNull
    public StringPattern containsChars(final @NonNls @NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/patterns/StringPattern", "containsChars"));
        }
        StringPattern stringPattern = (StringPattern)this.with(new PatternCondition<String>("containsChars"){

            @Override
            public boolean accepts(@NotNull String str, ProcessingContext context) {
                if (str == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/patterns/StringPattern$5", "accepts"));
                }
                return StringUtil.containsAnyChar(str, s);
            }
        });
        if (stringPattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/patterns/StringPattern", "containsChars"));
        }
        return stringPattern;
    }

    @NotNull
    public StringPattern matches(final @NonNls @NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/patterns/StringPattern", "matches"));
        }
        String escaped = StringUtil.escapeToRegexp(s);
        if (escaped.equals(s)) {
            StringPattern stringPattern = (StringPattern)this.equalTo(s);
            if (stringPattern == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/patterns/StringPattern", "matches"));
            }
            return stringPattern;
        }
        final Pattern pattern = Pattern.compile(s);
        StringPattern stringPattern = (StringPattern)this.with(new ValuePatternCondition<String>("matches"){

            @Override
            public boolean accepts(@NotNull String str, ProcessingContext context) {
                if (str == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/patterns/StringPattern$6", "accepts"));
                }
                return pattern.matcher(StringPattern.newBombedCharSequence(str)).matches();
            }

            @Override
            public Collection<String> getValues() {
                return Collections.singleton(s);
            }
        });
        if (stringPattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/patterns/StringPattern", "matches"));
        }
        return stringPattern;
    }

    @NotNull
    public StringPattern matchesBrics(final @NonNls @NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/patterns/StringPattern", "matchesBrics"));
        }
        String escaped = StringUtil.escapeToRegexp(s);
        if (escaped.equals(s)) {
            StringPattern stringPattern = (StringPattern)this.equalTo(s);
            if (stringPattern == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/patterns/StringPattern", "matchesBrics"));
            }
            return stringPattern;
        }
        StringBuilder sb = new StringBuilder(s.length() * 5);
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == ' ') {
                sb.append("<whitespacechar>");
                continue;
            }
            if (Character.isUpperCase(c)) {
                sb.append('[').append(Character.toUpperCase(c)).append(Character.toLowerCase(c)).append(']');
                continue;
            }
            sb.append(c);
        }
        RegExp regExp = new RegExp(sb.toString());
        Automaton automaton = regExp.toAutomaton((AutomatonProvider)new DatatypesAutomatonProvider());
        final RunAutomaton runAutomaton = new RunAutomaton(automaton, true);
        StringPattern stringPattern = (StringPattern)this.with(new ValuePatternCondition<String>("matchesBrics"){

            @Override
            public boolean accepts(@NotNull String str, ProcessingContext context) {
                if (str == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/patterns/StringPattern$7", "accepts"));
                }
                if (!(str.isEmpty() || str.charAt(0) != '\"' && str.charAt(0) != '\'')) {
                    str = str.substring(1);
                }
                return runAutomaton.run(str);
            }

            @Override
            public Collection<String> getValues() {
                return Collections.singleton(s);
            }
        });
        if (stringPattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/patterns/StringPattern", "matchesBrics"));
        }
        return stringPattern;
    }

    @NotNull
    public StringPattern contains(final @NonNls @NotNull ElementPattern<Character> pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/patterns/StringPattern", "contains"));
        }
        StringPattern stringPattern = (StringPattern)this.with(new PatternCondition<String>("contains"){

            @Override
            public boolean accepts(@NotNull String str, ProcessingContext context) {
                if (str == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/patterns/StringPattern$8", "accepts"));
                }
                for (int i = 0; i < str.length(); ++i) {
                    if (!pattern.accepts(Character.valueOf(str.charAt(i)))) continue;
                    return true;
                }
                return false;
            }
        });
        if (stringPattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/patterns/StringPattern", "contains"));
        }
        return stringPattern;
    }

    public StringPattern longerThan(final int minLength) {
        return (StringPattern)this.with(new PatternCondition<String>("longerThan"){

            @Override
            public boolean accepts(@NotNull String s, ProcessingContext context) {
                if (s == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/patterns/StringPattern$9", "accepts"));
                }
                return s.length() > minLength;
            }
        });
    }

    public StringPattern shorterThan(final int maxLength) {
        return (StringPattern)this.with(new PatternCondition<String>("shorterThan"){

            @Override
            public boolean accepts(@NotNull String s, ProcessingContext context) {
                if (s == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/patterns/StringPattern$10", "accepts"));
                }
                return s.length() < maxLength;
            }
        });
    }

    public StringPattern withLength(final int length) {
        return (StringPattern)this.with(new PatternCondition<String>("withLength"){

            @Override
            public boolean accepts(@NotNull String s, ProcessingContext context) {
                if (s == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/patterns/StringPattern$11", "accepts"));
                }
                return s.length() == length;
            }
        });
    }

    @NotNull
    public StringPattern oneOf(String ... values) {
        StringPattern stringPattern = (StringPattern)super.oneOf(values);
        if (stringPattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/patterns/StringPattern", "oneOf"));
        }
        return stringPattern;
    }

    @NotNull
    public StringPattern oneOfIgnoreCase(String ... values) {
        StringPattern stringPattern = (StringPattern)this.with(new CaseInsensitiveValuePatternCondition("oneOfIgnoreCase", values));
        if (stringPattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/patterns/StringPattern", "oneOfIgnoreCase"));
        }
        return stringPattern;
    }

    @Override
    @NotNull
    public StringPattern oneOf(@NonNls Collection<String> set) {
        StringPattern stringPattern = (StringPattern)super.oneOf(set);
        if (stringPattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/patterns/StringPattern", "oneOf"));
        }
        return stringPattern;
    }

    @NotNull
    public static CharSequence newBombedCharSequence(@NotNull CharSequence sequence) {
        if (sequence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/patterns/StringPattern", "newBombedCharSequence"));
        }
        if (sequence instanceof StringUtil.BombedCharSequence) {
            CharSequence charSequence = sequence;
            if (charSequence == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/patterns/StringPattern", "newBombedCharSequence"));
            }
            return charSequence;
        }
        StringUtil.BombedCharSequence bombedCharSequence = new StringUtil.BombedCharSequence(sequence){

            @Override
            protected void checkCanceled() {
                ProgressManager.checkCanceled();
            }
        };
        if (bombedCharSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/patterns/StringPattern", "newBombedCharSequence"));
        }
        return bombedCharSequence;
    }
}

