/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SubstrateRef {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.SubstrateRef");

    @NotNull
    public abstract ASTNode getNode();

    @Nullable
    public Stub getStub() {
        return null;
    }

    public abstract boolean isValid();

    @NotNull
    public abstract PsiFile getContainingFile();

    @NotNull
    static SubstrateRef createInvalidRef(final @NotNull StubBasedPsiElementBase<?> psi) {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "com/intellij/psi/impl/source/SubstrateRef", "createInvalidRef"));
        }
        SubstrateRef substrateRef = new SubstrateRef(){

            @Override
            @NotNull
            public ASTNode getNode() {
                throw new PsiInvalidElementAccessException(psi);
            }

            @Override
            public boolean isValid() {
                return false;
            }

            @Override
            @NotNull
            public PsiFile getContainingFile() {
                throw new PsiInvalidElementAccessException(psi);
            }
        };
        if (substrateRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/SubstrateRef", "createInvalidRef"));
        }
        return substrateRef;
    }

    public static SubstrateRef createAstStrongRef(final @NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/impl/source/SubstrateRef", "createAstStrongRef"));
        }
        return new SubstrateRef(){

            @Override
            @NotNull
            public ASTNode getNode() {
                ASTNode aSTNode = node;
                if (aSTNode == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/SubstrateRef$2", "getNode"));
                }
                return aSTNode;
            }

            @Override
            public boolean isValid() {
                FileASTNode fileElement = SharedImplUtil.findFileElement(node);
                PsiElement file = fileElement == null ? null : fileElement.getPsi();
                return file != null && file.isValid();
            }

            @Override
            @NotNull
            public PsiFile getContainingFile() {
                PsiFile psiFile = SharedImplUtil.getContainingFile(node);
                if (psiFile == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/SubstrateRef$2", "getContainingFile"));
                }
                return psiFile;
            }
        };
    }

    public static class StubRef
    extends SubstrateRef {
        private final StubElement myStub;

        public StubRef(@NotNull StubElement stub) {
            if (stub == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/psi/impl/source/SubstrateRef$StubRef", "<init>"));
            }
            this.myStub = stub;
        }

        @Override
        @NotNull
        public ASTNode getNode() {
            throw new UnsupportedOperationException();
        }

        @Override
        @Nullable
        public Stub getStub() {
            return this.myStub;
        }

        @Override
        public boolean isValid() {
            StubElement parent = this.myStub.getParentStub();
            if (parent == null) {
                LOG.error("No parent for stub " + this.myStub + " of class " + this.myStub.getClass());
                return false;
            }
            Object psi = parent.getPsi();
            return psi != null && psi.isValid();
        }

        @Override
        @NotNull
        public PsiFile getContainingFile() {
            throw new UnsupportedOperationException();
        }
    }
}

