/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.ClassUtilCore;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.StartupProgress;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginClassCache;
import com.intellij.ide.plugins.cl.PluginClassLoader;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.AreaListener;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.LogProvider;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.LineSeparator;
import com.intellij.util.PathUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.graph.CachingSemiGraph;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphGenerator;
import com.intellij.util.xmlb.XmlSerializationException;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TIntProcedure;
import gnu.trove.TObjectIntHashMap;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jdom.Document;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginManagerCore {
    private static final Logger LOG = Logger.getInstance(PluginManagerCore.class);
    private static final String DISABLED_PLUGINS_FILENAME = "disabled_plugins.txt";
    public static final String CORE_PLUGIN_ID = "com.intellij";
    private static final String META_INF = "META-INF";
    public static final String PLUGIN_XML = "plugin.xml";
    private static final float PLUGINS_PROGRESS_MAX_VALUE = 0.3f;
    private static final TObjectIntHashMap<PluginId> ourId2Index = new TObjectIntHashMap();
    static final String MODULE_DEPENDENCY_PREFIX = "com.intellij.module";
    private static final Map<String, IdeaPluginDescriptorImpl> ourModulesToContainingPlugins = new THashMap();
    private static final PluginClassCache ourPluginClasses = new PluginClassCache();
    private static final String SPECIAL_IDEA_PLUGIN = "IDEA CORE";
    static final String DISABLE = "disable";
    static final String ENABLE = "enable";
    static final String EDIT = "edit";
    private static final String PROPERTY_PLUGIN_PATH = "plugin.path";
    private static List<String> ourDisabledPlugins;
    private static MultiMap<String, String> ourBrokenPluginVersions;
    private static IdeaPluginDescriptor[] ourPlugins;
    static String myPluginError;
    static List<String> myPlugins2Disable;
    static LinkedHashSet<String> myPlugins2Enable;
    public static String BUILD_NUMBER;

    @NotNull
    public static IdeaPluginDescriptor[] getPlugins() {
        IdeaPluginDescriptor[] ideaPluginDescriptorArray = PluginManagerCore.getPlugins(null);
        if (ideaPluginDescriptorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/plugins/PluginManagerCore", "getPlugins"));
        }
        return ideaPluginDescriptorArray;
    }

    @NotNull
    public static synchronized IdeaPluginDescriptor[] getPlugins(@Nullable StartupProgress progress) {
        if (ourPlugins == null) {
            PluginManagerCore.initPlugins(progress);
        }
        if (ourPlugins == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/plugins/PluginManagerCore", "getPlugins"));
        }
        return ourPlugins;
    }

    public static synchronized void setPlugins(@NotNull IdeaPluginDescriptor[] descriptors) {
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/ide/plugins/PluginManagerCore", "setPlugins"));
        }
        ourPlugins = descriptors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadDisabledPlugins(@NotNull String configPath, @NotNull Collection<String> disabledPlugins) {
        if (configPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configPath", "com/intellij/ide/plugins/PluginManagerCore", "loadDisabledPlugins"));
        }
        if (disabledPlugins == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disabledPlugins", "com/intellij/ide/plugins/PluginManagerCore", "loadDisabledPlugins"));
        }
        File file = new File(configPath, DISABLED_PLUGINS_FILENAME);
        List<String> requiredPlugins = StringUtil.split(System.getProperty("idea.required.plugins.id", ""), ",");
        if (file.isFile()) {
            try {
                BufferedReader reader = new BufferedReader(new FileReader(file));
                try {
                    String id;
                    while ((id = reader.readLine()) != null) {
                        if (requiredPlugins.contains(id = id.trim())) continue;
                        disabledPlugins.add(id);
                    }
                }
                finally {
                    reader.close();
                    if (!requiredPlugins.isEmpty()) {
                        PluginManagerCore.savePluginsList(disabledPlugins, false, new File(PathManager.getConfigPath(), DISABLED_PLUGINS_FILENAME));
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @NotNull
    public static List<String> getDisabledPlugins() {
        if (ourDisabledPlugins == null) {
            ourDisabledPlugins = new ArrayList<String>();
            if (System.getProperty("idea.ignore.disabled.plugins") == null && !PluginManagerCore.isUnitTestMode()) {
                PluginManagerCore.loadDisabledPlugins(PathManager.getConfigPath(), ourDisabledPlugins);
            }
        }
        List<String> list = ourDisabledPlugins;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/plugins/PluginManagerCore", "getDisabledPlugins"));
        }
        return list;
    }

    public static boolean isBrokenPlugin(@NotNull IdeaPluginDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/ide/plugins/PluginManagerCore", "isBrokenPlugin"));
        }
        return PluginManagerCore.getBrokenPluginVersions().get(descriptor.getPluginId().getIdString()).contains(descriptor.getVersion());
    }

    @NotNull
    private static MultiMap<String, String> getBrokenPluginVersions() {
        if (ourBrokenPluginVersions == null) {
            ourBrokenPluginVersions = MultiMap.createSet();
            if (System.getProperty("idea.ignore.disabled.plugins") == null && !PluginManagerCore.isUnitTestMode()) {
                BufferedReader br = new BufferedReader(new InputStreamReader(PluginManagerCore.class.getResourceAsStream("/brokenPlugins.txt")));
                try {
                    String s;
                    while ((s = br.readLine()) != null) {
                        List<String> tokens;
                        if ((s = s.trim()).startsWith("//") || (tokens = ParametersListUtil.parse(s)).isEmpty()) continue;
                        if (tokens.size() == 1) {
                            throw new RuntimeException("brokenPlugins.txt is broken. The line contains plugin name, but does not contains version: " + s);
                        }
                        String pluginId = tokens.get(0);
                        List<String> versions = tokens.subList(1, tokens.size());
                        ourBrokenPluginVersions.putValues(pluginId, versions);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to read /brokenPlugins.txt", e);
                }
                finally {
                    StreamUtil.closeStream(br);
                }
            }
        }
        MultiMap<String, String> multiMap = ourBrokenPluginVersions;
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/plugins/PluginManagerCore", "getBrokenPluginVersions"));
        }
        return multiMap;
    }

    private static boolean isUnitTestMode() {
        Application app = ApplicationManager.getApplication();
        return app != null && app.isUnitTestMode();
    }

    public static void savePluginsList(@NotNull Collection<String> ids, boolean append, @NotNull File plugins) throws IOException {
        if (ids == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ids", "com/intellij/ide/plugins/PluginManagerCore", "savePluginsList"));
        }
        if (plugins == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "plugins", "com/intellij/ide/plugins/PluginManagerCore", "savePluginsList"));
        }
        if (!plugins.isFile()) {
            FileUtil.ensureCanCreateFile(plugins);
        }
        PluginManagerCore.writePluginsList(ids, new BufferedWriter(new FileWriter(plugins, append)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writePluginsList(@NotNull Collection<String> ids, @NotNull Writer writer) throws IOException {
        if (ids == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ids", "com/intellij/ide/plugins/PluginManagerCore", "writePluginsList"));
        }
        if (writer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "writer", "com/intellij/ide/plugins/PluginManagerCore", "writePluginsList"));
        }
        try {
            for (String id : ids) {
                writer.write(id);
                writer.write(LineSeparator.getSystemLineSeparator().getSeparatorString());
            }
        }
        finally {
            writer.close();
        }
    }

    public static boolean disablePlugin(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/ide/plugins/PluginManagerCore", "disablePlugin"));
        }
        List<String> disabledPlugins = PluginManagerCore.getDisabledPlugins();
        if (disabledPlugins.contains(id)) {
            return false;
        }
        disabledPlugins.add(id);
        try {
            PluginManagerCore.saveDisabledPlugins(disabledPlugins, false);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public static boolean enablePlugin(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/ide/plugins/PluginManagerCore", "enablePlugin"));
        }
        if (!PluginManagerCore.getDisabledPlugins().contains(id)) {
            return false;
        }
        PluginManagerCore.getDisabledPlugins().remove(id);
        try {
            PluginManagerCore.saveDisabledPlugins(PluginManagerCore.getDisabledPlugins(), false);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public static void saveDisabledPlugins(@NotNull Collection<String> ids, boolean append) throws IOException {
        if (ids == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ids", "com/intellij/ide/plugins/PluginManagerCore", "saveDisabledPlugins"));
        }
        File plugins = new File(PathManager.getConfigPath(), DISABLED_PLUGINS_FILENAME);
        PluginManagerCore.savePluginsList(ids, append, plugins);
        ourDisabledPlugins = null;
    }

    public static Logger getLogger() {
        return LoggerHolder.ourLogger;
    }

    public static int getPluginLoadingOrder(@NotNull PluginId id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/ide/plugins/PluginManagerCore", "getPluginLoadingOrder"));
        }
        return ourId2Index.get((Object)id);
    }

    static boolean isModuleDependency(@NotNull PluginId dependentPluginId) {
        if (dependentPluginId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependentPluginId", "com/intellij/ide/plugins/PluginManagerCore", "isModuleDependency"));
        }
        return dependentPluginId.getIdString().startsWith(MODULE_DEPENDENCY_PREFIX);
    }

    public static void checkDependants(@NotNull IdeaPluginDescriptor pluginDescriptor, @NotNull Function<PluginId, IdeaPluginDescriptor> pluginId2Descriptor, @NotNull Condition<PluginId> check) {
        if (pluginDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginDescriptor", "com/intellij/ide/plugins/PluginManagerCore", "checkDependants"));
        }
        if (pluginId2Descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginId2Descriptor", "com/intellij/ide/plugins/PluginManagerCore", "checkDependants"));
        }
        if (check == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "check", "com/intellij/ide/plugins/PluginManagerCore", "checkDependants"));
        }
        PluginManagerCore.checkDependants(pluginDescriptor, pluginId2Descriptor, check, (Set<PluginId>)new THashSet());
    }

    private static boolean checkDependants(@NotNull IdeaPluginDescriptor pluginDescriptor, @NotNull Function<PluginId, IdeaPluginDescriptor> pluginId2Descriptor, @NotNull Condition<PluginId> check, @NotNull Set<PluginId> processed) {
        if (pluginDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginDescriptor", "com/intellij/ide/plugins/PluginManagerCore", "checkDependants"));
        }
        if (pluginId2Descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginId2Descriptor", "com/intellij/ide/plugins/PluginManagerCore", "checkDependants"));
        }
        if (check == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "check", "com/intellij/ide/plugins/PluginManagerCore", "checkDependants"));
        }
        if (processed == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processed", "com/intellij/ide/plugins/PluginManagerCore", "checkDependants"));
        }
        processed.add(pluginDescriptor.getPluginId());
        PluginId[] dependentPluginIds = pluginDescriptor.getDependentPluginIds();
        THashSet optionalDependencies = new THashSet(Arrays.asList(pluginDescriptor.getOptionalDependentPluginIds()));
        for (PluginId dependentPluginId : dependentPluginIds) {
            if (processed.contains(dependentPluginId) || PluginManagerCore.isModuleDependency(dependentPluginId) && (ourModulesToContainingPlugins.isEmpty() || ourModulesToContainingPlugins.containsKey(dependentPluginId.getIdString())) || optionalDependencies.contains(dependentPluginId)) continue;
            if (!check.value(dependentPluginId)) {
                return false;
            }
            IdeaPluginDescriptor dependantPluginDescriptor = pluginId2Descriptor.fun(dependentPluginId);
            if (dependantPluginDescriptor == null || PluginManagerCore.checkDependants(dependantPluginDescriptor, pluginId2Descriptor, check, processed)) continue;
            return false;
        }
        return true;
    }

    public static void addPluginClass(PluginId pluginId) {
        ourPluginClasses.addPluginClass(pluginId);
    }

    @Nullable
    public static PluginId getPluginByClassName(@NotNull String className) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/intellij/ide/plugins/PluginManagerCore", "getPluginByClassName"));
        }
        for (IdeaPluginDescriptor descriptor : PluginManagerCore.getPlugins()) {
            ClassLoader loader = descriptor.getPluginClassLoader();
            if (!(loader instanceof PluginClassLoader) || !((PluginClassLoader)loader).hasLoadedClass(className)) continue;
            return descriptor.getPluginId();
        }
        return null;
    }

    public static void dumpPluginClassStatistics() {
        ourPluginClasses.dumpPluginClassStatistics();
    }

    private static boolean isDependent(@NotNull IdeaPluginDescriptor descriptor, @NotNull PluginId on, @NotNull Map<PluginId, IdeaPluginDescriptor> map, boolean checkModuleDependencies) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/ide/plugins/PluginManagerCore", "isDependent"));
        }
        if (on == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "on", "com/intellij/ide/plugins/PluginManagerCore", "isDependent"));
        }
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/ide/plugins/PluginManagerCore", "isDependent"));
        }
        for (PluginId id : descriptor.getDependentPluginIds()) {
            if (ArrayUtil.contains(id, (Object[])descriptor.getOptionalDependentPluginIds()) || !checkModuleDependencies && PluginManagerCore.isModuleDependency(id)) continue;
            if (id.equals(on)) {
                return true;
            }
            IdeaPluginDescriptor depDescriptor = map.get(id);
            if (depDescriptor == null || !PluginManagerCore.isDependent(depDescriptor, on, map, checkModuleDependencies)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasModuleDependencies(@NotNull IdeaPluginDescriptor descriptor) {
        PluginId[] dependentPluginIds;
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/ide/plugins/PluginManagerCore", "hasModuleDependencies"));
        }
        for (PluginId dependentPluginId : dependentPluginIds = descriptor.getDependentPluginIds()) {
            if (!PluginManagerCore.isModuleDependency(dependentPluginId)) continue;
            return true;
        }
        return false;
    }

    private static boolean shouldLoadPlugins() {
        try {
            Class.forName("com.intellij.openapi.extensions.Extensions");
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        String loadPlugins = System.getProperty("idea.load.plugins");
        return loadPlugins == null || Boolean.TRUE.toString().equals(loadPlugins);
    }

    public static void configureExtensions() {
        Extensions.setLogProvider(new IdeaLogProvider());
        Extensions.registerAreaClass("IDEA_PROJECT", null);
        Extensions.registerAreaClass("IDEA_MODULE", "IDEA_PROJECT");
    }

    private static Method getAddUrlMethod(@NotNull ClassLoader loader) {
        if (loader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loader", "com/intellij/ide/plugins/PluginManagerCore", "getAddUrlMethod"));
        }
        return ReflectionUtil.getDeclaredMethod(loader instanceof URLClassLoader ? URLClassLoader.class : loader.getClass(), "addURL", URL.class);
    }

    @Nullable
    private static ClassLoader createPluginClassLoader(@NotNull File[] classPath, @NotNull ClassLoader[] parentLoaders, @NotNull IdeaPluginDescriptor pluginDescriptor) {
        if (classPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classPath", "com/intellij/ide/plugins/PluginManagerCore", "createPluginClassLoader"));
        }
        if (parentLoaders == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentLoaders", "com/intellij/ide/plugins/PluginManagerCore", "createPluginClassLoader"));
        }
        if (pluginDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginDescriptor", "com/intellij/ide/plugins/PluginManagerCore", "createPluginClassLoader"));
        }
        if (pluginDescriptor.getUseIdeaClassLoader()) {
            try {
                ClassLoader loader = PluginManagerCore.class.getClassLoader();
                Method addUrlMethod = PluginManagerCore.getAddUrlMethod(loader);
                for (File aClassPath : classPath) {
                    File file = aClassPath.getCanonicalFile();
                    addUrlMethod.invoke((Object)loader, file.toURI().toURL());
                }
                return loader;
            }
            catch (IOException e) {
                PluginManagerCore.getLogger().warn(e);
            }
            catch (IllegalAccessException e) {
                PluginManagerCore.getLogger().warn(e);
            }
            catch (InvocationTargetException e) {
                PluginManagerCore.getLogger().warn(e);
            }
        }
        PluginId pluginId = pluginDescriptor.getPluginId();
        File pluginRoot = pluginDescriptor.getPath();
        if (PluginManagerCore.isUnitTestMode()) {
            return null;
        }
        try {
            ArrayList<URL> urls = new ArrayList<URL>(classPath.length);
            for (File aClassPath : classPath) {
                File file = aClassPath.getCanonicalFile();
                urls.add(file.toURI().toURL());
            }
            return new PluginClassLoader(urls, parentLoaders, pluginId, pluginDescriptor.getVersion(), pluginRoot);
        }
        catch (MalformedURLException e) {
            PluginManagerCore.getLogger().warn(e);
        }
        catch (IOException e) {
            PluginManagerCore.getLogger().warn(e);
        }
        return null;
    }

    public static void invalidatePlugins() {
        ourPlugins = null;
        ourDisabledPlugins = null;
    }

    public static boolean isPluginClass(@NotNull String className) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/intellij/ide/plugins/PluginManagerCore", "isPluginClass"));
        }
        return ourPlugins != null && PluginManagerCore.getPluginByClassName(className) != null;
    }

    private static void logPlugins() {
        ArrayList<String> loadedBundled = new ArrayList<String>();
        ArrayList<String> disabled = new ArrayList<String>();
        ArrayList<String> loadedCustom = new ArrayList<String>();
        for (IdeaPluginDescriptor descriptor : ourPlugins) {
            String version = descriptor.getVersion();
            String s = descriptor.getName() + (version != null ? " (" + version + ")" : "");
            if (descriptor.isEnabled()) {
                if (descriptor.isBundled() || SPECIAL_IDEA_PLUGIN.equals(descriptor.getName())) {
                    loadedBundled.add(s);
                    continue;
                }
                loadedCustom.add(s);
                continue;
            }
            disabled.add(s);
        }
        Collections.sort(loadedBundled);
        Collections.sort(loadedCustom);
        Collections.sort(disabled);
        PluginManagerCore.getLogger().info("Loaded bundled plugins: " + StringUtil.join(loadedBundled, ", "));
        if (!loadedCustom.isEmpty()) {
            PluginManagerCore.getLogger().info("Loaded custom plugins: " + StringUtil.join(loadedCustom, ", "));
        }
        if (!disabled.isEmpty()) {
            PluginManagerCore.getLogger().info("Disabled plugins: " + StringUtil.join(disabled, ", "));
        }
    }

    @NotNull
    private static ClassLoader[] getParentLoaders(@NotNull Map<PluginId, ? extends IdeaPluginDescriptor> idToDescriptorMap, @NotNull PluginId[] pluginIds) {
        if (idToDescriptorMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "idToDescriptorMap", "com/intellij/ide/plugins/PluginManagerCore", "getParentLoaders"));
        }
        if (pluginIds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginIds", "com/intellij/ide/plugins/PluginManagerCore", "getParentLoaders"));
        }
        if (PluginManagerCore.isUnitTestMode()) {
            ClassLoader[] classLoaderArray = new ClassLoader[]{};
            if (classLoaderArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/plugins/PluginManagerCore", "getParentLoaders"));
            }
            return classLoaderArray;
        }
        ArrayList<ClassLoader> classLoaders = new ArrayList<ClassLoader>();
        for (PluginId id : pluginIds) {
            IdeaPluginDescriptor pluginDescriptor = idToDescriptorMap.get(id);
            if (pluginDescriptor == null) continue;
            ClassLoader loader = pluginDescriptor.getPluginClassLoader();
            if (loader == null) {
                PluginManagerCore.getLogger().error("Plugin class loader should be initialized for plugin " + id);
            }
            classLoaders.add(loader);
        }
        ClassLoader[] classLoaderArray = classLoaders.toArray(new ClassLoader[classLoaders.size()]);
        if (classLoaderArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/plugins/PluginManagerCore", "getParentLoaders"));
        }
        return classLoaderArray;
    }

    private static int countPlugins(@NotNull String pluginsPath) {
        String[] list;
        if (pluginsPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginsPath", "com/intellij/ide/plugins/PluginManagerCore", "countPlugins"));
        }
        File configuredPluginsDir = new File(pluginsPath);
        if (configuredPluginsDir.exists() && (list = configuredPluginsDir.list()) != null) {
            return list.length;
        }
        return 0;
    }

    private static void prepareLoadingPluginsErrorMessage(@NotNull List<String> errors) {
        if (errors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errors", "com/intellij/ide/plugins/PluginManagerCore", "prepareLoadingPluginsErrorMessage"));
        }
        if (!errors.isEmpty()) {
            String errorMessage = IdeBundle.message("error.problems.found.loading.plugins", new Object[0]) + StringUtil.join(errors, "<p/>");
            Application app = ApplicationManager.getApplication();
            if (app != null && !app.isHeadlessEnvironment() && !app.isUnitTestMode()) {
                myPluginError = myPluginError == null ? errorMessage : myPluginError + "\n" + errorMessage;
            } else {
                PluginManagerCore.getLogger().error(errorMessage);
            }
        }
    }

    private static void addModulesAsDependents(@NotNull Map<PluginId, ? super IdeaPluginDescriptorImpl> map) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/ide/plugins/PluginManagerCore", "addModulesAsDependents"));
        }
        for (Map.Entry<String, IdeaPluginDescriptorImpl> entry : ourModulesToContainingPlugins.entrySet()) {
            map.put(PluginId.getId(entry.getKey()), entry.getValue());
        }
    }

    @NotNull
    private static Comparator<IdeaPluginDescriptor> getPluginDescriptorComparator(final @NotNull Map<PluginId, ? extends IdeaPluginDescriptor> idToDescriptorMap, @NotNull List<String> errors) {
        if (idToDescriptorMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "idToDescriptorMap", "com/intellij/ide/plugins/PluginManagerCore", "getPluginDescriptorComparator"));
        }
        if (errors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errors", "com/intellij/ide/plugins/PluginManagerCore", "getPluginDescriptorComparator"));
        }
        Graph<PluginId> graph = PluginManagerCore.createPluginIdGraph(idToDescriptorMap);
        final DFSTBuilder<PluginId> builder = new DFSTBuilder<PluginId>(graph);
        if (!builder.isAcyclic()) {
            String cyclePresentation;
            final ArrayList<String> cycles = new ArrayList<String>();
            builder.getSCCs().forEach(new TIntProcedure(){
                private int myTNumber;

                public boolean execute(int size) {
                    if (size > 1) {
                        String cycle = "";
                        for (int j = 0; j < size; ++j) {
                            PluginId id = (PluginId)builder.getNodeByTNumber(this.myTNumber + j);
                            ((IdeaPluginDescriptor)idToDescriptorMap.get(id)).setEnabled(false);
                            cycle = cycle + id.getIdString() + " ";
                        }
                        cycles.add(cycle);
                    }
                    this.myTNumber += size;
                    return true;
                }
            });
            if (ApplicationManager.getApplication().isInternal()) {
                cyclePresentation = StringUtil.join(cycles, ";");
            } else {
                Couple<PluginId> circularDependency = builder.getCircularDependency();
                PluginId id = (PluginId)circularDependency.getFirst();
                PluginId parentId = (PluginId)circularDependency.getSecond();
                cyclePresentation = id + "->" + parentId + "->...->" + id;
            }
            errors.add(IdeBundle.message("error.plugins.should.not.have.cyclic.dependencies", new Object[0]) + " " + cyclePresentation);
        }
        final Comparator<PluginId> idComparator = builder.comparator();
        Comparator<IdeaPluginDescriptor> comparator = new Comparator<IdeaPluginDescriptor>(){

            @Override
            public int compare(@NotNull IdeaPluginDescriptor o1, @NotNull IdeaPluginDescriptor o2) {
                if (o1 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "com/intellij/ide/plugins/PluginManagerCore$2", "compare"));
                }
                if (o2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o2", "com/intellij/ide/plugins/PluginManagerCore$2", "compare"));
                }
                PluginId pluginId1 = o1.getPluginId();
                PluginId pluginId2 = o2.getPluginId();
                if (pluginId1.getIdString().equals(PluginManagerCore.CORE_PLUGIN_ID)) {
                    return -1;
                }
                if (pluginId2.getIdString().equals(PluginManagerCore.CORE_PLUGIN_ID)) {
                    return 1;
                }
                return idComparator.compare(pluginId1, pluginId2);
            }
        };
        if (comparator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/plugins/PluginManagerCore", "getPluginDescriptorComparator"));
        }
        return comparator;
    }

    @NotNull
    private static Graph<PluginId> createPluginIdGraph(final @NotNull Map<PluginId, ? extends IdeaPluginDescriptor> idToDescriptorMap) {
        if (idToDescriptorMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "idToDescriptorMap", "com/intellij/ide/plugins/PluginManagerCore", "createPluginIdGraph"));
        }
        final ArrayList<PluginId> ids = new ArrayList<PluginId>(idToDescriptorMap.keySet());
        Collections.sort(ids, new Comparator<PluginId>(){

            @Override
            public int compare(@NotNull PluginId o1, @NotNull PluginId o2) {
                if (o1 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "com/intellij/ide/plugins/PluginManagerCore$3", "compare"));
                }
                if (o2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o2", "com/intellij/ide/plugins/PluginManagerCore$3", "compare"));
                }
                return o2.getIdString().compareTo(o1.getIdString());
            }
        });
        GraphGenerator<PluginId> graphGenerator = GraphGenerator.create(CachingSemiGraph.create(new GraphGenerator.SemiGraph<PluginId>(){

            @Override
            public Collection<PluginId> getNodes() {
                return ids;
            }

            @Override
            public Iterator<PluginId> getIn(PluginId pluginId) {
                IdeaPluginDescriptor descriptor = (IdeaPluginDescriptor)idToDescriptorMap.get(pluginId);
                ArrayList<PluginId> plugins = new ArrayList<PluginId>();
                for (PluginId dependentPluginId : descriptor.getDependentPluginIds()) {
                    PluginId realPluginId;
                    IdeaPluginDescriptor dep = (IdeaPluginDescriptor)idToDescriptorMap.get(dependentPluginId);
                    if (dep == null || !idToDescriptorMap.containsKey(realPluginId = dep.getPluginId())) continue;
                    plugins.add(realPluginId);
                }
                return plugins.iterator();
            }
        }));
        if (graphGenerator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/plugins/PluginManagerCore", "createPluginIdGraph"));
        }
        return graphGenerator;
    }

    @Nullable
    private static IdeaPluginDescriptorImpl loadDescriptorFromDir(@NotNull File file, @NotNull String fileName) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/plugins/PluginManagerCore", "loadDescriptorFromDir"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/ide/plugins/PluginManagerCore", "loadDescriptorFromDir"));
        }
        File descriptorFile = new File(file, META_INF + File.separator + fileName);
        if (descriptorFile.exists()) {
            try {
                IdeaPluginDescriptorImpl descriptor = new IdeaPluginDescriptorImpl(file);
                descriptor.readExternal(descriptorFile.toURI().toURL());
                return descriptor;
            }
            catch (XmlSerializationException e) {
                PluginManagerCore.getLogger().info("Cannot load " + file, e);
                PluginManagerCore.prepareLoadingPluginsErrorMessage(Collections.singletonList("File '" + file.getName() + "' contains invalid plugin descriptor."));
            }
            catch (Throwable e) {
                PluginManagerCore.getLogger().info("Cannot load " + file, e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static IdeaPluginDescriptorImpl loadDescriptorFromJar(@NotNull File file, @NotNull String fileName) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/plugins/PluginManagerCore", "loadDescriptorFromJar"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/ide/plugins/PluginManagerCore", "loadDescriptorFromJar"));
        }
        try {
            String fileURL = StringUtil.replace(file.toURI().toASCIIString(), "!", "%21");
            URL jarURL = new URL("jar:" + fileURL + "!/" + META_INF + '/' + fileName);
            ZipFile zipFile = new ZipFile(file);
            try {
                ZipEntry entry = zipFile.getEntry("META-INF/" + fileName);
                if (entry == null) return null;
                Document document = JDOMUtil.loadDocument(zipFile.getInputStream(entry));
                IdeaPluginDescriptorImpl descriptor = new IdeaPluginDescriptorImpl(file);
                descriptor.readExternal(document, jarURL);
                IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = descriptor;
                return ideaPluginDescriptorImpl;
            }
            finally {
                zipFile.close();
            }
        }
        catch (XmlSerializationException e) {
            PluginManagerCore.getLogger().info("Cannot load " + file, e);
            PluginManagerCore.prepareLoadingPluginsErrorMessage(Collections.singletonList("File '" + file.getName() + "' contains invalid plugin descriptor."));
            return null;
        }
        catch (Throwable e) {
            PluginManagerCore.getLogger().info("Cannot load " + file, e);
        }
        return null;
    }

    @Nullable
    public static IdeaPluginDescriptorImpl loadDescriptor(final @NotNull File file, @NotNull String fileName) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/plugins/PluginManagerCore", "loadDescriptor"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/ide/plugins/PluginManagerCore", "loadDescriptor"));
        }
        IdeaPluginDescriptorImpl descriptor = null;
        final boolean directory = file.isDirectory();
        if (directory) {
            descriptor = PluginManagerCore.loadDescriptorFromDir(file, fileName);
            if (descriptor == null) {
                File libDir = new File(file, "lib");
                if (!libDir.isDirectory()) {
                    return null;
                }
                File[] files = libDir.listFiles();
                if (files == null || files.length == 0) {
                    return null;
                }
                Arrays.sort(files, new Comparator<File>(){

                    @Override
                    public int compare(@NotNull File o1, @NotNull File o2) {
                        if (o1 == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "com/intellij/ide/plugins/PluginManagerCore$5", "compare"));
                        }
                        if (o2 == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o2", "com/intellij/ide/plugins/PluginManagerCore$5", "compare"));
                        }
                        if (o2.getName().startsWith(file.getName())) {
                            return Integer.MAX_VALUE;
                        }
                        if (o1.getName().startsWith(file.getName())) {
                            return -2147483647;
                        }
                        if (o2.getName().startsWith("resources")) {
                            return -2147483647;
                        }
                        if (o1.getName().startsWith("resources")) {
                            return Integer.MAX_VALUE;
                        }
                        return 0;
                    }
                });
                for (File f : files) {
                    IdeaPluginDescriptorImpl descriptor1;
                    if (FileUtil.isJarOrZip(f)) {
                        descriptor = PluginManagerCore.loadDescriptorFromJar(f, fileName);
                        if (descriptor == null) continue;
                        descriptor.setPath(file);
                        break;
                    }
                    if (!f.isDirectory() || (descriptor1 = PluginManagerCore.loadDescriptorFromDir(f, fileName)) == null) continue;
                    if (descriptor != null) {
                        PluginManagerCore.getLogger().info("Cannot load " + file + " because two or more plugin.xml's detected");
                        return null;
                    }
                    descriptor = descriptor1;
                    descriptor.setPath(file);
                }
            }
        } else if (StringUtil.endsWithIgnoreCase(file.getName(), ".jar") && file.exists()) {
            descriptor = PluginManagerCore.loadDescriptorFromJar(file, fileName);
        }
        if (descriptor != null) {
            PluginManagerCore.resolveOptionalDescriptors(fileName, descriptor, new Function<String, IdeaPluginDescriptorImpl>(){

                @Override
                public IdeaPluginDescriptorImpl fun(String optionalDescriptorName) {
                    URL resource;
                    IdeaPluginDescriptorImpl optionalDescriptor = PluginManagerCore.loadDescriptor(file, optionalDescriptorName);
                    if (optionalDescriptor == null && directory && (resource = PluginManagerCore.class.getClassLoader().getResource("META-INF/" + optionalDescriptorName)) != null) {
                        optionalDescriptor = PluginManagerCore.loadDescriptorFromResource(resource);
                    }
                    return optionalDescriptor;
                }
            });
        }
        return descriptor;
    }

    public static void resolveOptionalDescriptors(@NotNull String fileName, @NotNull IdeaPluginDescriptorImpl descriptor, @NotNull Function<String, IdeaPluginDescriptorImpl> optionalDescriptorLoader) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/ide/plugins/PluginManagerCore", "resolveOptionalDescriptors"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/ide/plugins/PluginManagerCore", "resolveOptionalDescriptors"));
        }
        if (optionalDescriptorLoader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "optionalDescriptorLoader", "com/intellij/ide/plugins/PluginManagerCore", "resolveOptionalDescriptors"));
        }
        Map<PluginId, String> optionalConfigs = descriptor.getOptionalConfigs();
        if (optionalConfigs != null && !optionalConfigs.isEmpty()) {
            THashMap descriptors = new THashMap(optionalConfigs.size());
            for (Map.Entry<PluginId, String> entry : optionalConfigs.entrySet()) {
                String optionalDescriptorName = entry.getValue();
                if (fileName.equals(optionalDescriptorName)) {
                    PluginManagerCore.getLogger().info("recursive dependency (" + fileName + ") in " + descriptor);
                    continue;
                }
                IdeaPluginDescriptorImpl optionalDescriptor = optionalDescriptorLoader.fun(optionalDescriptorName);
                if (optionalDescriptor == null) {
                    PluginManagerCore.getLogger().info("Cannot find optional descriptor " + optionalDescriptorName);
                    continue;
                }
                descriptors.put(entry.getKey(), optionalDescriptor);
            }
            descriptor.setOptionalDescriptors((Map<PluginId, IdeaPluginDescriptorImpl>)descriptors);
        }
    }

    public static void loadDescriptors(@NotNull File pluginsHome, @NotNull List<IdeaPluginDescriptorImpl> result, @Nullable StartupProgress progress, int pluginsCount) {
        if (pluginsHome == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginsHome", "com/intellij/ide/plugins/PluginManagerCore", "loadDescriptors"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/ide/plugins/PluginManagerCore", "loadDescriptors"));
        }
        File[] files = pluginsHome.listFiles();
        if (files != null) {
            int i = result.size();
            for (File file : files) {
                int oldIndex;
                IdeaPluginDescriptorImpl descriptor = PluginManagerCore.loadDescriptor(file, PLUGIN_XML);
                if (descriptor == null) continue;
                if (progress != null) {
                    progress.showProgress(descriptor.getName(), 0.3f * ((float)(++i) / (float)pluginsCount));
                }
                if ((oldIndex = result.indexOf(descriptor)) >= 0) {
                    IdeaPluginDescriptorImpl oldDescriptor = result.get(oldIndex);
                    if (StringUtil.compareVersionNumbers(oldDescriptor.getVersion(), descriptor.getVersion()) >= 0) continue;
                    result.set(oldIndex, descriptor);
                    continue;
                }
                result.add(descriptor);
            }
        }
    }

    private static void filterBadPlugins(@NotNull List<? extends IdeaPluginDescriptor> result, @NotNull Map<String, String> disabledPluginNames, @NotNull List<String> errors) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/ide/plugins/PluginManagerCore", "filterBadPlugins"));
        }
        if (disabledPluginNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disabledPluginNames", "com/intellij/ide/plugins/PluginManagerCore", "filterBadPlugins"));
        }
        if (errors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errors", "com/intellij/ide/plugins/PluginManagerCore", "filterBadPlugins"));
        }
        THashMap idToDescriptorMap = new THashMap();
        boolean pluginsWithoutIdFound = false;
        Iterator<? extends IdeaPluginDescriptor> it = result.iterator();
        while (it.hasNext()) {
            IdeaPluginDescriptor descriptor = it.next();
            PluginId id = descriptor.getPluginId();
            if (id == null) {
                pluginsWithoutIdFound = true;
                continue;
            }
            if (idToDescriptorMap.containsKey(id)) {
                errors.add(IdeBundle.message("message.duplicate.plugin.id", new Object[0]) + id);
                it.remove();
                continue;
            }
            if (!descriptor.isEnabled()) continue;
            idToDescriptorMap.put(id, descriptor);
        }
        PluginManagerCore.addModulesAsDependents((Map<PluginId, ? super IdeaPluginDescriptorImpl>)idToDescriptorMap);
        SmartList<String> disabledPluginIds = new SmartList<String>();
        LinkedHashSet faultyDescriptors = new LinkedHashSet();
        Iterator<? extends IdeaPluginDescriptor> it2 = result.iterator();
        while (it2.hasNext()) {
            IdeaPluginDescriptor pluginDescriptor = it2.next();
            PluginManagerCore.checkDependants(pluginDescriptor, new Function<PluginId, IdeaPluginDescriptor>((Map)idToDescriptorMap){
                final /* synthetic */ Map val$idToDescriptorMap;
                {
                    this.val$idToDescriptorMap = map;
                }

                @Override
                public IdeaPluginDescriptor fun(PluginId pluginId) {
                    return (IdeaPluginDescriptor)this.val$idToDescriptorMap.get(pluginId);
                }
            }, new Condition<PluginId>((Map)idToDescriptorMap, pluginDescriptor, faultyDescriptors, disabledPluginIds, disabledPluginNames, errors, it2){
                final /* synthetic */ Map val$idToDescriptorMap;
                final /* synthetic */ IdeaPluginDescriptor val$pluginDescriptor;
                final /* synthetic */ LinkedHashSet val$faultyDescriptors;
                final /* synthetic */ List val$disabledPluginIds;
                final /* synthetic */ Map val$disabledPluginNames;
                final /* synthetic */ List val$errors;
                final /* synthetic */ Iterator val$it;
                {
                    this.val$idToDescriptorMap = map;
                    this.val$pluginDescriptor = ideaPluginDescriptor;
                    this.val$faultyDescriptors = linkedHashSet;
                    this.val$disabledPluginIds = list;
                    this.val$disabledPluginNames = map2;
                    this.val$errors = list2;
                    this.val$it = iterator;
                }

                @Override
                public boolean value(PluginId pluginId) {
                    if (!this.val$idToDescriptorMap.containsKey(pluginId)) {
                        this.val$pluginDescriptor.setEnabled(false);
                        if (!pluginId.getIdString().startsWith(PluginManagerCore.MODULE_DEPENDENCY_PREFIX)) {
                            boolean disabled;
                            String pluginName;
                            this.val$faultyDescriptors.add(pluginId.getIdString());
                            this.val$disabledPluginIds.add(this.val$pluginDescriptor.getPluginId().getIdString());
                            String name = this.val$pluginDescriptor.getName();
                            IdeaPluginDescriptor descriptor = (IdeaPluginDescriptor)this.val$idToDescriptorMap.get(pluginId);
                            if (descriptor == null) {
                                pluginName = pluginId.getIdString();
                                if (this.val$disabledPluginNames.containsKey(pluginName)) {
                                    pluginName = (String)this.val$disabledPluginNames.get(pluginName);
                                }
                            } else {
                                pluginName = descriptor.getName();
                            }
                            this.val$errors.add(IdeBundle.message((disabled = PluginManagerCore.getDisabledPlugins().contains(pluginId.getIdString())) ? "error.required.plugin.disabled" : "error.required.plugin.not.installed", name, pluginName));
                        }
                        this.val$it.remove();
                        return false;
                    }
                    return true;
                }
            });
        }
        if (!disabledPluginIds.isEmpty()) {
            myPlugins2Disable = disabledPluginIds;
            myPlugins2Enable = faultyDescriptors;
            String error = "<br><a href=\"disable\">Disable ";
            if (disabledPluginIds.size() == 1) {
                PluginId pluginId2Disable = PluginId.getId((String)disabledPluginIds.iterator().next());
                error = error + (idToDescriptorMap.containsKey(pluginId2Disable) ? ((IdeaPluginDescriptor)idToDescriptorMap.get(pluginId2Disable)).getName() : pluginId2Disable.getIdString());
            } else {
                error = error + "not loaded plugins";
            }
            errors.add(error + "</a>");
            boolean possibleToEnable = true;
            for (String descriptor : faultyDescriptors) {
                if (disabledPluginNames.get(descriptor) != null) continue;
                possibleToEnable = false;
                break;
            }
            if (possibleToEnable) {
                errors.add("<a href=\"enable\">Enable " + (faultyDescriptors.size() == 1 ? disabledPluginNames.get(faultyDescriptors.iterator().next()) : " all necessary plugins") + "</a>");
            }
            errors.add("<a href=\"edit\">Open plugin manager</a>");
        }
        if (pluginsWithoutIdFound) {
            errors.add(IdeBundle.message("error.plugins.without.id.found", new Object[0]));
        }
    }

    public static List<? extends IdeaPluginDescriptor> testLoadDescriptorsFromClassPath(@NotNull ClassLoader loader) {
        if (loader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loader", "com/intellij/ide/plugins/PluginManagerCore", "testLoadDescriptorsFromClassPath"));
        }
        List<IdeaPluginDescriptorImpl> descriptors = ContainerUtil.newSmartList();
        PluginManagerCore.loadDescriptorsFromClassPath(descriptors, loader, null);
        return descriptors;
    }

    private static void loadDescriptorsFromClassPath(List<IdeaPluginDescriptorImpl> result, ClassLoader loader, StartupProgress progress) {
        URL resource;
        HashSet<URL> urls = ContainerUtil.newHashSet();
        String platformPrefix = System.getProperty("idea.platform.prefix");
        if (platformPrefix != null && (resource = loader.getResource("META-INF/" + platformPrefix + "Plugin.xml")) != null) {
            urls.add(resource);
        }
        try {
            Enumeration<URL> enumeration = loader.getResources("META-INF/plugin.xml");
            while (enumeration.hasMoreElements()) {
                urls.add(enumeration.nextElement());
            }
        }
        catch (IOException e) {
            PluginManagerCore.getLogger().info(e);
            return;
        }
        int i = 0;
        for (URL url : urls) {
            IdeaPluginDescriptorImpl descriptor = PluginManagerCore.loadDescriptorFromResource(url);
            if (descriptor == null || result.contains(descriptor)) continue;
            descriptor.setUseCoreClassLoader(true);
            result.add(descriptor);
            if (progress == null || SPECIAL_IDEA_PLUGIN.equals(descriptor.getName())) continue;
            progress.showProgress("Plugin loaded: " + descriptor.getName(), 0.3f * (float)(++i) / (float)urls.size());
        }
    }

    @Nullable
    private static IdeaPluginDescriptorImpl loadDescriptorFromResource(@NotNull URL resource) {
        if (resource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resource", "com/intellij/ide/plugins/PluginManagerCore", "loadDescriptorFromResource"));
        }
        try {
            if ("file".equals(resource.getProtocol())) {
                File descriptorFile = PluginManagerCore.urlToFile(resource);
                File pluginDir = descriptorFile.getParentFile().getParentFile();
                return PluginManagerCore.loadDescriptor(pluginDir, descriptorFile.getName());
            }
            if ("jar".equals(resource.getProtocol())) {
                String path = resource.getFile();
                File pluginJar = PluginManagerCore.urlToFile(new URL(path.substring(0, path.indexOf("!/"))));
                return PluginManagerCore.loadDescriptor(pluginJar, PathUtil.getFileName(path));
            }
        }
        catch (Throwable e) {
            PluginManagerCore.getLogger().info("Cannot load " + resource, e);
        }
        return null;
    }

    private static File urlToFile(URL url) throws URISyntaxException, MalformedURLException {
        try {
            return new File(url.toURI());
        }
        catch (URISyntaxException e) {
            String str = url.toString();
            if (str.indexOf(32) > 0) {
                return new File(new URL(StringUtil.replace(str, " ", "%20")).toURI());
            }
            throw e;
        }
    }

    private static void loadDescriptorsFromProperty(@NotNull List<IdeaPluginDescriptorImpl> result) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/ide/plugins/PluginManagerCore", "loadDescriptorsFromProperty"));
        }
        String pathProperty = System.getProperty(PROPERTY_PLUGIN_PATH);
        if (pathProperty == null) {
            return;
        }
        StringTokenizer t = new StringTokenizer(pathProperty, File.pathSeparator + ",");
        while (t.hasMoreTokens()) {
            String s = t.nextToken();
            IdeaPluginDescriptorImpl ideaPluginDescriptor = PluginManagerCore.loadDescriptor(new File(s), PLUGIN_XML);
            if (ideaPluginDescriptor == null) continue;
            result.add(ideaPluginDescriptor);
        }
    }

    @NotNull
    public static IdeaPluginDescriptorImpl[] loadDescriptors(@Nullable StartupProgress progress, @NotNull List<String> errors) {
        if (errors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errors", "com/intellij/ide/plugins/PluginManagerCore", "loadDescriptors"));
        }
        if (ClassUtilCore.isLoadingOfExternalPluginsDisabled()) {
            if (IdeaPluginDescriptorImpl.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/plugins/PluginManagerCore", "loadDescriptors"));
            }
            return IdeaPluginDescriptorImpl.EMPTY_ARRAY;
        }
        ArrayList<IdeaPluginDescriptorImpl> result = new ArrayList<IdeaPluginDescriptorImpl>();
        int pluginsCount = PluginManagerCore.countPlugins(PathManager.getPluginsPath()) + PluginManagerCore.countPlugins(PathManager.getPreInstalledPluginsPath());
        PluginManagerCore.loadDescriptors(new File(PathManager.getPluginsPath()), result, progress, pluginsCount);
        Application application = ApplicationManager.getApplication();
        boolean fromSources = false;
        if (application == null || !application.isUnitTestMode()) {
            int size = result.size();
            PluginManagerCore.loadDescriptors(new File(PathManager.getPreInstalledPluginsPath()), result, progress, pluginsCount);
            fromSources = size == result.size();
        }
        PluginManagerCore.loadDescriptorsFromProperty(result);
        PluginManagerCore.loadDescriptorsFromClassPath(result, PluginManagerCore.class.getClassLoader(), fromSources ? progress : null);
        IdeaPluginDescriptorImpl[] ideaPluginDescriptorImplArray = PluginManagerCore.topoSortPlugins(result, errors);
        if (ideaPluginDescriptorImplArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/plugins/PluginManagerCore", "loadDescriptors"));
        }
        return ideaPluginDescriptorImplArray;
    }

    @NotNull
    public static IdeaPluginDescriptorImpl[] topoSortPlugins(@NotNull List<IdeaPluginDescriptorImpl> result, @NotNull List<String> errors) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/ide/plugins/PluginManagerCore", "topoSortPlugins"));
        }
        if (errors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errors", "com/intellij/ide/plugins/PluginManagerCore", "topoSortPlugins"));
        }
        IdeaPluginDescriptorImpl[] pluginDescriptors = result.toArray(new IdeaPluginDescriptorImpl[result.size()]);
        THashMap idToDescriptorMap = new THashMap();
        for (IdeaPluginDescriptorImpl descriptor : pluginDescriptors) {
            idToDescriptorMap.put(descriptor.getPluginId(), descriptor);
        }
        Arrays.sort(pluginDescriptors, PluginManagerCore.getPluginDescriptorComparator((Map<PluginId, ? extends IdeaPluginDescriptor>)idToDescriptorMap, errors));
        if (pluginDescriptors == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/plugins/PluginManagerCore", "topoSortPlugins"));
        }
        return pluginDescriptors;
    }

    private static void mergeOptionalConfigs(@NotNull Map<PluginId, IdeaPluginDescriptorImpl> descriptors) {
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/ide/plugins/PluginManagerCore", "mergeOptionalConfigs"));
        }
        THashMap descriptorsWithModules = new THashMap(descriptors);
        PluginManagerCore.addModulesAsDependents((Map<PluginId, ? super IdeaPluginDescriptorImpl>)descriptorsWithModules);
        for (IdeaPluginDescriptorImpl descriptor : descriptors.values()) {
            Map<PluginId, IdeaPluginDescriptorImpl> optionalDescriptors = descriptor.getOptionalDescriptors();
            if (optionalDescriptors == null || optionalDescriptors.isEmpty()) continue;
            for (Map.Entry<PluginId, IdeaPluginDescriptorImpl> entry : optionalDescriptors.entrySet()) {
                if (!descriptorsWithModules.containsKey(entry.getKey())) continue;
                descriptor.mergeOptionalConfig(entry.getValue());
            }
        }
    }

    public static void initClassLoader(@NotNull ClassLoader parentLoader, @NotNull IdeaPluginDescriptorImpl descriptor) {
        if (parentLoader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentLoader", "com/intellij/ide/plugins/PluginManagerCore", "initClassLoader"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/ide/plugins/PluginManagerCore", "initClassLoader"));
        }
        List<File> classPath = descriptor.getClassPath();
        ClassLoader loader = PluginManagerCore.createPluginClassLoader(classPath.toArray(new File[classPath.size()]), new ClassLoader[]{parentLoader}, descriptor);
        descriptor.setLoader(loader);
    }

    static BuildNumber getBuildNumber() {
        return Holder.ourBuildNumber;
    }

    @Nullable
    private static String detectReasonToNotLoad(@NotNull IdeaPluginDescriptor descriptor, @NotNull IdeaPluginDescriptor[] loaded) {
        String reasonToNotLoad;
        boolean checkModuleDependencies;
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/ide/plugins/PluginManagerCore", "detectReasonToNotLoad"));
        }
        if (loaded == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loaded", "com/intellij/ide/plugins/PluginManagerCore", "detectReasonToNotLoad"));
        }
        String idString = descriptor.getPluginId().getIdString();
        if (CORE_PLUGIN_ID.equals(idString)) {
            return null;
        }
        String pluginId = System.getProperty("idea.load.plugins.id");
        if (pluginId == null) {
            if (descriptor instanceof IdeaPluginDescriptorImpl && !descriptor.isEnabled()) {
                return "Plugin is not enabled";
            }
            if (!PluginManagerCore.shouldLoadPlugins()) {
                return "Plugins should not be loaded";
            }
        }
        List<String> pluginIds = pluginId == null ? null : StringUtil.split(pluginId, ",");
        boolean bl = checkModuleDependencies = !ourModulesToContainingPlugins.isEmpty() && !ourModulesToContainingPlugins.containsKey("com.intellij.modules.all");
        if (checkModuleDependencies && !PluginManagerCore.hasModuleDependencies(descriptor)) {
            return "Plugin does not include any module dependency tags in its plugin.xml therefore is assumed legacy and can be loaded only in IntelliJ IDEA";
        }
        String loadPluginCategory = System.getProperty("idea.load.plugins.category");
        if (loadPluginCategory != null) {
            reasonToNotLoad = loadPluginCategory.equals(descriptor.getCategory()) ? null : "Plugin category doesn't match 'idea.load.plugins.category' value";
        } else {
            if (pluginIds != null) {
                String string = reasonToNotLoad = pluginIds.contains(idString) ? null : "'idea.load.plugins.id' doesn't contain this plugin id";
                if (reasonToNotLoad != null) {
                    THashMap map = new THashMap();
                    for (IdeaPluginDescriptor pluginDescriptor : loaded) {
                        map.put(pluginDescriptor.getPluginId(), pluginDescriptor);
                    }
                    PluginManagerCore.addModulesAsDependents((Map<PluginId, ? super IdeaPluginDescriptorImpl>)map);
                    for (String id : pluginIds) {
                        IdeaPluginDescriptor descriptorFromProperty = (IdeaPluginDescriptor)map.get(PluginId.getId(id));
                        if (descriptorFromProperty == null || !PluginManagerCore.isDependent(descriptorFromProperty, descriptor.getPluginId(), (Map<PluginId, IdeaPluginDescriptor>)map, checkModuleDependencies)) continue;
                        reasonToNotLoad = null;
                        break;
                    }
                }
            } else {
                String string = reasonToNotLoad = PluginManagerCore.getDisabledPlugins().contains(idString) ? "Plugin is disabled" : null;
            }
            if (reasonToNotLoad == null && descriptor instanceof IdeaPluginDescriptorImpl && PluginManagerCore.isIncompatible(descriptor)) {
                return "Plugin since-build or until-build don't match this product's build number";
            }
        }
        return reasonToNotLoad;
    }

    public static boolean isCompatible(@NotNull IdeaPluginDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/ide/plugins/PluginManagerCore", "isCompatible"));
        }
        return !PluginManagerCore.isIncompatible(descriptor);
    }

    public static boolean isCompatible(@NotNull IdeaPluginDescriptor descriptor, @Nullable BuildNumber buildNumber) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/ide/plugins/PluginManagerCore", "isCompatible"));
        }
        return !PluginManagerCore.isIncompatible(descriptor, buildNumber);
    }

    public static boolean isIncompatible(@NotNull IdeaPluginDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/ide/plugins/PluginManagerCore", "isIncompatible"));
        }
        return PluginManagerCore.isIncompatible(descriptor, PluginManagerCore.getBuildNumber());
    }

    public static boolean isIncompatible(@NotNull IdeaPluginDescriptor descriptor, @Nullable BuildNumber buildNumber) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/ide/plugins/PluginManagerCore", "isIncompatible"));
        }
        if (buildNumber == null) {
            buildNumber = PluginManagerCore.getBuildNumber();
        }
        try {
            return PluginManagerCore.isIncompatible(buildNumber, descriptor.getSinceBuild(), descriptor.getUntilBuild(), descriptor.getName(), descriptor.toString());
        }
        catch (RuntimeException e) {
            LOG.error(e);
            return false;
        }
    }

    public static boolean isIncompatible(@NotNull BuildNumber buildNumber, @Nullable String sinceBuild, @Nullable String untilBuild, @Nullable String descriptorName, @Nullable String descriptorDebugString) {
        BuildNumber untilBuildNumber;
        BuildNumber sinceBuildNumber;
        if (buildNumber == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildNumber", "com/intellij/ide/plugins/PluginManagerCore", "isIncompatible"));
        }
        if (!StringUtil.isEmpty(sinceBuild) && (sinceBuildNumber = BuildNumber.fromString(sinceBuild, descriptorName)).compareTo(buildNumber) > 0) {
            if (descriptorDebugString != null) {
                LOG.warn("Can't load " + descriptorDebugString + ": since build " + sinceBuildNumber + " does not match " + buildNumber);
            }
            return true;
        }
        if (!StringUtil.isEmpty(untilBuild) && (untilBuildNumber = BuildNumber.fromString(untilBuild, descriptorName)).compareTo(buildNumber) < 0) {
            if (descriptorDebugString != null) {
                LOG.warn("Can't load " + descriptorDebugString + ": until build " + untilBuildNumber + " does not match " + buildNumber);
            }
            return true;
        }
        return false;
    }

    public static boolean shouldSkipPlugin(@NotNull IdeaPluginDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/ide/plugins/PluginManagerCore", "shouldSkipPlugin"));
        }
        if (descriptor instanceof IdeaPluginDescriptorImpl) {
            IdeaPluginDescriptorImpl descriptorImpl = (IdeaPluginDescriptorImpl)descriptor;
            Boolean skipped = descriptorImpl.getSkipped();
            if (skipped != null) {
                return skipped;
            }
            boolean result = PluginManagerCore.detectReasonToNotLoad(descriptor, ourPlugins) != null || PluginManagerCore.isBrokenPlugin(descriptor);
            descriptorImpl.setSkipped(result);
            return result;
        }
        return PluginManagerCore.detectReasonToNotLoad(descriptor, ourPlugins) != null || PluginManagerCore.isBrokenPlugin(descriptor);
    }

    private static void initializePlugins(@Nullable StartupProgress progress) {
        int i;
        PluginManagerCore.configureExtensions();
        ArrayList<String> errors = ContainerUtil.newArrayList();
        IdeaPluginDescriptorImpl[] pluginDescriptors = PluginManagerCore.loadDescriptors(progress, errors);
        Class callerClass = ReflectionUtil.findCallerClass(1);
        assert (callerClass != null);
        ClassLoader parentLoader = callerClass.getClassLoader();
        final ArrayList<IdeaPluginDescriptorImpl> result = new ArrayList<IdeaPluginDescriptorImpl>();
        THashMap idToDescriptorMap = new THashMap();
        THashMap disabledPluginNames = new THashMap();
        SmartList<String> brokenPluginsList = new SmartList<String>();
        PluginManagerCore.fixDescriptors(pluginDescriptors, parentLoader, (Map<PluginId, IdeaPluginDescriptorImpl>)idToDescriptorMap, (Map<String, String>)disabledPluginNames, brokenPluginsList, result, errors);
        Graph<PluginId> graph = PluginManagerCore.createPluginIdGraph((Map<PluginId, ? extends IdeaPluginDescriptor>)idToDescriptorMap);
        DFSTBuilder<PluginId> builder = new DFSTBuilder<PluginId>(graph);
        PluginManagerCore.prepareLoadingPluginsErrorMessage(errors);
        final Comparator<PluginId> idComparator = builder.comparator();
        Collections.sort(result, new Comparator<IdeaPluginDescriptor>(){

            @Override
            public int compare(@NotNull IdeaPluginDescriptor o1, @NotNull IdeaPluginDescriptor o2) {
                if (o1 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "com/intellij/ide/plugins/PluginManagerCore$9", "compare"));
                }
                if (o2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o2", "com/intellij/ide/plugins/PluginManagerCore$9", "compare"));
                }
                return idComparator.compare(o1.getPluginId(), o2.getPluginId());
            }
        });
        for (i = 0; i < result.size(); ++i) {
            ourId2Index.put((Object)((IdeaPluginDescriptorImpl)result.get(i)).getPluginId(), i);
        }
        i = 0;
        for (IdeaPluginDescriptorImpl pluginDescriptor : result) {
            if (pluginDescriptor.getPluginId().getIdString().equals(CORE_PLUGIN_ID) || pluginDescriptor.isUseCoreClassLoader()) {
                pluginDescriptor.setLoader(parentLoader);
            } else {
                ClassLoader[] classLoaderArray;
                List<File> classPath = pluginDescriptor.getClassPath();
                PluginId[] dependentPluginIds = pluginDescriptor.getDependentPluginIds();
                ClassLoader[] parentLoaders = PluginManagerCore.getParentLoaders((Map<PluginId, ? extends IdeaPluginDescriptor>)idToDescriptorMap, dependentPluginIds);
                if (parentLoaders.length > 0) {
                    classLoaderArray = parentLoaders;
                } else {
                    ClassLoader[] classLoaderArray2 = new ClassLoader[1];
                    classLoaderArray = classLoaderArray2;
                    classLoaderArray2[0] = parentLoader;
                }
                ClassLoader pluginClassLoader = PluginManagerCore.createPluginClassLoader(classPath.toArray(new File[classPath.size()]), classLoaderArray, pluginDescriptor);
                pluginDescriptor.setLoader(pluginClassLoader);
            }
            if (progress == null) continue;
            progress.showProgress("", 0.3f + (float)i++ / (float)result.size() * 0.35f);
        }
        PluginManagerCore.registerExtensionPointsAndExtensions(Extensions.getRootArea(), result);
        Extensions.getRootArea().getExtensionPoint(Extensions.AREA_LISTENER_EXTENSION_POINT).registerExtension(new AreaListener(){

            @Override
            public void areaCreated(@NotNull String areaClass, @NotNull AreaInstance areaInstance) {
                if (areaClass == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "areaClass", "com/intellij/ide/plugins/PluginManagerCore$10", "areaCreated"));
                }
                if (areaInstance == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "areaInstance", "com/intellij/ide/plugins/PluginManagerCore$10", "areaCreated"));
                }
                PluginManagerCore.registerExtensionPointsAndExtensions(Extensions.getArea(areaInstance), result);
            }

            @Override
            public void areaDisposing(@NotNull String areaClass, @NotNull AreaInstance areaInstance) {
                if (areaClass == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "areaClass", "com/intellij/ide/plugins/PluginManagerCore$10", "areaDisposing"));
                }
                if (areaInstance == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "areaInstance", "com/intellij/ide/plugins/PluginManagerCore$10", "areaDisposing"));
                }
            }
        });
        ourPlugins = pluginDescriptors;
    }

    public static void fixDescriptors(@NotNull IdeaPluginDescriptorImpl[] pluginDescriptors, @NotNull ClassLoader parentLoader, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> idToDescriptorMap, @NotNull Map<String, String> disabledPluginNames, @NotNull List<String> brokenPluginsList, @NotNull List<IdeaPluginDescriptorImpl> result, @NotNull List<String> errors) {
        if (pluginDescriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginDescriptors", "com/intellij/ide/plugins/PluginManagerCore", "fixDescriptors"));
        }
        if (parentLoader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentLoader", "com/intellij/ide/plugins/PluginManagerCore", "fixDescriptors"));
        }
        if (idToDescriptorMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "idToDescriptorMap", "com/intellij/ide/plugins/PluginManagerCore", "fixDescriptors"));
        }
        if (disabledPluginNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disabledPluginNames", "com/intellij/ide/plugins/PluginManagerCore", "fixDescriptors"));
        }
        if (brokenPluginsList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "brokenPluginsList", "com/intellij/ide/plugins/PluginManagerCore", "fixDescriptors"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/ide/plugins/PluginManagerCore", "fixDescriptors"));
        }
        if (errors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errors", "com/intellij/ide/plugins/PluginManagerCore", "fixDescriptors"));
        }
        PluginManagerCore.checkCanLoadPlugins(pluginDescriptors, parentLoader, disabledPluginNames, brokenPluginsList, result);
        PluginManagerCore.filterBadPlugins(result, disabledPluginNames, errors);
        if (!brokenPluginsList.isEmpty()) {
            errors.add("Following plugins are incompatible with current IDE build: " + StringUtil.join(brokenPluginsList, ", "));
        }
        PluginManagerCore.fixDependencies(result, idToDescriptorMap);
    }

    private static void checkCanLoadPlugins(@NotNull IdeaPluginDescriptorImpl[] pluginDescriptors, @NotNull ClassLoader parentLoader, @NotNull Map<String, String> disabledPluginNames, @NotNull List<String> brokenPluginsList, @NotNull List<IdeaPluginDescriptorImpl> result) {
        if (pluginDescriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginDescriptors", "com/intellij/ide/plugins/PluginManagerCore", "checkCanLoadPlugins"));
        }
        if (parentLoader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentLoader", "com/intellij/ide/plugins/PluginManagerCore", "checkCanLoadPlugins"));
        }
        if (disabledPluginNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disabledPluginNames", "com/intellij/ide/plugins/PluginManagerCore", "checkCanLoadPlugins"));
        }
        if (brokenPluginsList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "brokenPluginsList", "com/intellij/ide/plugins/PluginManagerCore", "checkCanLoadPlugins"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/ide/plugins/PluginManagerCore", "checkCanLoadPlugins"));
        }
        for (IdeaPluginDescriptorImpl descriptor : pluginDescriptors) {
            String toNotLoadReason = PluginManagerCore.detectReasonToNotLoad(descriptor, pluginDescriptors);
            if (toNotLoadReason == null && PluginManagerCore.isBrokenPlugin(descriptor)) {
                brokenPluginsList.add(descriptor.getName());
                toNotLoadReason = "This plugin version was marked as incompatible";
            }
            if (toNotLoadReason == null) {
                List<String> modules = descriptor.getModules();
                if (modules != null) {
                    for (String module : modules) {
                        if (ourModulesToContainingPlugins.containsKey(module)) continue;
                        ourModulesToContainingPlugins.put(module, descriptor);
                    }
                }
                result.add(descriptor);
                continue;
            }
            descriptor.setEnabled(false);
            PluginManagerCore.getLogger().info(String.format("Plugin '%s' can't be loaded because: %s", descriptor.getName(), toNotLoadReason));
            disabledPluginNames.put(descriptor.getPluginId().getIdString(), descriptor.getName());
            PluginManagerCore.initClassLoader(parentLoader, descriptor);
        }
    }

    private static void fixDependencies(@NotNull List<IdeaPluginDescriptorImpl> result, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> idToDescriptorMap) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/ide/plugins/PluginManagerCore", "fixDependencies"));
        }
        if (idToDescriptorMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "idToDescriptorMap", "com/intellij/ide/plugins/PluginManagerCore", "fixDependencies"));
        }
        for (IdeaPluginDescriptorImpl descriptor : result) {
            idToDescriptorMap.put(descriptor.getPluginId(), descriptor);
        }
        IdeaPluginDescriptor corePluginDescriptor = idToDescriptorMap.get(PluginId.getId(CORE_PLUGIN_ID));
        assert (corePluginDescriptor != null) : "com.intellij not found; platform prefix is " + System.getProperty("idea.platform.prefix");
        for (IdeaPluginDescriptorImpl descriptor : result) {
            if (descriptor == corePluginDescriptor) continue;
            descriptor.insertDependency(corePluginDescriptor);
        }
        PluginManagerCore.mergeOptionalConfigs(idToDescriptorMap);
        PluginManagerCore.addModulesAsDependents(idToDescriptorMap);
    }

    private static void registerExtensionPointsAndExtensions(@NotNull ExtensionsArea area, @NotNull List<IdeaPluginDescriptorImpl> loadedPlugins) {
        if (area == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "area", "com/intellij/ide/plugins/PluginManagerCore", "registerExtensionPointsAndExtensions"));
        }
        if (loadedPlugins == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loadedPlugins", "com/intellij/ide/plugins/PluginManagerCore", "registerExtensionPointsAndExtensions"));
        }
        for (IdeaPluginDescriptorImpl descriptor : loadedPlugins) {
            descriptor.registerExtensionPoints(area);
        }
        ExtensionPoint[] extensionPoints = area.getExtensionPoints();
        THashSet epNames = new THashSet(extensionPoints.length);
        for (ExtensionPoint point : extensionPoints) {
            epNames.add(point.getName());
        }
        for (IdeaPluginDescriptorImpl descriptor : loadedPlugins) {
            for (String epName : epNames) {
                descriptor.registerExtensions(area, epName);
            }
        }
    }

    public static void registerExtensionPointAndExtensions(@NotNull File pluginRoot, @NotNull String fileName, @NotNull ExtensionsArea area) {
        if (pluginRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginRoot", "com/intellij/ide/plugins/PluginManagerCore", "registerExtensionPointAndExtensions"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/ide/plugins/PluginManagerCore", "registerExtensionPointAndExtensions"));
        }
        if (area == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "area", "com/intellij/ide/plugins/PluginManagerCore", "registerExtensionPointAndExtensions"));
        }
        IdeaPluginDescriptorImpl descriptor = pluginRoot.isDirectory() ? PluginManagerCore.loadDescriptorFromDir(pluginRoot, fileName) : PluginManagerCore.loadDescriptorFromJar(pluginRoot, fileName);
        if (descriptor != null) {
            PluginManagerCore.registerExtensionPointsAndExtensions(area, Collections.singletonList(descriptor));
        } else {
            PluginManagerCore.getLogger().error("Cannot load " + fileName + " from " + pluginRoot);
        }
    }

    private static void initPlugins(@Nullable StartupProgress progress) {
        long start = System.currentTimeMillis();
        try {
            PluginManagerCore.initializePlugins(progress);
        }
        catch (RuntimeException e) {
            PluginManagerCore.getLogger().error(e);
            throw e;
        }
        PluginManagerCore.getLogger().info(ourPlugins.length + " plugins initialized in " + (System.currentTimeMillis() - start) + " ms");
        PluginManagerCore.logPlugins();
        ClassUtilCore.clearJarURLCache();
    }

    private static class IdeaLogProvider
    implements LogProvider {
        private IdeaLogProvider() {
        }

        @Override
        public void error(String message) {
            PluginManagerCore.getLogger().error(message);
        }

        @Override
        public void error(String message, Throwable t) {
            PluginManagerCore.getLogger().error(message, t);
        }

        @Override
        public void error(Throwable t) {
            PluginManagerCore.getLogger().error(t);
        }

        @Override
        public void warn(String message) {
            PluginManagerCore.getLogger().info(message);
        }

        @Override
        public void warn(String message, Throwable t) {
            PluginManagerCore.getLogger().info(message, t);
        }

        @Override
        public void warn(Throwable t) {
            PluginManagerCore.getLogger().info(t);
        }
    }

    private static class LoggerHolder {
        private static final Logger ourLogger = Logger.getInstance("#com.intellij.ide.plugins.PluginManager");

        private LoggerHolder() {
        }
    }

    private static class Holder {
        private static final BuildNumber ourBuildNumber = Holder.calcBuildNumber();

        private Holder() {
        }

        private static BuildNumber calcBuildNumber() {
            BuildNumber ourBuildNumber = BuildNumber.fromString(System.getProperty("idea.plugins.compatible.build"));
            if (ourBuildNumber == null) {
                BuildNumber buildNumber = ourBuildNumber = BUILD_NUMBER == null ? null : BuildNumber.fromString(BUILD_NUMBER);
                if (ourBuildNumber == null) {
                    ourBuildNumber = BuildNumber.currentVersion();
                }
            }
            return ourBuildNumber;
        }
    }
}

