/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.quickfix;

import com.intellij.codeInsight.daemon.QuickFixActionRegistrar;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.DumbService;
import com.intellij.psi.PsiReference;
import com.intellij.util.ReflectionUtil;
import org.jetbrains.annotations.NotNull;

public abstract class UnresolvedReferenceQuickFixProvider<T extends PsiReference> {
    private static final ExtensionPointName<UnresolvedReferenceQuickFixProvider> EXTENSION_NAME = ExtensionPointName.create("com.intellij.codeInsight.unresolvedReferenceQuickFixProvider");

    public static <T extends PsiReference> void registerReferenceFixes(@NotNull T ref, @NotNull QuickFixActionRegistrar registrar) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/codeInsight/quickfix/UnresolvedReferenceQuickFixProvider", "registerReferenceFixes"));
        }
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/codeInsight/quickfix/UnresolvedReferenceQuickFixProvider", "registerReferenceFixes"));
        }
        boolean dumb = DumbService.getInstance(ref.getElement().getProject()).isDumb();
        UnresolvedReferenceQuickFixProvider[] fixProviders = Extensions.getExtensions(EXTENSION_NAME);
        Class<?> referenceClass = ref.getClass();
        for (UnresolvedReferenceQuickFixProvider each : fixProviders) {
            if (dumb && !DumbService.isDumbAware(each) || !ReflectionUtil.isAssignable(each.getReferenceClass(), referenceClass)) continue;
            each.registerFixes(ref, registrar);
        }
    }

    public abstract void registerFixes(@NotNull T var1, @NotNull QuickFixActionRegistrar var2);

    @NotNull
    public abstract Class<T> getReferenceClass();
}

