/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.ChangeContextUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.RedundantLambdaCodeBlockInspection;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.RedundantCastUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.LinkedHashMap;
import com.intellij.util.text.UniqueNameGenerator;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnonymousCanBeLambdaInspection
extends BaseJavaBatchLocalInspectionTool {
    public static final Logger LOG = Logger.getInstance("#" + AnonymousCanBeLambdaInspection.class.getName());
    public boolean reportNotAnnotatedInterfaces = true;

    @Override
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.LANGUAGE_LEVEL_SPECIFIC_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/AnonymousCanBeLambdaInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Anonymous type can be replaced with lambda" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/AnonymousCanBeLambdaInspection", "getDisplayName"));
        }
        return "Anonymous type can be replaced with lambda";
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public String getShortName() {
        if ("Convert2Lambda" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/AnonymousCanBeLambdaInspection", "getShortName"));
        }
        return "Convert2Lambda";
    }

    @Override
    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel("Report when interface is not annotated with @FunctionalInterface", this, "reportNotAnnotatedInterfaces");
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/AnonymousCanBeLambdaInspection", "buildVisitor"));
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            @Override
            public void visitAnonymousClass(PsiAnonymousClass aClass) {
                PsiElement lambdaContext;
                super.visitAnonymousClass(aClass);
                PsiElement parent = aClass.getParent();
                PsiElement psiElement = lambdaContext = parent != null ? parent.getParent() : null;
                if (lambdaContext != null && (LambdaUtil.isValidLambdaContext(lambdaContext) || !(lambdaContext instanceof PsiExpressionStatement)) && AnonymousCanBeLambdaInspection.canBeConvertedToLambda(aClass, false, AnonymousCanBeLambdaInspection.this.reportNotAnnotatedInterfaces, Collections.emptySet())) {
                    PsiElement lBrace = aClass.getLBrace();
                    LOG.assertTrue(lBrace != null);
                    TextRange rangeInElement = new TextRange(0, aClass.getStartOffsetInParent() + lBrace.getStartOffsetInParent());
                    holder.registerProblem(parent, "Anonymous #ref #loc can be replaced with lambda", ProblemHighlightType.LIKE_UNUSED_SYMBOL, rangeInElement, new ReplaceWithLambdaFix());
                }
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/AnonymousCanBeLambdaInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    private static boolean hasRuntimeAnnotations(PsiMethod method, @NotNull Set<String> runtimeAnnotationsToIgnore) {
        PsiAnnotation[] annotations;
        if (runtimeAnnotationsToIgnore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runtimeAnnotationsToIgnore", "com/intellij/codeInspection/AnonymousCanBeLambdaInspection", "hasRuntimeAnnotations"));
        }
        for (PsiAnnotation annotation : annotations = method.getModifierList().getAnnotations()) {
            PsiClass containingClass;
            PsiElement resolved;
            PsiAnnotationMemberValue value;
            PsiAnnotation retentionAnno;
            PsiElement target;
            PsiJavaCodeReferenceElement ref = annotation.getNameReferenceElement();
            PsiElement psiElement = target = ref != null ? ref.resolve() : null;
            if (!(target instanceof PsiClass) || runtimeAnnotationsToIgnore.contains(((PsiClass)target).getQualifiedName()) || (retentionAnno = AnnotationUtil.findAnnotation((PsiModifierListOwner)((PsiClass)target), Retention.class.getName())) == null || !((value = retentionAnno.findAttributeValue("value")) instanceof PsiReferenceExpression) || !((resolved = ((PsiReferenceExpression)value).resolve()) instanceof PsiField) || !RetentionPolicy.RUNTIME.name().equals(((PsiField)resolved).getName()) || (containingClass = ((PsiField)resolved).getContainingClass()) == null || !RetentionPolicy.class.getName().equals(containingClass.getQualifiedName())) continue;
            return true;
        }
        return false;
    }

    public static boolean hasForbiddenRefsInsideBody(PsiMethod method, PsiAnonymousClass aClass) {
        PsiType inferredType = AnonymousCanBeLambdaInspection.getInferredType(aClass, method);
        if (inferredType == null) {
            return true;
        }
        PsiType inferenceMethodReturnType = LambdaUtil.getFunctionalInterfaceReturnType(inferredType);
        PsiType existingMethodReturnType = method.getReturnType();
        if (existingMethodReturnType == null || inferenceMethodReturnType != null && !PsiType.VOID.equals(inferenceMethodReturnType) && !TypeConversionUtil.isAssignable(existingMethodReturnType, inferenceMethodReturnType)) {
            return true;
        }
        ForbiddenRefsChecker checker = new ForbiddenRefsChecker(method, aClass, inferredType != PsiType.NULL ? inferredType : null);
        PsiCodeBlock body = method.getBody();
        LOG.assertTrue(body != null);
        body.accept(checker);
        return checker.hasForbiddenRefs();
    }

    private static PsiType getInferredType(PsiAnonymousClass aClass, PsiMethod method) {
        PsiExpression expression = (PsiExpression)aClass.getParent();
        PsiType psiType = PsiTypesUtil.getExpectedTypeByParent(expression);
        if (psiType != null) {
            return psiType;
        }
        PsiExpression topExpr = expression;
        while (topExpr.getParent() instanceof PsiParenthesizedExpression) {
            topExpr = (PsiExpression)topExpr.getParent();
        }
        PsiCall call = LambdaUtil.treeWalkUp(topExpr);
        if (call != null && call.resolveMethod() != null) {
            int offsetInTopCall = aClass.getTextRange().getStartOffset() - call.getTextRange().getStartOffset();
            PsiCall copyCall = LambdaUtil.copyTopLevelCall(call);
            if (copyCall == null) {
                return null;
            }
            PsiAnonymousClass classArg = PsiTreeUtil.getParentOfType(copyCall.findElementAt(offsetInTopCall), PsiAnonymousClass.class);
            if (classArg != null) {
                PsiExpression lambda = JavaPsiFacade.getElementFactory(aClass.getProject()).createExpressionFromText(ReplaceWithLambdaFix.composeLambdaText(method), expression);
                lambda = (PsiExpression)classArg.getParent().replace(lambda);
                ((PsiLambdaExpression)lambda).getBody().replace(method.getBody());
                PsiType interfaceType = copyCall.resolveMethod() == null ? null : ((PsiLambdaExpression)lambda).getFunctionalInterfaceType();
                return interfaceType;
            }
        }
        return PsiType.NULL;
    }

    public static boolean canBeConvertedToLambda(PsiAnonymousClass aClass, boolean acceptParameterizedFunctionTypes, @NotNull Set<String> ignoredRuntimeAnnotations) {
        if (ignoredRuntimeAnnotations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ignoredRuntimeAnnotations", "com/intellij/codeInspection/AnonymousCanBeLambdaInspection", "canBeConvertedToLambda"));
        }
        return AnonymousCanBeLambdaInspection.canBeConvertedToLambda(aClass, acceptParameterizedFunctionTypes, true, ignoredRuntimeAnnotations);
    }

    public static boolean canBeConvertedToLambda(PsiAnonymousClass aClass, boolean acceptParameterizedFunctionTypes, boolean reportNotAnnotatedInterfaces, @NotNull Set<String> ignoredRuntimeAnnotations) {
        if (ignoredRuntimeAnnotations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ignoredRuntimeAnnotations", "com/intellij/codeInspection/AnonymousCanBeLambdaInspection", "canBeConvertedToLambda"));
        }
        if (PsiUtil.getLanguageLevel(aClass).isAtLeast(LanguageLevel.JDK_1_8)) {
            PsiMethod[] methods;
            PsiClassType baseClassType = aClass.getBaseClassType();
            PsiClassType.ClassResolveResult resolveResult = baseClassType.resolveGenerics();
            PsiClass baseClass = resolveResult.getElement();
            if (baseClass == null || !reportNotAnnotatedInterfaces && !AnnotationUtil.isAnnotated((PsiModifierListOwner)baseClass, "java.lang.FunctionalInterface", false)) {
                return false;
            }
            PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(resolveResult);
            if (interfaceMethod != null && (acceptParameterizedFunctionTypes || !interfaceMethod.hasTypeParameters()) && (methods = aClass.getMethods()).length == 1 && aClass.getFields().length == 0 && aClass.getInnerClasses().length == 0 && aClass.getInitializers().length == 0) {
                PsiMethod method = methods[0];
                return method.getBody() != null && !AnonymousCanBeLambdaInspection.hasForbiddenRefsInsideBody(method, aClass) && !AnonymousCanBeLambdaInspection.hasRuntimeAnnotations(method, ignoredRuntimeAnnotations) && !method.hasModifierProperty("synchronized");
            }
        }
        return false;
    }

    public static PsiExpression replaceAnonymousWithLambda(@NotNull PsiElement anonymousClass, PsiType expectedType) {
        if (anonymousClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anonymousClass", "com/intellij/codeInspection/AnonymousCanBeLambdaInspection", "replaceAnonymousWithLambda"));
        }
        PsiNewExpression newArrayExpression = (PsiNewExpression)JavaPsiFacade.getElementFactory(anonymousClass.getProject()).createExpressionFromText("new " + expectedType.getCanonicalText() + "[]{" + anonymousClass.getText() + "}", anonymousClass);
        PsiArrayInitializerExpression initializer = newArrayExpression.getArrayInitializer();
        LOG.assertTrue(initializer != null);
        return AnonymousCanBeLambdaInspection.replacePsiElementWithLambda(initializer.getInitializers()[0], true, false);
    }

    public static PsiExpression replacePsiElementWithLambda(@NotNull PsiElement element, boolean ignoreEqualsMethod, boolean forceIgnoreTypeCast) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/AnonymousCanBeLambdaInspection", "replacePsiElementWithLambda"));
        }
        if (element instanceof PsiNewExpression) {
            String withoutTypesDeclared;
            PsiMethod method;
            if (!FileModificationService.getInstance().preparePsiElementForWrite(element)) {
                return null;
            }
            PsiAnonymousClass anonymousClass = ((PsiNewExpression)element).getAnonymousClass();
            if (anonymousClass == null) {
                return null;
            }
            ChangeContextUtil.encodeContextInfo(anonymousClass, true);
            String canonicalText = anonymousClass.getBaseClassType().getCanonicalText();
            if (ignoreEqualsMethod) {
                List<PsiMethod> methods = ContainerUtil.filter(anonymousClass.getMethods(), method1 -> !"equals".equals(method1.getName()));
                method = methods.get(0);
            } else {
                method = anonymousClass.getMethods()[0];
            }
            if (method == null) {
                return null;
            }
            PsiCodeBlock body = method.getBody();
            if (body == null) {
                return null;
            }
            Project project = element.getProject();
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory(project);
            PsiLambdaExpression lambdaExpression = (PsiLambdaExpression)elementFactory.createExpressionFromText(withoutTypesDeclared = ReplaceWithLambdaFix.composeLambdaText(method), anonymousClass);
            PsiElement lambdaBody = lambdaExpression.getBody();
            LOG.assertTrue(lambdaBody != null);
            lambdaBody.replace(body);
            PsiNewExpression newExpression = (PsiNewExpression)anonymousClass.getParent();
            lambdaExpression = (PsiLambdaExpression)newExpression.replace(lambdaExpression);
            HashSet<PsiVariable> variables = new HashSet<PsiVariable>();
            HashSet<String> usedLocalNames = new HashSet<String>();
            AnonymousCanBeLambdaInspection.collectLocalVariablesDefinedInsideLambda(lambdaExpression, variables, usedLocalNames);
            ReplaceWithLambdaFix.giveUniqueNames(project, elementFactory, lambdaExpression, usedLocalNames, variables.toArray(new PsiVariable[variables.size()]));
            PsiExpression singleExpr = RedundantLambdaCodeBlockInspection.isCodeBlockRedundant(lambdaExpression, lambdaExpression.getBody());
            if (singleExpr != null) {
                lambdaExpression.getBody().replace(singleExpr);
            }
            ChangeContextUtil.decodeContextInfo(lambdaExpression, null, null);
            JavaCodeStyleManager javaCodeStyleManager = JavaCodeStyleManager.getInstance(project);
            if (forceIgnoreTypeCast) {
                return (PsiExpression)javaCodeStyleManager.shortenClassReferences(lambdaExpression);
            }
            PsiTypeCastExpression typeCast = (PsiTypeCastExpression)elementFactory.createExpressionFromText("(" + canonicalText + ")" + withoutTypesDeclared, lambdaExpression);
            PsiExpression typeCastOperand = typeCast.getOperand();
            LOG.assertTrue(typeCastOperand instanceof PsiLambdaExpression);
            PsiElement fromText = ((PsiLambdaExpression)typeCastOperand).getBody();
            LOG.assertTrue(fromText != null);
            lambdaBody = lambdaExpression.getBody();
            LOG.assertTrue(lambdaBody != null);
            fromText.replace(lambdaBody);
            ((PsiLambdaExpression)typeCastOperand).getParameterList().replace(lambdaExpression.getParameterList());
            typeCast = (PsiTypeCastExpression)lambdaExpression.replace(typeCast);
            if (RedundantCastUtil.isCastRedundant(typeCast)) {
                PsiExpression operand = typeCast.getOperand();
                LOG.assertTrue(operand != null);
                return (PsiExpression)typeCast.replace(operand);
            }
            return (PsiExpression)javaCodeStyleManager.shortenClassReferences(typeCast);
        }
        return null;
    }

    private static void collectLocalVariablesDefinedInsideLambda(PsiLambdaExpression lambdaExpression, final Set<PsiVariable> variables, Set<String> namesOfVariablesInTheBlock) {
        PsiElement block = PsiUtil.getTopLevelEnclosingCodeBlock(lambdaExpression, null);
        if (block == null) {
            block = lambdaExpression;
        }
        block.accept(new JavaRecursiveElementWalkingVisitor(){

            @Override
            public void visitVariable(PsiVariable variable) {
                super.visitVariable(variable);
                if (!(variable instanceof PsiField)) {
                    variables.add(variable);
                }
            }
        });
        PsiResolveHelper helper = PsiResolveHelper.SERVICE.getInstance(lambdaExpression.getProject());
        Iterator<PsiVariable> iterator = variables.iterator();
        while (iterator.hasNext()) {
            PsiVariable local = iterator.next();
            String localName = local.getName();
            if (localName != null && helper.resolveReferencedVariable(localName, lambdaExpression) != null && PsiTreeUtil.isAncestor(lambdaExpression, local, false)) continue;
            iterator.remove();
            namesOfVariablesInTheBlock.add(localName);
        }
    }

    public static boolean functionalInterfaceMethodReferenced(PsiMethod psiMethod, PsiAnonymousClass anonymClass, PsiCallExpression callExpression) {
        if (psiMethod != null && !psiMethod.hasModifierProperty("static")) {
            PsiClass containingClass = psiMethod.getContainingClass();
            if (containingClass != null && "java.lang.Object".equals(containingClass.getQualifiedName())) {
                return false;
            }
            if (callExpression instanceof PsiMethodCallExpression && ((PsiMethodCallExpression)callExpression).getMethodExpression().isQualified()) {
                return false;
            }
            if (InheritanceUtil.isInheritorOrSelf(anonymClass, containingClass, true) && !InheritanceUtil.hasEnclosingInstanceInScope(containingClass, anonymClass.getParent(), true, true)) {
                return true;
            }
        }
        return false;
    }

    private static class ForbiddenRefsChecker
    extends JavaRecursiveElementWalkingVisitor {
        private boolean myBodyContainsForbiddenRefs;
        private final PsiMethod myMethod;
        private final PsiAnonymousClass myAnonymClass;
        private final PsiType myInferredType;

        public ForbiddenRefsChecker(PsiMethod method, PsiAnonymousClass aClass, PsiType inferredType) {
            this.myMethod = method;
            this.myAnonymClass = aClass;
            PsiClassType baseClassType = aClass.getBaseClassType();
            this.myInferredType = !baseClassType.equals(inferredType) ? inferredType : null;
        }

        @Override
        public void visitMethodCallExpression(PsiMethodCallExpression methodCallExpression) {
            if (this.myBodyContainsForbiddenRefs) {
                return;
            }
            super.visitMethodCallExpression(methodCallExpression);
            PsiMethod psiMethod = methodCallExpression.resolveMethod();
            if (psiMethod == this.myMethod || AnonymousCanBeLambdaInspection.functionalInterfaceMethodReferenced(psiMethod, this.myAnonymClass, methodCallExpression) || psiMethod != null && !methodCallExpression.getMethodExpression().isQualified() && "getClass".equals(psiMethod.getName()) && psiMethod.getParameterList().getParametersCount() == 0) {
                this.myBodyContainsForbiddenRefs = true;
            }
        }

        @Override
        public void visitThisExpression(PsiThisExpression expression) {
            if (this.myBodyContainsForbiddenRefs) {
                return;
            }
            if (expression.getQualifier() == null) {
                this.myBodyContainsForbiddenRefs = true;
            }
        }

        @Override
        public void visitSuperExpression(PsiSuperExpression expression) {
            if (this.myBodyContainsForbiddenRefs) {
                return;
            }
            if (expression.getQualifier() == null) {
                this.myBodyContainsForbiddenRefs = true;
            }
        }

        @Override
        public void visitVariable(PsiVariable variable) {
            if (this.myBodyContainsForbiddenRefs) {
                return;
            }
            super.visitVariable(variable);
        }

        @Override
        public void visitReferenceExpression(PsiReferenceExpression expression) {
            PsiElement resolved;
            if (this.myBodyContainsForbiddenRefs) {
                return;
            }
            super.visitReferenceExpression(expression);
            if (!(expression.getParent() instanceof PsiMethodCallExpression)) {
                PsiMember member = PsiTreeUtil.getParentOfType((PsiElement)this.myAnonymClass, PsiMember.class);
                if (member instanceof PsiField || member instanceof PsiClassInitializer) {
                    PsiExpression initializer;
                    PsiElement resolved2 = expression.resolve();
                    PsiClass memberContainingClass = member.getContainingClass();
                    if (resolved2 instanceof PsiField && memberContainingClass != null && PsiTreeUtil.isAncestor(((PsiField)resolved2).getContainingClass(), memberContainingClass, false) && expression.getQualifierExpression() == null && ((initializer = ((PsiField)resolved2).getInitializer()) == null || resolved2 == member || initializer.getTextOffset() > this.myAnonymClass.getTextOffset() && ((PsiField)resolved2).hasModifierProperty("static") == member.hasModifierProperty("static"))) {
                        this.myBodyContainsForbiddenRefs = true;
                        return;
                    }
                } else {
                    PsiElement resolved3;
                    PsiMethod method = PsiTreeUtil.getParentOfType((PsiElement)this.myAnonymClass, PsiMethod.class);
                    if (method != null && method.isConstructor() && (resolved3 = expression.resolve()) instanceof PsiField && ((PsiField)resolved3).hasModifierProperty("final") && ((PsiField)resolved3).getInitializer() == null && ((PsiField)resolved3).getContainingClass() == method.getContainingClass()) {
                        try {
                            int startOffset;
                            ControlFlow flow;
                            Collection<PsiVariable> writtenVariables;
                            PsiCodeBlock constructorBody = method.getBody();
                            if (constructorBody != null && !(writtenVariables = ControlFlowUtil.getWrittenVariables(flow = HighlightControlFlowUtil.getControlFlowNoConstantEvaluate(constructorBody), 0, startOffset = flow.getStartOffset(this.myAnonymClass), false)).contains(resolved3)) {
                                this.myBodyContainsForbiddenRefs = true;
                                return;
                            }
                        }
                        catch (AnalysisCanceledException e) {
                            this.myBodyContainsForbiddenRefs = true;
                            return;
                        }
                    }
                }
            }
            if (this.myInferredType != null && (resolved = expression.resolve()) instanceof PsiParameter && ((PsiParameter)resolved).getDeclarationScope() == this.myMethod) {
                if (!(this.myInferredType instanceof PsiClassType)) {
                    this.myBodyContainsForbiddenRefs = true;
                    return;
                }
                int parameterIndex = this.myMethod.getParameterList().getParameterIndex((PsiParameter)resolved);
                for (PsiMethod superMethod : this.myMethod.findDeepestSuperMethods()) {
                    PsiType paramType = superMethod.getParameterList().getParameters()[parameterIndex].getType();
                    PsiClass superClass = superMethod.getContainingClass();
                    if (superClass == null) continue;
                    PsiClassType.ClassResolveResult classResolveResult = ((PsiClassType)this.myInferredType).resolveGenerics();
                    PsiClass classCandidate = classResolveResult.getElement();
                    if (classCandidate == null) {
                        this.myBodyContainsForbiddenRefs = true;
                        return;
                    }
                    PsiSubstitutor inferredSubstitutor = TypeConversionUtil.getClassSubstitutor(superClass, classCandidate, classResolveResult.getSubstitutor());
                    PsiSubstitutor substitutor = TypeConversionUtil.getSuperClassSubstitutor(superClass, this.myAnonymClass.getBaseClassType());
                    if (inferredSubstitutor == null || Comparing.equal(inferredSubstitutor.substitute(paramType), substitutor.substitute(paramType))) continue;
                    this.myBodyContainsForbiddenRefs = true;
                    return;
                }
            }
        }

        public boolean hasForbiddenRefs() {
            return this.myBodyContainsForbiddenRefs;
        }
    }

    private static class ReplaceWithLambdaFix
    implements LocalQuickFix,
    HighPriorityAction {
        private ReplaceWithLambdaFix() {
        }

        @Override
        @NotNull
        public String getName() {
            if ("Replace with lambda" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/AnonymousCanBeLambdaInspection$ReplaceWithLambdaFix", "getName"));
            }
            return "Replace with lambda";
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/AnonymousCanBeLambdaInspection$ReplaceWithLambdaFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/AnonymousCanBeLambdaInspection$ReplaceWithLambdaFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/AnonymousCanBeLambdaInspection$ReplaceWithLambdaFix", "applyFix"));
            }
            PsiElement element = descriptor.getPsiElement();
            if (element != null) {
                AnonymousCanBeLambdaInspection.replacePsiElementWithLambda(element, false, false);
            }
        }

        private static void giveUniqueNames(Project project, final PsiElementFactory elementFactory, PsiElement body, Set<String> usedLocalNames, PsiVariable[] parameters) {
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance(project);
            final HashMap<PsiVariable, String> names = new HashMap<PsiVariable, String>();
            for (PsiVariable parameter : parameters) {
                String uniqueVariableName;
                String parameterName = parameter.getName();
                if (Comparing.equal(parameterName, uniqueVariableName = UniqueNameGenerator.generateUniqueName(codeStyleManager.suggestUniqueVariableName(parameterName, parameter.getParent(), false), usedLocalNames))) continue;
                names.put(parameter, uniqueVariableName);
            }
            if (names.isEmpty()) {
                return;
            }
            final LinkedHashMap replacements = new LinkedHashMap();
            body.accept(new JavaRecursiveElementWalkingVisitor(){

                @Override
                public void visitVariable(PsiVariable variable) {
                    super.visitVariable(variable);
                    String newName = (String)names.get(variable);
                    if (newName != null) {
                        replacements.put(variable.getNameIdentifier(), elementFactory.createIdentifier(newName));
                    }
                }

                @Override
                public void visitReferenceExpression(PsiReferenceExpression expression) {
                    String newName;
                    super.visitReferenceExpression(expression);
                    PsiElement resolve = expression.resolve();
                    if (resolve instanceof PsiVariable && (newName = (String)names.get(resolve)) != null) {
                        replacements.put(expression, elementFactory.createExpressionFromText(newName, expression));
                    }
                }
            });
            for (PsiElement psiElement : replacements.keySet()) {
                psiElement.replace((PsiElement)replacements.get(psiElement));
            }
        }

        private static String composeLambdaText(PsiMethod method) {
            StringBuilder buf = new StringBuilder();
            PsiParameter[] parameters = method.getParameterList().getParameters();
            if (parameters.length != 1) {
                buf.append("(");
            }
            buf.append(StringUtil.join(parameters, ReplaceWithLambdaFix::composeParameter, ","));
            if (parameters.length != 1) {
                buf.append(")");
            }
            buf.append("-> {}");
            return buf.toString();
        }

        private static String composeParameter(PsiParameter parameter) {
            String parameterName = parameter.getName();
            if (parameterName == null) {
                parameterName = "";
            }
            return parameterName;
        }
    }
}

