/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.ContainerBasedSuppressQuickFix;
import com.intellij.codeInspection.InjectionAwareSuppressQuickFix;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;

public class SuppressIntentionActionFromFix
extends SuppressIntentionAction {
    private final SuppressQuickFix myFix;

    private SuppressIntentionActionFromFix(@NotNull SuppressQuickFix fix) {
        if (fix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fix", "com/intellij/codeInspection/SuppressIntentionActionFromFix", "<init>"));
        }
        this.myFix = fix;
    }

    @NotNull
    public static SuppressIntentionAction convertBatchToSuppressIntentionAction(@NotNull SuppressQuickFix fix) {
        if (fix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fix", "com/intellij/codeInspection/SuppressIntentionActionFromFix", "convertBatchToSuppressIntentionAction"));
        }
        SuppressIntentionActionFromFix suppressIntentionActionFromFix = new SuppressIntentionActionFromFix(fix);
        if (suppressIntentionActionFromFix == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SuppressIntentionActionFromFix", "convertBatchToSuppressIntentionAction"));
        }
        return suppressIntentionActionFromFix;
    }

    @NotNull
    public static SuppressIntentionAction[] convertBatchToSuppressIntentionActions(@NotNull SuppressQuickFix[] actions) {
        if (actions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actions", "com/intellij/codeInspection/SuppressIntentionActionFromFix", "convertBatchToSuppressIntentionActions"));
        }
        SuppressIntentionAction[] suppressIntentionActionArray = ContainerUtil.map2Array(actions, SuppressIntentionAction.class, new Function<SuppressQuickFix, SuppressIntentionAction>(){

            @Override
            public SuppressIntentionAction fun(SuppressQuickFix fix) {
                return SuppressIntentionActionFromFix.convertBatchToSuppressIntentionAction(fix);
            }
        });
        if (suppressIntentionActionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SuppressIntentionActionFromFix", "convertBatchToSuppressIntentionActions"));
        }
        return suppressIntentionActionArray;
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/SuppressIntentionActionFromFix", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/SuppressIntentionActionFromFix", "invoke"));
        }
        PsiElement container = this.getContainer(element);
        boolean caretWasBeforeStatement = editor != null && container != null && editor.getCaretModel().getOffset() == container.getTextRange().getStartOffset();
        InspectionManager inspectionManager = InspectionManager.getInstance(project);
        ProblemDescriptor descriptor = inspectionManager.createProblemDescriptor(element, element, "", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false, new LocalQuickFix[0]);
        this.myFix.applyFix(project, descriptor);
        if (caretWasBeforeStatement) {
            editor.getCaretModel().moveToOffset(container.getTextRange().getStartOffset());
        }
    }

    public ThreeState isShouldBeAppliedToInjectionHost() {
        return this.myFix instanceof InjectionAwareSuppressQuickFix ? ((InjectionAwareSuppressQuickFix)this.myFix).isShouldBeAppliedToInjectionHost() : ThreeState.UNSURE;
    }

    public PsiElement getContainer(PsiElement element) {
        return this.myFix instanceof ContainerBasedSuppressQuickFix ? ((ContainerBasedSuppressQuickFix)this.myFix).getContainer(element) : null;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/SuppressIntentionActionFromFix", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/SuppressIntentionActionFromFix", "isAvailable"));
        }
        return this.myFix.isAvailable(project, element);
    }

    @Override
    @NotNull
    public String getText() {
        String string = this.myFix.getName() + (this.isShouldBeAppliedToInjectionHost() == ThreeState.NO ? " in injection" : "");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SuppressIntentionActionFromFix", "getText"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = this.myFix.getFamilyName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SuppressIntentionActionFromFix", "getFamilyName"));
        }
        return string;
    }

    @Override
    public boolean isSuppressAll() {
        return this.myFix.isSuppressAll();
    }
}

