/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.impl.java.stubs.index.JavaAnonymousClassBaseRefOccurenceIndex;
import com.intellij.psi.impl.java.stubs.index.JavaSuperClassNameOccurenceIndex;
import com.intellij.psi.impl.search.HighlightingCaches;
import com.intellij.psi.impl.search.JavaClassInheritorsSearcher;
import com.intellij.psi.impl.search.MethodUsagesSearcher;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AllClassesSearch;
import com.intellij.psi.search.searches.DirectClassInheritorsSearch;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicIntegerArray;
import org.jetbrains.annotations.NotNull;

public class JavaDirectInheritorsSearcher
implements QueryExecutor<PsiClass, DirectClassInheritorsSearch.SearchParameters> {
    private static final int INHERITANCE_UNKNOWN = 0;
    private static final int INHERITANCE_YES = 1;
    private static final int INHERITANCE_NO = 2;

    @Override
    public boolean execute(@NotNull DirectClassInheritorsSearch.SearchParameters parameters, @NotNull Processor<PsiClass> consumer) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "execute"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "execute"));
        }
        PsiClass baseClass = parameters.getClassToProcess();
        SearchScope useScope = ApplicationManager.getApplication().runReadAction(baseClass::getUseScope);
        Project project = PsiUtilCore.getProjectInReadAction(baseClass);
        if (JavaClassInheritorsSearcher.isJavaLangObject(baseClass)) {
            return AllClassesSearch.search(useScope, project).forEach(psiClass -> {
                if (consumer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "lambda$execute$0"));
                }
                ProgressManager.checkCanceled();
                if (psiClass.isInterface()) {
                    return consumer.process((PsiClass)psiClass);
                }
                PsiClass superClass = psiClass.getSuperClass();
                return superClass == null || !JavaClassInheritorsSearcher.isJavaLangObject(superClass) || consumer.process((PsiClass)psiClass);
            });
        }
        SearchScope scope = parameters.getScope();
        Pair<List<PsiClass>, AtomicIntegerArray> pair = JavaDirectInheritorsSearcher.getOrCalculateDirectSubClasses(project, baseClass);
        List<PsiClass> result = pair.getFirst();
        AtomicIntegerArray isInheritorFlag = pair.getSecond();
        if (result.isEmpty()) {
            return true;
        }
        VirtualFile jarFile = JavaDirectInheritorsSearcher.getJarFile(baseClass);
        int groupStart = 0;
        boolean sameJarClassFound = false;
        for (int i = 0; i < result.size(); ++i) {
            ProgressManager.checkCanceled();
            PsiClass subClass = result.get(i);
            if (subClass instanceof PsiAnonymousClass) {
                if (!parameters.includeAnonymous()) {
                    return true;
                }
                while (i < result.size()) {
                    ProgressManager.checkCanceled();
                    subClass = result.get(i);
                    CheckResult checkResult = JavaDirectInheritorsSearcher.checkAndProcessCandidate(scope, subClass, parameters, baseClass, project, isInheritorFlag, i, consumer);
                    if (checkResult == CheckResult.PROCESSED_ABORT) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            if (subClass == PsiUtil.NULL_PSI_CLASS) {
                if (!sameJarClassFound) {
                    for (int g = groupStart; g < i; ++g) {
                        ProgressManager.checkCanceled();
                        subClass = result.get(g);
                        CheckResult checkResult = JavaDirectInheritorsSearcher.checkAndProcessCandidate(scope, subClass, parameters, baseClass, project, isInheritorFlag, g, consumer);
                        if (checkResult != CheckResult.PROCESSED_ABORT) continue;
                        return false;
                    }
                }
                groupStart = i + 1;
                sameJarClassFound = false;
                continue;
            }
            VirtualFile currentJarFile = JavaDirectInheritorsSearcher.getJarFile(subClass);
            boolean fromSameJar = Comparing.equal(currentJarFile, jarFile);
            if (!fromSameJar) continue;
            CheckResult checkResult = JavaDirectInheritorsSearcher.checkAndProcessCandidate(scope, subClass, parameters, baseClass, project, isInheritorFlag, i, consumer);
            if (checkResult == CheckResult.PROCESSED_ABORT) {
                return false;
            }
            if (checkResult == CheckResult.CANDIDATE_REJECTED) continue;
            sameJarClassFound = true;
        }
        return true;
    }

    @NotNull
    private static CheckResult checkAndProcessCandidate(@NotNull SearchScope scope, @NotNull PsiClass candidate, @NotNull DirectClassInheritorsSearch.SearchParameters parameters, @NotNull PsiClass baseClass, @NotNull Project project, @NotNull AtomicIntegerArray isInheritorFlag, int i, @NotNull Processor<PsiClass> consumer) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "checkAndProcessCandidate"));
        }
        if (candidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "checkAndProcessCandidate"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "checkAndProcessCandidate"));
        }
        if (baseClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "checkAndProcessCandidate"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "checkAndProcessCandidate"));
        }
        if (isInheritorFlag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isInheritorFlag", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "checkAndProcessCandidate"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "checkAndProcessCandidate"));
        }
        if (!JavaDirectInheritorsSearcher.isInScope(scope, candidate)) {
            CheckResult checkResult = CheckResult.CANDIDATE_REJECTED;
            if (checkResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "checkAndProcessCandidate"));
            }
            return checkResult;
        }
        if (!JavaDirectInheritorsSearcher.checkInheritance(parameters.isCheckInheritance(), baseClass, candidate, project, isInheritorFlag, i)) {
            CheckResult checkResult = CheckResult.CANDIDATE_REJECTED;
            if (checkResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "checkAndProcessCandidate"));
            }
            return checkResult;
        }
        CheckResult checkResult = consumer.process(candidate) ? CheckResult.PROCESSED_OK : CheckResult.PROCESSED_ABORT;
        if (checkResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "checkAndProcessCandidate"));
        }
        return checkResult;
    }

    private static boolean isInScope(@NotNull SearchScope scope, @NotNull PsiClass subClass) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "isInScope"));
        }
        if (subClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subClass", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "isInScope"));
        }
        return ApplicationManager.getApplication().runReadAction(() -> {
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "lambda$isInScope$1"));
            }
            if (subClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subClass", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "lambda$isInScope$1"));
            }
            return PsiSearchScopeUtil.isInScope(scope, (PsiElement)subClass);
        });
    }

    @NotNull
    private static Pair<List<PsiClass>, AtomicIntegerArray> getOrCalculateDirectSubClasses(@NotNull Project project, @NotNull PsiClass baseClass) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "getOrCalculateDirectSubClasses"));
        }
        if (baseClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "getOrCalculateDirectSubClasses"));
        }
        Pair<List<PsiClass>, AtomicIntegerArray> cached = HighlightingCaches.getInstance((Project)project).DIRECT_SUB_CLASSES.get(baseClass);
        if (cached != null) {
            Pair<List<PsiClass>, AtomicIntegerArray> pair = cached;
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "getOrCalculateDirectSubClasses"));
            }
            return pair;
        }
        String baseClassName = ApplicationManager.getApplication().runReadAction(baseClass::getName);
        if (StringUtil.isEmpty(baseClassName)) {
            Pair<List<PsiClass>, AtomicIntegerArray> pair = Pair.create(Collections.emptyList(), new AtomicIntegerArray(0));
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "getOrCalculateDirectSubClasses"));
            }
            return pair;
        }
        Pair<List<PsiClass>, AtomicIntegerArray> pair = JavaDirectInheritorsSearcher.calculateDirectSubClasses(project, baseClass, baseClassName);
        HighlightingCaches.getInstance((Project)project).DIRECT_SUB_CLASSES.put(baseClass, pair);
        Pair<List<PsiClass>, AtomicIntegerArray> pair2 = pair;
        if (pair2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "getOrCalculateDirectSubClasses"));
        }
        return pair2;
    }

    @NotNull
    private static Pair<List<PsiClass>, AtomicIntegerArray> calculateDirectSubClasses(@NotNull Project project, @NotNull PsiClass baseClass, @NotNull String baseClassName) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "calculateDirectSubClasses"));
        }
        if (baseClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "calculateDirectSubClasses"));
        }
        if (baseClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClassName", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "calculateDirectSubClasses"));
        }
        GlobalSearchScope allScope = GlobalSearchScope.allScope(project);
        Collection candidates = MethodUsagesSearcher.resolveInReadAction(project, () -> {
            if (baseClassName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClassName", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "lambda$calculateDirectSubClasses$2"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "lambda$calculateDirectSubClasses$2"));
            }
            return JavaSuperClassNameOccurenceIndex.getInstance().get(baseClassName, project, allScope);
        });
        HashMap<String, SmartList<Object>> classes = new HashMap<String, SmartList<Object>>();
        int count = 0;
        for (PsiReferenceList referenceList : candidates) {
            ProgressManager.checkCanceled();
            PsiClass candidate = (PsiClass)ApplicationManager.getApplication().runReadAction(referenceList::getParent);
            String string = ApplicationManager.getApplication().runReadAction(candidate::getQualifiedName);
            SmartList<Object> list = (SmartList<Object>)classes.get(string);
            if (list == null) {
                list = new SmartList<Object>();
                classes.put(string, list);
            }
            list.add(candidate);
            ++count;
        }
        Collection anonymousCandidates = MethodUsagesSearcher.resolveInReadAction(project, () -> {
            if (baseClassName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClassName", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "lambda$calculateDirectSubClasses$3"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "lambda$calculateDirectSubClasses$3"));
            }
            return JavaAnonymousClassBaseRefOccurenceIndex.getInstance().get(baseClassName, project, allScope);
        });
        ArrayList<PsiClass> result = new ArrayList<PsiClass>(count + classes.size() + anonymousCandidates.size() + 1);
        for (Map.Entry entry : classes.entrySet()) {
            result.addAll((Collection)entry.getValue());
            result.add(PsiUtil.NULL_PSI_CLASS);
        }
        result.addAll(anonymousCandidates);
        boolean isEnum = ApplicationManager.getApplication().runReadAction(baseClass::isEnum);
        if (isEnum) {
            PsiField[] psiFieldArray;
            for (PsiField field : psiFieldArray = ApplicationManager.getApplication().runReadAction(baseClass::getFields)) {
                ProgressManager.checkCanceled();
                if (!(field instanceof PsiEnumConstant)) continue;
                PsiEnumConstantInitializer initializingClass = ApplicationManager.getApplication().runReadAction(((PsiEnumConstant)field)::getInitializingClass);
                if (initializingClass == null) continue;
                result.add(initializingClass);
            }
        }
        Pair<List<PsiClass>, AtomicIntegerArray> pair = Pair.create(result, new AtomicIntegerArray(result.size()));
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "calculateDirectSubClasses"));
        }
        return pair;
    }

    private static boolean checkInheritance(boolean checkInheritance, @NotNull PsiClass baseClass, @NotNull PsiClass candidate, @NotNull Project project, @NotNull AtomicIntegerArray isInheritorFlags, int i) {
        if (baseClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "checkInheritance"));
        }
        if (candidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "checkInheritance"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "checkInheritance"));
        }
        if (isInheritorFlags == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isInheritorFlags", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "checkInheritance"));
        }
        if (!checkInheritance) {
            return true;
        }
        int cachedFlag = isInheritorFlags.get(i);
        if (cachedFlag == 1) {
            return true;
        }
        if (cachedFlag == 2) {
            return false;
        }
        assert (cachedFlag == 0);
        boolean isReallyInherited = MethodUsagesSearcher.resolveInReadAction(project, () -> {
            if (candidate == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "lambda$checkInheritance$4"));
            }
            if (baseClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "lambda$checkInheritance$4"));
            }
            return candidate.isInheritor(baseClass, false);
        });
        isInheritorFlags.set(i, isReallyInherited ? 1 : 2);
        return isReallyInherited;
    }

    private static VirtualFile getJarFile(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "getJarFile"));
        }
        return ApplicationManager.getApplication().runReadAction(() -> {
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "lambda$getJarFile$5"));
            }
            return PsiUtil.getJarFile(aClass);
        });
    }

    private static enum CheckResult {
        CANDIDATE_REJECTED,
        PROCESSED_OK,
        PROCESSED_ABORT;

    }
}

