/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.impl.search.HighlightingCaches;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaOverridingMethodsSearcher
implements QueryExecutor<PsiMethod, OverridingMethodsSearch.SearchParameters> {
    @Override
    public boolean execute(@NotNull OverridingMethodsSearch.SearchParameters parameters, @NotNull Processor<PsiMethod> consumer) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/psi/impl/search/JavaOverridingMethodsSearcher", "execute"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/search/JavaOverridingMethodsSearcher", "execute"));
        }
        PsiMethod method = parameters.getMethod();
        Project project = ApplicationManager.getApplication().runReadAction(method::getProject);
        SearchScope searchScope = parameters.getScope();
        if (searchScope instanceof LocalSearchScope) {
            return JavaOverridingMethodsSearcher.processLocalScope((LocalSearchScope)searchScope, method, project, consumer);
        }
        Iterable<PsiMethod> cached = HighlightingCaches.getInstance((Project)project).OVERRIDING_METHODS.get(method);
        if (cached == null) {
            cached = JavaOverridingMethodsSearcher.compute(method, project);
            HighlightingCaches.getInstance((Project)project).OVERRIDING_METHODS.put(method, cached);
        }
        for (PsiMethod subMethod : cached) {
            ProgressManager.checkCanceled();
            if (!ApplicationManager.getApplication().runReadAction(() -> PsiSearchScopeUtil.isInScope(searchScope, (PsiElement)subMethod)).booleanValue() || consumer.process(subMethod) && parameters.isCheckDeep()) continue;
            return false;
        }
        return true;
    }

    private static boolean processLocalScope(@NotNull LocalSearchScope searchScope, final @NotNull PsiMethod method, final @NotNull Project project, final @NotNull Processor<PsiMethod> consumer) {
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/psi/impl/search/JavaOverridingMethodsSearcher", "processLocalScope"));
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/impl/search/JavaOverridingMethodsSearcher", "processLocalScope"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/search/JavaOverridingMethodsSearcher", "processLocalScope"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/search/JavaOverridingMethodsSearcher", "processLocalScope"));
        }
        VirtualFile[] virtualFiles = searchScope.getVirtualFiles();
        final PsiClass methodContainingClass = ApplicationManager.getApplication().runReadAction(method::getContainingClass);
        if (methodContainingClass == null) {
            return true;
        }
        final boolean[] success = new boolean[]{true};
        for (final VirtualFile virtualFile : virtualFiles) {
            ProgressManager.checkCanceled();
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    PsiFile psiFile = PsiManager.getInstance(project).findFile(virtualFile);
                    if (psiFile != null) {
                        psiFile.accept(new JavaRecursiveElementVisitor(){

                            @Override
                            public void visitClass(PsiClass candidate) {
                                PsiMethod overridingMethod;
                                ProgressManager.checkCanceled();
                                if (!success[0]) {
                                    return;
                                }
                                PsiMethod psiMethod = overridingMethod = candidate == methodContainingClass ? null : JavaOverridingMethodsSearcher.findOverridingMethod(project, candidate, method, methodContainingClass);
                                if (overridingMethod != null && !consumer.process(overridingMethod)) {
                                    success[0] = false;
                                } else {
                                    super.visitClass(candidate);
                                }
                            }
                        });
                    }
                }
            });
        }
        return success[0];
    }

    @NotNull
    private static Iterable<PsiMethod> compute(@NotNull PsiMethod method, @NotNull Project project) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/impl/search/JavaOverridingMethodsSearcher", "compute"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/search/JavaOverridingMethodsSearcher", "compute"));
        }
        LinkedHashSet<PsiMethod> result = new LinkedHashSet<PsiMethod>();
        Application application = ApplicationManager.getApplication();
        PsiClass containingClass = application.runReadAction(method::getContainingClass);
        assert (containingClass != null);
        Processor<PsiClass> inheritorsProcessor = inheritor -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/search/JavaOverridingMethodsSearcher", "lambda$compute$2"));
            }
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/impl/search/JavaOverridingMethodsSearcher", "lambda$compute$2"));
            }
            PsiMethod found = application.runReadAction(() -> {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/search/JavaOverridingMethodsSearcher", "lambda$null$1"));
                }
                if (method == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/impl/search/JavaOverridingMethodsSearcher", "lambda$null$1"));
                }
                return JavaOverridingMethodsSearcher.findOverridingMethod(project, inheritor, method, containingClass);
            });
            if (found != null) {
                result.add(found);
            }
            return true;
        };
        GlobalSearchScope allScope = GlobalSearchScope.allScope(project);
        boolean success = ClassInheritorsSearch.search(containingClass, allScope, true).forEach(inheritorsProcessor);
        assert (success);
        LinkedHashSet<PsiMethod> linkedHashSet = result;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/JavaOverridingMethodsSearcher", "compute"));
        }
        return linkedHashSet;
    }

    @Nullable
    private static PsiMethod findOverridingMethod(@NotNull Project project, @NotNull PsiClass inheritor, @NotNull PsiMethod method, @NotNull PsiClass methodContainingClass) {
        MethodSignature signature;
        PsiMethod derived;
        PsiClass superClass;
        PsiMethod found;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/search/JavaOverridingMethodsSearcher", "findOverridingMethod"));
        }
        if (inheritor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inheritor", "com/intellij/psi/impl/search/JavaOverridingMethodsSearcher", "findOverridingMethod"));
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/impl/search/JavaOverridingMethodsSearcher", "findOverridingMethod"));
        }
        if (methodContainingClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodContainingClass", "com/intellij/psi/impl/search/JavaOverridingMethodsSearcher", "findOverridingMethod"));
        }
        String name = method.getName();
        if (inheritor.findMethodsByName(name, false).length > 0 && (found = MethodSignatureUtil.findMethodBySuperSignature(inheritor, JavaOverridingMethodsSearcher.getSuperSignature(inheritor, methodContainingClass, method), false)) != null && JavaOverridingMethodsSearcher.isAcceptable(project, found, inheritor, method, methodContainingClass)) {
            return found;
        }
        if (methodContainingClass.isInterface() && !inheritor.isInterface() && (superClass = inheritor.getSuperClass()) != null && !superClass.isInheritor(methodContainingClass, true) && superClass.findMethodsByName(name, true).length > 0 && (derived = MethodSignatureUtil.findMethodInSuperClassBySignatureInDerived(inheritor, superClass, signature = JavaOverridingMethodsSearcher.getSuperSignature(inheritor, methodContainingClass, method), true)) != null && JavaOverridingMethodsSearcher.isAcceptable(project, derived, inheritor, method, methodContainingClass)) {
            return derived;
        }
        return null;
    }

    @NotNull
    private static MethodSignature getSuperSignature(PsiClass inheritor, @NotNull PsiClass parentClass, PsiMethod method) {
        if (parentClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentClass", "com/intellij/psi/impl/search/JavaOverridingMethodsSearcher", "getSuperSignature"));
        }
        PsiSubstitutor substitutor = TypeConversionUtil.getMaybeSuperClassSubstitutor(parentClass, inheritor, PsiSubstitutor.EMPTY, null);
        MethodSignature methodSignature = method.getSignature(substitutor != null ? substitutor : PsiSubstitutor.EMPTY);
        if (methodSignature == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/JavaOverridingMethodsSearcher", "getSuperSignature"));
        }
        return methodSignature;
    }

    private static boolean isAcceptable(@NotNull Project project, @NotNull PsiMethod found, @NotNull PsiClass foundContainingClass, @NotNull PsiMethod method, @NotNull PsiClass methodContainingClass) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/search/JavaOverridingMethodsSearcher", "isAcceptable"));
        }
        if (found == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "found", "com/intellij/psi/impl/search/JavaOverridingMethodsSearcher", "isAcceptable"));
        }
        if (foundContainingClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foundContainingClass", "com/intellij/psi/impl/search/JavaOverridingMethodsSearcher", "isAcceptable"));
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/impl/search/JavaOverridingMethodsSearcher", "isAcceptable"));
        }
        if (methodContainingClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodContainingClass", "com/intellij/psi/impl/search/JavaOverridingMethodsSearcher", "isAcceptable"));
        }
        return !found.hasModifierProperty("static") && (!method.hasModifierProperty("packageLocal") || JavaPsiFacade.getInstance(project).arePackagesTheSame(methodContainingClass, foundContainingClass));
    }
}

