/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.accessibility;

import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.SystemProperties;
import com.intellij.util.ui.accessibility.AccessibleContextAccessor;
import java.awt.Frame;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import javax.accessibility.AccessibleContext;

public class ScreenReader {
    public static final String SYSTEM_PROPERTY_KEY = "screenreader";
    public static final String ATK_WRAPPER = "org.GNOME.Accessibility.AtkWrapper";
    public static final String ACCESS_BRIDGE = "com.sun.java.accessibility.AccessBridge";

    public static boolean isActive() {
        if (SystemProperties.has(SYSTEM_PROPERTY_KEY)) {
            return SystemProperties.is(SYSTEM_PROPERTY_KEY);
        }
        if (Registry.is("ide.screenreader.autodetect.accessibility")) {
            for (Frame frame : Frame.getFrames()) {
                AccessibleContext frameContext;
                if (!(frame instanceof AccessibleContextAccessor) || (frameContext = ((AccessibleContextAccessor)((Object)frame)).getCurrentAccessibleContext()) == null) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isEnabled(String a11yClassName) {
        String[] paths = new String[]{System.getProperty("user.home") + File.separator + ".accessibility.properties", System.getProperty("java.home") + File.separator + "lib" + File.separator + "accessibility.properties"};
        Properties properties = new Properties();
        for (String path : paths) {
            try {
                FileInputStream in = new FileInputStream(new File(path));
                try {
                    properties.load(in);
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
            }
            catch (Exception ignore) {
                continue;
            }
            if (!properties.isEmpty()) break;
        }
        if (!properties.isEmpty()) {
            String classNames = System.getProperty("javax.accessibility.assistive_technologies");
            if (classNames == null) {
                classNames = properties.getProperty("assistive_technologies", null);
            }
            if (classNames != null && classNames.contains(a11yClassName)) {
                return true;
            }
        }
        return false;
    }
}

