/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.index;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.NullableFunction;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.IOUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.xml.index.IndexedRelevantResource;
import com.intellij.xml.index.XmlIndex;
import com.intellij.xml.index.XsdNamespaceBuilder;
import com.intellij.xml.util.XmlUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlNamespaceIndex
extends XmlIndex<XsdNamespaceBuilder> {
    public static final ID<String, XsdNamespaceBuilder> NAME = ID.create("XmlNamespaces");
    private static final String NULL_STRING = "\"\"";

    @Nullable
    public static String getNamespace(@NotNull VirtualFile file, Project project, PsiFile context) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/xml/index/XmlNamespaceIndex", "getNamespace"));
        }
        if (DumbService.isDumb(project) || context != null && XmlUtil.isStubBuilding()) {
            return XmlNamespaceIndex.computeNamespace(file);
        }
        List<XsdNamespaceBuilder> list = FileBasedIndex.getInstance().getValues(NAME, file.getUrl(), XmlNamespaceIndex.createFilter(project));
        return list.size() == 0 ? null : list.get(0).getNamespace();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static String computeNamespace(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/xml/index/XmlNamespaceIndex", "computeNamespace"));
        }
        InputStream stream = null;
        try {
            stream = file.getInputStream();
            String string = XsdNamespaceBuilder.computeNamespace(stream);
            return string;
        }
        catch (IOException e) {
            String string = null;
            return string;
        }
        finally {
            StreamUtil.closeStream(stream);
        }
    }

    public static List<IndexedRelevantResource<String, XsdNamespaceBuilder>> getResourcesByNamespace(String namespace, @NotNull Project project, @Nullable Module module) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xml/index/XmlNamespaceIndex", "getResourcesByNamespace"));
        }
        List<IndexedRelevantResource<String, XsdNamespaceBuilder>> resources = IndexedRelevantResource.getResources(NAME, namespace, module, project, null);
        Collections.sort(resources);
        return resources;
    }

    public static List<IndexedRelevantResource<String, XsdNamespaceBuilder>> getAllResources(@Nullable Module module, @NotNull Project project, @Nullable NullableFunction<List<IndexedRelevantResource<String, XsdNamespaceBuilder>>, IndexedRelevantResource<String, XsdNamespaceBuilder>> chooser) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xml/index/XmlNamespaceIndex", "getAllResources"));
        }
        return IndexedRelevantResource.getAllResources(NAME, module, project, chooser);
    }

    @Override
    @NotNull
    public ID<String, XsdNamespaceBuilder> getName() {
        ID<String, XsdNamespaceBuilder> iD = NAME;
        if (iD == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/index/XmlNamespaceIndex", "getName"));
        }
        return iD;
    }

    @Override
    @NotNull
    public DataIndexer<String, XsdNamespaceBuilder, FileContent> getIndexer() {
        DataIndexer<String, XsdNamespaceBuilder, FileContent> dataIndexer = new DataIndexer<String, XsdNamespaceBuilder, FileContent>(){

            @Override
            @NotNull
            public Map<String, XsdNamespaceBuilder> map(@NotNull FileContent inputData) {
                if (inputData == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputData", "com/intellij/xml/index/XmlNamespaceIndex$1", "map"));
                }
                XsdNamespaceBuilder builder = "dtd".equals(inputData.getFile().getExtension()) ? new XsdNamespaceBuilder(inputData.getFileName(), "", Collections.emptyList(), Collections.emptyList()) : XsdNamespaceBuilder.computeNamespace(CharArrayUtil.readerFromCharSequence(inputData.getContentAsText()));
                HashMap<String, XsdNamespaceBuilder> map = new HashMap<String, XsdNamespaceBuilder>(2);
                String namespace = builder.getNamespace();
                if (namespace != null) {
                    map.put(namespace, builder);
                }
                map.put(inputData.getFile().getUrl(), builder);
                HashMap<String, XsdNamespaceBuilder> hashMap = map;
                if (hashMap == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/index/XmlNamespaceIndex$1", "map"));
                }
                return hashMap;
            }
        };
        if (dataIndexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/index/XmlNamespaceIndex", "getIndexer"));
        }
        return dataIndexer;
    }

    @Override
    @NotNull
    public DataExternalizer<XsdNamespaceBuilder> getValueExternalizer() {
        DataExternalizer<XsdNamespaceBuilder> dataExternalizer = new DataExternalizer<XsdNamespaceBuilder>(){

            @Override
            public void save(@NotNull DataOutput out, XsdNamespaceBuilder value) throws IOException {
                if (out == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/xml/index/XmlNamespaceIndex$2", "save"));
                }
                IOUtil.writeUTF(out, value.getNamespace() != null ? value.getNamespace() : XmlNamespaceIndex.NULL_STRING);
                IOUtil.writeUTF(out, value.getVersion() != null ? value.getVersion() : XmlNamespaceIndex.NULL_STRING);
                IOUtil.writeStringList(out, value.getTags());
                IOUtil.writeStringList(out, value.getRootTags());
            }

            @Override
            public XsdNamespaceBuilder read(@NotNull DataInput in) throws IOException {
                String version;
                if (in == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/xml/index/XmlNamespaceIndex$2", "read"));
                }
                String namespace = IOUtil.readUTF(in);
                if (XmlNamespaceIndex.NULL_STRING.equals(namespace)) {
                    namespace = null;
                }
                if (XmlNamespaceIndex.NULL_STRING.equals(version = IOUtil.readUTF(in))) {
                    version = null;
                }
                return new XsdNamespaceBuilder(namespace, version, IOUtil.readStringList(in), IOUtil.readStringList(in));
            }
        };
        if (dataExternalizer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/index/XmlNamespaceIndex", "getValueExternalizer"));
        }
        return dataExternalizer;
    }

    @Override
    public int getVersion() {
        return 5;
    }

    @Nullable
    public static IndexedRelevantResource<String, XsdNamespaceBuilder> guessSchema(String namespace, final @Nullable String tagName, final @Nullable String version, @Nullable String schemaLocation, @Nullable Module module, @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xml/index/XmlNamespaceIndex", "guessSchema"));
        }
        List<IndexedRelevantResource<String, XsdNamespaceBuilder>> resources = XmlNamespaceIndex.getResourcesByNamespace(namespace, project, module);
        if (resources.isEmpty()) {
            return null;
        }
        if (resources.size() == 1) {
            return resources.get(0);
        }
        final String fileName = schemaLocation == null ? null : new File(schemaLocation).getName();
        IndexedRelevantResource<String, XsdNamespaceBuilder> resource = Collections.max(resources, new Comparator<IndexedRelevantResource<String, XsdNamespaceBuilder>>(){

            @Override
            public int compare(IndexedRelevantResource<String, XsdNamespaceBuilder> o1, IndexedRelevantResource<String, XsdNamespaceBuilder> o2) {
                int i;
                if (fileName != null && (i = Comparing.compare(fileName.equals(o1.getFile().getName()), fileName.equals(o2.getFile().getName()))) != 0) {
                    return i;
                }
                if (tagName != null && (i = Comparing.compare(o1.getValue().hasTag(tagName), o2.getValue().hasTag(tagName))) != 0) {
                    return i;
                }
                i = o1.compareTo(o2);
                if (i != 0) {
                    return i;
                }
                return o1.getValue().getRating(tagName, version) - o2.getValue().getRating(tagName, version);
            }
        });
        if (tagName != null && !resource.getValue().hasTag(tagName)) {
            return null;
        }
        return resource;
    }

    @Nullable
    public static XmlFile guessSchema(String namespace, @Nullable String tagName, @Nullable String version, @Nullable String schemaLocation, @NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/xml/index/XmlNamespaceIndex", "guessSchema"));
        }
        if (DumbService.isDumb(file.getProject()) || XmlUtil.isStubBuilding()) {
            return null;
        }
        IndexedRelevantResource<String, XsdNamespaceBuilder> resource = XmlNamespaceIndex.guessSchema(namespace, tagName, version, schemaLocation, ModuleUtilCore.findModuleForPsiElement(file), file.getProject());
        if (resource == null) {
            return null;
        }
        return XmlNamespaceIndex.findSchemaFile(resource.getFile(), file);
    }

    @Nullable
    private static XmlFile findSchemaFile(VirtualFile resourceFile, PsiFile baseFile) {
        PsiFile psiFile = baseFile.getManager().findFile(resourceFile);
        return psiFile instanceof XmlFile ? (XmlFile)psiFile : null;
    }

    @Nullable
    public static XmlFile guessDtd(String dtdUri, @NotNull PsiFile baseFile) {
        IndexedRelevantResource<String, XsdNamespaceBuilder> resource;
        if (baseFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseFile", "com/intellij/xml/index/XmlNamespaceIndex", "guessDtd"));
        }
        if (!dtdUri.endsWith(".dtd") || DumbService.isDumb(baseFile.getProject()) || XmlUtil.isStubBuilding()) {
            return null;
        }
        String dtdFileName = new File(dtdUri).getName();
        List<IndexedRelevantResource<String, XsdNamespaceBuilder>> list = XmlNamespaceIndex.getResourcesByNamespace(dtdFileName, baseFile.getProject(), ModuleUtilCore.findModuleForPsiElement(baseFile));
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() > 1) {
            final String[] split = dtdUri.split("/");
            resource = Collections.max(list, new Comparator<IndexedRelevantResource<String, XsdNamespaceBuilder>>(){

                @Override
                public int compare(IndexedRelevantResource<String, XsdNamespaceBuilder> o1, IndexedRelevantResource<String, XsdNamespaceBuilder> o2) {
                    return this.weight(o1) - this.weight(o2);
                }

                int weight(IndexedRelevantResource<String, XsdNamespaceBuilder> o1) {
                    VirtualFile file = o1.getFile();
                    for (int i = split.length - 1; i >= 0 && file != null; file = file.getParent(), --i) {
                        String s = split[i];
                        if (s.equals(file.getName())) continue;
                        return split.length - i;
                    }
                    return 0;
                }
            });
        } else {
            resource = list.get(0);
        }
        return XmlNamespaceIndex.findSchemaFile(resource.getFile(), baseFile);
    }
}

